/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.blay09.mods.balm.api.network.ClientboundMessageRegistration;
import net.blay09.mods.balm.api.network.MessageRegistration;
import net.blay09.mods.balm.api.network.ServerboundMessageRegistration;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FabricBalmNetworking
implements BalmNetworking {
    private static final Map<class_8710.class_9154<? extends class_8710>, MessageRegistration<class_9129, ? extends class_8710>> messagesByType = new HashMap<class_8710.class_9154<? extends class_8710>, MessageRegistration<class_9129, ? extends class_8710>>();
    private final Set<String> registeredMods = new HashSet<String>();
    private final Set<String> clientOnlyMods = new HashSet<String>();
    private final Set<String> serverOnlyMods = new HashSet<String>();
    private static PacketSender replyPacketSender;

    public Set<String> getRegisteredMods() {
        return this.registeredMods;
    }

    public boolean isClientOnly(String modId) {
        return this.clientOnlyMods.contains(modId);
    }

    public boolean isServerOnly(String modId) {
        return this.serverOnlyMods.contains(modId);
    }

    @Override
    public void allowClientOnly(String modId) {
        this.clientOnlyMods.add(modId);
    }

    @Override
    public void allowServerOnly(String modId) {
        this.serverOnlyMods.add(modId);
    }

    @Override
    public void openGui(class_1657 player, class_3908 menuProvider) {
        if (menuProvider instanceof BalmMenuProvider) {
            final BalmMenuProvider balmMenuProvider = (BalmMenuProvider)menuProvider;
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory<Object>(this){

                public Object getScreenOpeningData(class_3222 player) {
                    return balmMenuProvider.getScreenOpeningData(player);
                }

                public class_2561 method_5476() {
                    return balmMenuProvider.method_5476();
                }

                @Nullable
                public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    return balmMenuProvider.createMenu(i, inventory, player);
                }
            });
        } else {
            player.method_17355(menuProvider);
        }
    }

    @Override
    public <T extends class_8710> void reply(T message) {
        if (replyPacketSender == null) {
            throw new IllegalStateException("No context to reply to");
        }
        replyPacketSender.sendPacket(message);
    }

    @Override
    public <T extends class_8710> void sendTo(class_1657 player, T message) {
        ServerPlayNetworking.send((class_3222)((class_3222)player), message);
    }

    @Override
    public <T extends class_8710> void sendToTracking(class_3218 world, class_2338 pos, T message) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)pos)) {
            ServerPlayNetworking.send((class_3222)player, message);
        }
    }

    @Override
    public <T extends class_8710> void sendToTracking(class_1297 entity, T message) {
        for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
            ServerPlayNetworking.send((class_3222)player, message);
        }
    }

    @Override
    public <T extends class_8710> void sendToAll(MinecraftServer server, T message) {
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)player, message);
        }
    }

    @Override
    public <T extends class_8710> void sendToServer(T message) {
        ClientPlayNetworking.send(message);
    }

    @Override
    public <T extends class_8710> void registerClientboundPacket(class_8710.class_9154<T> type, Class<T> clazz, BiConsumer<class_9129, T> encodeFunc, Function<class_9129, T> decodeFunc, BiConsumer<class_1657, T> handler) {
        this.registeredMods.add(type.comp_2242().method_12836());
        ClientboundMessageRegistration<class_9129, T> messageRegistration = new ClientboundMessageRegistration<class_9129, T>(type, clazz, encodeFunc, decodeFunc, handler);
        PayloadTypeRegistry.playS2C().register(type, messageRegistration.getCodec());
        messagesByType.put(type, messageRegistration);
    }

    @Override
    public <T extends class_8710> void registerServerboundPacket(class_8710.class_9154<T> type, Class<T> clazz, BiConsumer<class_9129, T> encodeFunc, Function<class_9129, T> decodeFunc, BiConsumer<class_3222, T> handler) {
        this.registeredMods.add(type.comp_2242().method_12836());
        ServerboundMessageRegistration<class_9129, T> messageRegistration = new ServerboundMessageRegistration<class_9129, T>(type, clazz, encodeFunc, decodeFunc, handler);
        messagesByType.put(type, messageRegistration);
        PayloadTypeRegistry.playC2S().register(type, messageRegistration.getCodec());
        ServerPlayNetworking.registerGlobalReceiver(type, (payload, context) -> context.player().method_5682().execute(() -> {
            replyPacketSender = context.responseSender();
            handler.accept(context.player(), payload);
            replyPacketSender = null;
        }));
    }

    public static void initializeClientHandlers() {
        for (MessageRegistration<class_9129, ? extends class_8710> messageRegistration : messagesByType.values()) {
            if (!(messageRegistration instanceof ClientboundMessageRegistration)) continue;
            ClientboundMessageRegistration clientboundMessageRegistration = (ClientboundMessageRegistration)messageRegistration;
            FabricBalmNetworking.registerClientHandler(clientboundMessageRegistration);
        }
    }

    private static <TPayload extends class_8710> void registerClientHandler(ClientboundMessageRegistration<class_9129, TPayload> messageRegistration) {
        class_8710.class_9154 type = messageRegistration.getType();
        BiConsumer handler = messageRegistration.getHandler();
        ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> context.client().execute(() -> handler.accept((class_1657)context.player(), (Object)payload)));
    }
}

