/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.mixin;

import java.util.OptionalInt;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.blay09.mods.balm.api.event.PlayerOpenMenuEvent;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public class ServerPlayerMixin {
    @Unique
    private static final ThreadLocal<class_5321<class_1937>> fromDimHolder = new ThreadLocal();

    @Inject(method={"openMenu(Lnet/minecraft/world/MenuProvider;)Ljava/util/OptionalInt;"}, at={@At(value="RETURN")})
    public void openMenu(@Nullable class_3908 menuProvider, CallbackInfoReturnable<OptionalInt> callbackInfo) {
        class_3222 player = (class_3222)this;
        Balm.getEvents().fireEvent(new PlayerOpenMenuEvent(player, player.field_7512));
    }

    @Inject(method={"changeDimension(Lnet/minecraft/world/level/portal/DimensionTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="HEAD")})
    public void changeDimensionHead(class_5454 transition, CallbackInfoReturnable<class_1297> callbackInfo) {
        class_3222 player = (class_3222)this;
        fromDimHolder.set((class_5321<class_1937>)player.method_37908().method_27983());
    }

    @Inject(method={"changeDimension(Lnet/minecraft/world/level/portal/DimensionTransition;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")})
    public void changeDimensionTail(class_5454 transition, CallbackInfoReturnable<class_1297> callbackInfo) {
        class_3222 player = (class_3222)this;
        class_5321<class_1937> fromDim = fromDimHolder.get();
        class_5321 toDim = transition.comp_2820().method_27983();
        Balm.getEvents().fireEvent(new PlayerChangedDimensionEvent(player, fromDim, (class_5321<class_1937>)toDim));
    }

    @Inject(method={"drop(Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void drop(boolean flag, CallbackInfoReturnable<Boolean> callbackInfo) {
        class_3222 player = (class_3222)this;
        class_1661 inventory = player.method_31548();
        class_1799 selected = inventory.method_7391();
        TossItemEvent event = new TossItemEvent((class_1657)player, selected);
        Balm.getEvents().fireEvent(event);
        if (event.isCanceled()) {
            callbackInfo.setReturnValue((Object)false);
        }
    }
}

