/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.block.entity.OnLoadHandler;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.menu.WaystoneEditMenu;
import net.blay09.mods.waystones.menu.WaystoneModifierMenu;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockEntityBase
extends BalmBlockEntity
implements OnLoadHandler,
CustomRenderBoundingBox,
BalmContainerProvider {
    protected final DefaultContainer container = new DefaultContainer(5){

        public int method_58350(class_1799 itemStack) {
            if (itemStack.method_31574(ModItems.dormantShard)) {
                return 1;
            }
            return super.method_58350(itemStack);
        }

        public boolean method_5437(int slot, class_1799 itemStack) {
            if (itemStack.method_31574(ModItems.dormantShard)) {
                return slot == 0;
            }
            return super.method_5437(slot, itemStack);
        }

        public void method_5431() {
            WaystoneBlockEntityBase.this.onInventoryChanged();
        }

        public boolean method_5443(class_1657 player) {
            return class_1263.method_49105((class_2586)WaystoneBlockEntityBase.this, (class_1657)player);
        }
    };
    private Waystone waystone = InvalidWaystone.INSTANCE;
    private UUID waystoneUid;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    protected void onInventoryChanged() {
    }

    public WaystoneBlockEntityBase(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10566("Items", (class_2520)this.container.serialize(provider));
        if (this.waystone.isValid()) {
            tag.method_10566("UUID", (class_2520)class_2512.method_25929((UUID)this.waystone.getWaystoneUid()));
        } else if (this.waystoneUid != null) {
            tag.method_10566("UUID", (class_2520)class_2512.method_25929((UUID)this.waystoneUid));
        }
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 provider) {
        if (compound.method_10545("Items")) {
            this.container.deserialize(compound.method_10562("Items"), provider);
        }
        if (compound.method_10573("UUID", 11)) {
            this.waystoneUid = class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("UUID")));
        }
        if (compound.method_10573("Waystone", 10)) {
            Waystone syncedWaystone = WaystoneImpl.read(compound.method_10562("Waystone"), provider);
            WaystoneManagerImpl.get(null).updateWaystone(syncedWaystone);
            this.waystone = new WaystoneProxy(null, syncedWaystone.getWaystoneUid());
        }
    }

    protected void method_57568(class_2586.class_9473 input) {
        UUID waystoneUidComponent = (UUID)input.method_58694((class_9331)ModComponents.waystone.get());
        if (waystoneUidComponent != null) {
            this.waystoneUid = waystoneUidComponent;
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        builder.method_57840((class_9331)ModComponents.waystone.get(), (Object)(this.waystone.isValid() ? this.waystone.getWaystoneUid() : this.waystoneUid));
    }

    public void writeUpdateTag(class_2487 tag) {
        tag.method_10566("Waystone", (class_2520)WaystoneImpl.write(this.getWaystone(), new class_2487(), (class_7225.class_7874)this.field_11863.method_30349()));
    }

    public void onLoad() {
        Waystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof WaystoneImpl && this.field_11863 != null) {
            ((WaystoneImpl)backingWaystone).setDimension((class_5321<class_1937>)this.field_11863.method_27983());
            ((WaystoneImpl)backingWaystone).setPos(this.field_11867);
        }
        this.sync();
    }

    public class_238 getRenderBoundingBox() {
        return new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 2), (double)(this.field_11867.method_10260() + 1));
    }

    public Waystone getWaystone() {
        if (!(this.waystone.isValid() || this.field_11863 == null || this.field_11863.field_9236 || this.shouldNotInitialize)) {
            class_2680 state;
            if (this.waystoneUid != null) {
                this.waystone = new WaystoneProxy(this.field_11863.method_8503(), this.waystoneUid);
            }
            if (!this.waystone.isValid() && (state = this.method_11010()).method_26204() instanceof WaystoneBlockBase) {
                class_2586 blockEntity;
                WaystoneOrigin origin;
                class_2756 half = state.method_28498(WaystoneBlockBase.HALF) ? (class_2756)state.method_11654(WaystoneBlockBase.HALF) : class_2756.field_12607;
                WaystoneOrigin waystoneOrigin = origin = state.method_28498(WaystoneBlockBase.ORIGIN) ? (WaystoneOrigin)((Object)state.method_11654(WaystoneBlockBase.ORIGIN)) : WaystoneOrigin.UNKNOWN;
                if (half == class_2756.field_12607) {
                    this.initializeWaystone((class_5425)Objects.requireNonNull(this.field_11863), null, origin);
                } else if (half == class_2756.field_12609 && (blockEntity = this.field_11863.method_8321(this.field_11867.method_10074())) instanceof WaystoneBlockEntityBase) {
                    this.initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (this.waystone.isValid()) {
                this.waystoneUid = this.waystone.getWaystoneUid();
                this.sync();
            }
        }
        return this.waystone;
    }

    protected abstract class_2960 getWaystoneType();

    public void initializeWaystone(class_5425 world, @Nullable class_1309 player, WaystoneOrigin origin) {
        WaystoneImpl waystone = new WaystoneImpl(this.getWaystoneType(), UUID.randomUUID(), (class_5321<class_1937>)world.method_8410().method_27983(), this.field_11867, origin, player != null ? player.method_5667() : null);
        WaystoneManagerImpl.get(world.method_8503()).addWaystone(waystone);
        this.waystone = waystone;
        this.method_5431();
        this.sync();
    }

    public void initializeFromExisting(class_5425 world, WaystoneImpl existingWaystone, class_1799 itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((class_5321<class_1937>)world.method_8410().method_27983());
        existingWaystone.setPos(this.field_11867);
        existingWaystone.setTransient(false);
        WaystoneManagerImpl.get(world.method_8503()).updateWaystone(this.waystone);
        this.method_5431();
        this.sync();
    }

    public void initializeFromBase(WaystoneBlockEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
        this.method_5431();
        this.sync();
    }

    public void uninitializeWaystone() {
        if (this.waystone.isValid()) {
            WaystoneManagerImpl.get(this.field_11863.method_8503()).removeWaystone(this.waystone);
            PlayerWaystoneManager.removeKnownWaystone(this.field_11863.method_8503(), this.waystone);
            WaystoneSyncManager.sendWaystoneRemovalToAll(this.field_11863.method_8503(), this.waystone, true);
        }
        this.waystone = InvalidWaystone.INSTANCE;
        this.shouldNotInitialize = true;
        class_2756 half = (class_2756)this.method_11010().method_11654((class_2769)WaystoneBlock.HALF);
        class_2338 otherPos = half == class_2756.field_12609 ? this.field_11867.method_10074() : this.field_11867.method_10084();
        class_2586 blockEntity = Objects.requireNonNull(this.field_11863).method_8321(otherPos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneTile = (WaystoneBlockEntityBase)blockEntity;
            waystoneTile.waystone = InvalidWaystone.INSTANCE;
            waystoneTile.shouldNotInitialize = true;
        }
        this.method_5431();
        this.sync();
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public Optional<class_3908> getSelectionMenuProvider() {
        return Optional.empty();
    }

    public abstract class_2561 getName();

    public Optional<class_3908> getSettingsMenuProvider() {
        return Optional.of(new BalmMenuProvider<WaystoneEditMenu.Data>(){

            public class_2561 method_5476() {
                return class_2561.method_43469((String)"container.waystones.waystone_settings", (Object[])new Object[]{WaystoneBlockEntityBase.this.getName()});
            }

            public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 player) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone(player, player.method_37908(), WaystoneBlockEntityBase.this.getWaystone());
                return new WaystoneEditMenu(i, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getModifierCount(), error.map(WaystoneEditError::getTranslationKey).map(class_2561::method_43471).orElse(null), WaystoneBlockEntityBase.this.getContainer());
            }

            public WaystoneEditMenu.Data getScreenOpeningData(class_3222 serverPlayer) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone((class_1657)serverPlayer, serverPlayer.method_37908(), WaystoneBlockEntityBase.this.getWaystone());
                return new WaystoneEditMenu.Data(WaystoneBlockEntityBase.this.field_11867, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getModifierCount(), error.map(WaystoneEditError::getTranslationKey).map(class_2561::method_43471));
            }

            public class_9139<class_9129, WaystoneEditMenu.Data> getScreenStreamCodec() {
                return WaystoneEditMenu.STREAM_CODEC;
            }
        });
    }

    public Optional<class_3908> getModifierMenuProvider() {
        return Optional.of(new BalmMenuProvider<Waystone>(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)"container.waystones.waystone_modifiers");
            }

            public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 player) {
                return new WaystoneModifierMenu(i, playerInventory, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getContainer());
            }

            public Waystone getScreenOpeningData(class_3222 serverPlayer) {
                return WaystoneBlockEntityBase.this.getWaystone();
            }

            public class_9139<class_9129, Waystone> getScreenStreamCodec() {
                return WaystoneImpl.STREAM_CODEC;
            }
        });
    }

    public Collection<? extends Waystone> getAuxiliaryTargets() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1799 item = this.container.method_5438(i);
            WaystonesAPI.getBoundWaystone(null, item).ifPresent(result::add);
        }
        return result;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public void applyModifierEffects(class_1297 entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<class_1799> curativeItems = new ArrayList<class_1799>();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1799 itemStack = this.container.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_8183) {
                fireSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8635) {
                poisonSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8794) {
                blindSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8103 || itemStack.method_7909() == class_1802.field_21086) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8477) {
                potency = Math.min(4, potency + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8153) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8135) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_17515) continue;
            witherSeconds += itemStack.method_7947();
        }
        if (entity instanceof class_1309) {
            if (fireSeconds > 0) {
                entity.method_20803(fireSeconds * 20);
            }
            if (poisonSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5899, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5919, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5906, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5918, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5920, witherSeconds * 20, potency));
            }
            for (class_1799 curativeItem : curativeItems) {
                Balm.getHooks().curePotionEffects((class_1309)entity, curativeItem);
            }
        }
    }

    private int getModifierCount() {
        int modifiers = 0;
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1799 itemStack = this.container.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_8183) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8635) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8794) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8103 || itemStack.method_7909() == class_1802.field_21086) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8477) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8153) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8135) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_17515) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8155) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_8680) continue;
            ++modifiers;
        }
        return modifiers;
    }
}

