/*
 * Decompiled with CFR 0.152.
 */
package com.metacontent.cobblenav.spawndata.collector;

import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.context.AreaSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.metacontent.cobblenav.Cobblenav;
import com.metacontent.cobblenav.spawndata.collector.BlockConditionCollector;
import com.metacontent.cobblenav.spawndata.collector.ConditionCollector;
import com.metacontent.cobblenav.spawndata.collector.ConfigureableCollector;
import com.metacontent.cobblenav.spawndata.collector.block.AreaTypeBlockCollector;
import com.metacontent.cobblenav.spawndata.collector.block.FishingBlockCollector;
import com.metacontent.cobblenav.spawndata.collector.block.GroundedTypeBlockCollector;
import com.metacontent.cobblenav.spawndata.collector.block.SeafloorTypeBlockCollector;
import com.metacontent.cobblenav.spawndata.collector.general.BiomeCollector;
import com.metacontent.cobblenav.spawndata.collector.general.CoordinatesCollector;
import com.metacontent.cobblenav.spawndata.collector.general.GeneralConditionCollector;
import com.metacontent.cobblenav.spawndata.collector.general.LightCollector;
import com.metacontent.cobblenav.spawndata.collector.general.MoonPhaseCollector;
import com.metacontent.cobblenav.spawndata.collector.general.SkyLightCollector;
import com.metacontent.cobblenav.spawndata.collector.general.SlimeChunkCollector;
import com.metacontent.cobblenav.spawndata.collector.general.StructureCollector;
import com.metacontent.cobblenav.spawndata.collector.general.TimeRangeCollector;
import com.metacontent.cobblenav.spawndata.collector.general.UnderOpenSkyCollector;
import com.metacontent.cobblenav.spawndata.collector.general.WeatherCollector;
import com.metacontent.cobblenav.spawndata.collector.general.YHeightCollector;
import com.metacontent.cobblenav.spawndata.collector.special.BaitCollector;
import com.metacontent.cobblenav.spawndata.collector.special.DepthSubmergedCollector;
import com.metacontent.cobblenav.spawndata.collector.special.DepthSurfaceCollector;
import com.metacontent.cobblenav.spawndata.collector.special.FluidSubmergedCollector;
import com.metacontent.cobblenav.spawndata.collector.special.FluidSurfaceCollector;
import com.metacontent.cobblenav.spawndata.collector.special.LureLevelCollector;
import com.metacontent.cobblenav.spawndata.collector.special.RodCollector;
import com.metacontent.cobblenav.spawndata.collector.special.RodTypeCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\r\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0004\b\r\u0010\u000eJ1\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\u0012\"\f\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J1\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u0012\"\f\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J5\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0006\u00a2\u0006\u0004\b#\u0010\u0003R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001e\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u001e\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010&\u00a8\u0006)"}, d2={"Lcom/metacontent/cobblenav/spawndata/collector/ConditionCollectors;", "", "<init>", "()V", "Lcom/metacontent/cobblenav/spawndata/collector/general/GeneralConditionCollector;", "collector", "", "registerGeneral", "(Lcom/metacontent/cobblenav/spawndata/collector/general/GeneralConditionCollector;)V", "Lcom/metacontent/cobblenav/spawndata/collector/ConditionCollector;", "register", "(Lcom/metacontent/cobblenav/spawndata/collector/ConditionCollector;)V", "Lcom/metacontent/cobblenav/spawndata/collector/BlockConditionCollector;", "registerBlock", "(Lcom/metacontent/cobblenav/spawndata/collector/BlockConditionCollector;)V", "Lcom/cobblemon/mod/common/api/spawning/condition/SpawningCondition;", "T", "condition", "", "getCollectors", "(Lcom/cobblemon/mod/common/api/spawning/condition/SpawningCondition;)Ljava/util/List;", "getBlockCollectors", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "fittingContexts", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_5250;", "collectConditions", "(Lcom/cobblemon/mod/common/api/spawning/condition/SpawningCondition;Ljava/util/List;Lnet/minecraft/class_3222;)Ljava/util/List;", "Lcom/cobblemon/mod/common/api/spawning/context/AreaSpawningContext;", "contexts", "", "Lnet/minecraft/class_2960;", "collectBlockConditions", "(Lcom/cobblemon/mod/common/api/spawning/condition/SpawningCondition;Ljava/util/List;)Ljava/util/Set;", "init", "", "generalCollectors", "Ljava/util/List;", "collectors", "blockCollectors", "cobblenav-common"})
@SourceDebugExtension(value={"SMAP\nConditionCollectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConditionCollectors.kt\ncom/metacontent/cobblenav/spawndata/collector/ConditionCollectors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n774#2:106\n865#2,2:107\n808#2,11:109\n774#2:120\n865#2,2:121\n808#2,11:123\n1611#2,9:134\n1863#2:143\n1864#2:145\n1620#2:146\n1611#2,9:147\n1863#2:156\n1864#2:158\n1620#2:159\n1368#2:160\n1454#2,5:161\n1#3:144\n1#3:157\n*S KotlinDebug\n*F\n+ 1 ConditionCollectors.kt\ncom/metacontent/cobblenav/spawndata/collector/ConditionCollectors\n*L\n55#1:106\n55#1:107,2\n55#1:109,11\n59#1:120\n59#1:121,2\n59#1:123,11\n67#1:134,9\n67#1:143\n67#1:145\n67#1:146\n68#1:147,9\n68#1:156\n68#1:158\n68#1:159\n75#1:160\n75#1:161,5\n67#1:144\n68#1:157\n*E\n"})
public final class ConditionCollectors {
    @NotNull
    public static final ConditionCollectors INSTANCE = new ConditionCollectors();
    @NotNull
    private static final List<GeneralConditionCollector> generalCollectors = new ArrayList();
    @NotNull
    private static final List<ConditionCollector<?>> collectors = new ArrayList();
    @NotNull
    private static final List<BlockConditionCollector<?>> blockCollectors = new ArrayList();

    private ConditionCollectors() {
    }

    public final void registerGeneral(@NotNull GeneralConditionCollector collector) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (!collector.allowed(Cobblenav.INSTANCE.getConfig().getCollectableConditions())) {
            return;
        }
        if (!collector.isModDependencySatisfied()) {
            return;
        }
        ((Collection)generalCollectors).add(collector);
        Cobblenav.INSTANCE.getLOGGER().info("Registered general collector: " + collector.getClass().getSimpleName());
    }

    public final void register(@NotNull ConditionCollector<?> collector) {
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        if (collector instanceof ConfigureableCollector && !((ConfigureableCollector)((Object)collector)).allowed(Cobblenav.INSTANCE.getConfig().getCollectableConditions())) {
            return;
        }
        if (!collector.isModDependencySatisfied()) {
            return;
        }
        ((Collection)collectors).add(collector);
        Cobblenav.INSTANCE.getLOGGER().info("Registered collector: " + collector.getClass().getSimpleName());
    }

    public final void registerBlock(@NotNull BlockConditionCollector<?> collector) {
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        if (collector instanceof ConfigureableCollector && !((ConfigureableCollector)((Object)collector)).allowed(Cobblenav.INSTANCE.getConfig().getCollectableConditions())) {
            return;
        }
        if (!collector.isModDependencySatisfied()) {
            return;
        }
        ((Collection)blockCollectors).add(collector);
        Cobblenav.INSTANCE.getLOGGER().info("Registered block collector: " + collector.getClass().getSimpleName());
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends SpawningCondition<?>> List<ConditionCollector<T>> getCollectors(T condition) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = collectors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConditionCollector it = (ConditionCollector)element$iv$iv;
            boolean bl = false;
            if (!it.supports(condition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ConditionCollector)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends SpawningCondition<?>> List<BlockConditionCollector<T>> getBlockCollectors(T condition) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = blockCollectors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BlockConditionCollector it = (BlockConditionCollector)element$iv$iv;
            boolean bl = false;
            if (!it.supports(condition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BlockConditionCollector)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<class_5250> collectConditions(@NotNull SpawningCondition<?> condition, @NotNull List<? extends SpawningContext> fittingContexts, @NotNull class_3222 player) {
        class_5250 it$iv$iv;
        boolean bl;
        ConditionCollector<SpawningCondition<?>> it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(fittingContexts, (String)"fittingContexts");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$mapNotNull$iv = generalCollectors;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (GeneralConditionCollector)element$iv$iv;
            boolean bl3 = false;
            if (it.collect(condition, fittingContexts, player) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = this.getCollectors(condition);
        Collection collection = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (ConditionCollector)element$iv$iv;
            boolean bl4 = false;
            if (it.collect(condition, fittingContexts, player) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<class_2960> collectBlockConditions(@NotNull SpawningCondition<?> condition, @NotNull List<? extends AreaSpawningContext> contexts) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        Iterable $this$flatMap$iv = this.getBlockCollectors(condition);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            BlockConditionCollector it = (BlockConditionCollector)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.collect(condition, contexts);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void init() {
        this.registerGeneral(new BiomeCollector());
        this.registerGeneral(new MoonPhaseCollector());
        this.registerGeneral(new UnderOpenSkyCollector());
        this.registerGeneral(new YHeightCollector());
        this.registerGeneral(new CoordinatesCollector());
        this.registerGeneral(new LightCollector());
        this.registerGeneral(new SkyLightCollector());
        this.registerGeneral(new WeatherCollector());
        this.registerGeneral(new TimeRangeCollector());
        this.registerGeneral(new StructureCollector());
        this.registerGeneral(new SlimeChunkCollector());
        this.register(new FluidSurfaceCollector());
        this.register(new DepthSurfaceCollector());
        this.register(new FluidSubmergedCollector());
        this.register(new DepthSubmergedCollector());
        this.register(new BaitCollector());
        this.register(new LureLevelCollector());
        this.register(new RodCollector());
        this.register(new RodTypeCollector());
        this.registerBlock(new AreaTypeBlockCollector());
        this.registerBlock(new GroundedTypeBlockCollector());
        this.registerBlock(new SeafloorTypeBlockCollector());
        this.registerBlock(new FishingBlockCollector());
    }
}

