/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.DropRuleEvent;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_7225;

public class AccessoriesCompat
implements InvModCompat<Map<String, AccessoriesInventoryGroup>> {
    @Override
    public String getModName() {
        return "accessories";
    }

    @Override
    public void clear(class_3222 player) {
        AccessoriesCapability.getOptionally((class_1309)player).ifPresent(inv -> inv.reset(false));
    }

    @Override
    public CompatComponent<Map<String, AccessoriesInventoryGroup>> readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        HashMap<String, AccessoriesInventoryGroup> inventory = new HashMap<String, AccessoriesInventoryGroup>();
        for (String key : nbt.method_10541()) {
            class_2487 slotNbt = nbt.method_10562(key);
            class_2371<AccessoriesInventorySlot> normalSlot = InventoryComponent.listFromNbt(slotNbt.method_10562("normal"), itemNbt -> {
                String dropRuleString;
                class_1799 stack = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)itemNbt).orElse(class_1799.field_8037);
                com.b1n_ry.yigd.util.DropRule dropRule = itemNbt.method_10545("dropRule") ? ((dropRuleString = itemNbt.method_10558("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule : com.b1n_ry.yigd.util.DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                boolean visible = !itemNbt.method_10545("visible") || itemNbt.method_10577("visible");
                return new AccessoriesInventorySlot(stack, dropRule, visible);
            }, AccessoriesInventorySlot.EMPTY);
            class_2371<AccessoriesInventorySlot> cosmeticSlot = InventoryComponent.listFromNbt(slotNbt.method_10562("cosmetic"), itemNbt -> {
                String dropRuleString;
                class_1799 stack = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)itemNbt).orElse(class_1799.field_8037);
                com.b1n_ry.yigd.util.DropRule dropRule = itemNbt.method_10545("dropRule") ? ((dropRuleString = itemNbt.method_10558("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule : com.b1n_ry.yigd.util.DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                boolean visible = !itemNbt.method_10545("visible") || itemNbt.method_10577("visible");
                return new AccessoriesInventorySlot(stack, dropRule, visible);
            }, AccessoriesInventorySlot.EMPTY);
            inventory.put(key, new AccessoriesInventoryGroup(normalSlot, cosmeticSlot));
        }
        return new AccessoriesCompatComponent((Map<String, AccessoriesInventoryGroup>)inventory);
    }

    @Override
    public CompatComponent<Map<String, AccessoriesInventoryGroup>> getNewComponent(class_3222 player) {
        return new AccessoriesCompatComponent(player);
    }

    public static class AccessoriesInventorySlot {
        public class_1799 stack;
        public com.b1n_ry.yigd.util.DropRule dropRule;
        public boolean visible;
        public static AccessoriesInventorySlot EMPTY = new AccessoriesInventorySlot(class_1799.field_8037, com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, true);

        public AccessoriesInventorySlot(class_1799 stack, com.b1n_ry.yigd.util.DropRule dropRule, boolean visible) {
            this.stack = stack;
            this.dropRule = dropRule;
            this.visible = visible;
        }
    }

    public record AccessoriesInventoryGroup(class_2371<AccessoriesInventorySlot> normal, class_2371<AccessoriesInventorySlot> cosmetic) {
        private void addAllNonEmptyToList(Collection<class_1799> list) {
            for (AccessoriesInventorySlot slot : this.normal) {
                if (slot.stack.method_7960()) continue;
                list.add(slot.stack.method_7972());
            }
            for (AccessoriesInventorySlot slot : this.cosmetic) {
                if (slot.stack.method_7960()) continue;
                list.add(slot.stack.method_7972());
            }
        }
    }

    private static class AccessoriesCompatComponent
    extends CompatComponent<Map<String, AccessoriesInventoryGroup>> {
        public AccessoriesCompatComponent(class_3222 player) {
            super(player);
        }

        public AccessoriesCompatComponent(Map<String, AccessoriesInventoryGroup> inventory) {
            super(inventory);
        }

        @Override
        public Map<String, AccessoriesInventoryGroup> getInventory(class_3222 player) {
            HashMap<String, AccessoriesInventoryGroup> inventory = new HashMap<String, AccessoriesInventoryGroup>();
            AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
            if (capability == null) {
                return inventory;
            }
            Map containers = capability.getContainers();
            for (Map.Entry entry : containers.entrySet()) {
                int i;
                class_2371 normalSlot = class_2371.method_10211();
                class_2371 cosmeticSlot = class_2371.method_10211();
                AccessoriesContainer container = (AccessoriesContainer)entry.getValue();
                ExpandedSimpleContainer normal = container.getAccessories();
                ExpandedSimpleContainer cosmetic = container.getCosmeticAccessories();
                for (i = 0; i < normal.method_5439(); ++i) {
                    normalSlot.add((Object)new AccessoriesInventorySlot(normal.method_5438(i).method_7972(), com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, true));
                }
                for (i = 0; i < cosmetic.method_5439(); ++i) {
                    boolean shouldRender = container.shouldRender(i);
                    cosmeticSlot.add((Object)new AccessoriesInventorySlot(cosmetic.method_5438(i).method_7972(), com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, shouldRender));
                }
                inventory.put((String)entry.getKey(), new AccessoriesInventoryGroup((class_2371<AccessoriesInventorySlot>)normalSlot, (class_2371<AccessoriesInventorySlot>)cosmeticSlot));
            }
            return inventory;
        }

        @Override
        public class_2371<class_1799> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            class_2371 extraItems = class_2371.method_10211();
            Map mergingInventory = (Map)mergingComponent.inventory;
            for (Map.Entry mergeEntry : mergingInventory.entrySet()) {
                class_1799 thisStack;
                AccessoriesInventorySlot currentPair;
                class_1799 mergingStack;
                AccessoriesInventorySlot mergingPair;
                int i;
                String key = (String)mergeEntry.getKey();
                if (!((Map)this.inventory).containsKey(key)) {
                    ((AccessoriesInventoryGroup)mergeEntry.getValue()).addAllNonEmptyToList((Collection<class_1799>)extraItems);
                    continue;
                }
                AccessoriesInventoryGroup mergingSlot = (AccessoriesInventoryGroup)mergeEntry.getValue();
                AccessoriesInventoryGroup thisSlot = (AccessoriesInventoryGroup)((Map)this.inventory).get(key);
                for (i = 0; i < mergingSlot.normal.size(); ++i) {
                    mergingPair = (AccessoriesInventorySlot)mergingSlot.normal.get(i);
                    mergingStack = mergingPair.stack.method_7972();
                    if (mergingStack.method_7960()) continue;
                    if (thisSlot.normal.size() <= i) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    currentPair = (AccessoriesInventorySlot)thisSlot.normal.get(i);
                    thisStack = currentPair.stack;
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && !AccessoriesAPI.canUnequip((class_1799)mergingStack, (SlotReference)SlotReference.of((class_1309)merger, (String)key, (int)i))) {
                        extraItems.add((Object)currentPair.stack);
                        thisSlot.normal.set(i, (Object)new AccessoriesInventorySlot(mergingStack, mergingPair.dropRule, mergingPair.visible));
                        continue;
                    }
                    if (!thisStack.method_7960()) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    thisSlot.normal.set(i, (Object)mergingPair);
                }
                for (i = 0; i < mergingSlot.cosmetic.size(); ++i) {
                    mergingPair = (AccessoriesInventorySlot)mergingSlot.cosmetic.get(i);
                    mergingStack = mergingPair.stack.method_7972();
                    if (mergingStack.method_7960()) continue;
                    if (thisSlot.cosmetic.size() <= i) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    currentPair = (AccessoriesInventorySlot)thisSlot.cosmetic.get(i);
                    thisStack = currentPair.stack;
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && !AccessoriesAPI.canUnequip((class_1799)mergingStack, (SlotReference)SlotReference.of((class_1309)merger, (String)key, (int)i))) {
                        extraItems.add((Object)currentPair.stack);
                        thisSlot.cosmetic.set(i, (Object)new AccessoriesInventorySlot(mergingStack, mergingPair.dropRule, mergingPair.visible));
                        continue;
                    }
                    if (!thisStack.method_7960()) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    thisSlot.cosmetic.set(i, (Object)mergingPair);
                }
            }
            return extraItems;
        }

        @Override
        public class_2371<class_1799> pullBindingCurseItems(class_3222 playerRef) {
            class_2371 noUnequipItems = class_2371.method_10211();
            if (!YigdConfig.getConfig().graveConfig.treatBindingCurse) {
                return noUnequipItems;
            }
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                boolean isBound;
                class_1799 stack;
                AccessoriesInventorySlot pair;
                int i;
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    pair = (AccessoriesInventorySlot)inventorySlot.normal.get(i);
                    stack = pair.stack;
                    boolean bl = isBound = !AccessoriesAPI.canUnequip((class_1799)stack, (SlotReference)SlotReference.of((class_1309)playerRef, (String)((String)entry.getKey()), (int)i));
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    pair.stack = class_1799.field_8037;
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    pair = (AccessoriesInventorySlot)inventorySlot.cosmetic.get(i);
                    stack = pair.stack;
                    boolean bl = isBound = !AccessoriesAPI.canUnequip((class_1799)stack, (SlotReference)SlotReference.of((class_1309)playerRef, (String)((String)entry.getKey()), (int)i));
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    pair.stack = class_1799.field_8037;
                }
            }
            return noUnequipItems;
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            class_2371 extraItems = class_2371.method_10211();
            AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
            if (capability == null) {
                return extraItems;
            }
            Map containers = capability.getContainers();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventorySlot slot;
                int i;
                String key = (String)entry.getKey();
                if (!containers.containsKey(key)) {
                    ((AccessoriesInventoryGroup)entry.getValue()).addAllNonEmptyToList((Collection<class_1799>)extraItems);
                    continue;
                }
                AccessoriesContainer container = (AccessoriesContainer)containers.get(key);
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                ExpandedSimpleContainer normalAccessories = container.getAccessories();
                ExpandedSimpleContainer cosmeticAccessories = container.getCosmeticAccessories();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventorySlot.normal.get(i);
                    if (slot.stack.method_7960()) continue;
                    if (i >= normalAccessories.method_5439()) {
                        extraItems.add((Object)slot.stack.method_7972());
                        continue;
                    }
                    normalAccessories.method_5447(i, slot.stack.method_7972());
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventorySlot.cosmetic.get(i);
                    if (slot.stack.method_7960()) continue;
                    if (i >= cosmeticAccessories.method_5439()) {
                        extraItems.add((Object)slot.stack.method_7972());
                        continue;
                    }
                    cosmeticAccessories.method_5447(i, slot.stack.method_7972());
                    container.renderOptions().set(i, slot.visible);
                    container.markChanged(false);
                }
            }
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                com.b1n_ry.yigd.util.DropRule defaultDropRule;
                class_1799 stack;
                AccessoriesInventorySlot pair;
                int i;
                String key = (String)entry.getKey();
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    pair = (AccessoriesInventorySlot)inventorySlot.normal.get(i);
                    stack = pair.stack;
                    pair.dropRule = switch (AccessoriesAPI.getOrDefaultAccessory((class_1799)stack).getDropRule(stack, SlotReference.of((class_1309)context.player(), (String)key, (int)i), context.deathSource())) {
                        case DropRule.DESTROY -> com.b1n_ry.yigd.util.DropRule.DESTROY;
                        case DropRule.KEEP -> com.b1n_ry.yigd.util.DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                            if (defaultDropRule == com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE) {
                                yield ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(stack, -1, context, true);
                            }
                            yield defaultDropRule;
                        }
                    };
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    pair = (AccessoriesInventorySlot)inventorySlot.cosmetic.get(i);
                    stack = pair.stack;
                    pair.dropRule = switch (AccessoriesAPI.getOrDefaultAccessory((class_1799)stack).getDropRule(stack, SlotReference.of((class_1309)context.player(), (String)key, (int)i), context.deathSource())) {
                        case DropRule.DESTROY -> com.b1n_ry.yigd.util.DropRule.DESTROY;
                        case DropRule.KEEP -> com.b1n_ry.yigd.util.DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                            if (defaultDropRule == com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE) {
                                yield ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(stack, -1, context, true);
                            }
                            yield defaultDropRule;
                        }
                    };
                }
            }
        }

        @Override
        public class_2371<class_3545<class_1799, com.b1n_ry.yigd.util.DropRule>> getAsStackDropList() {
            class_2371 allItems = class_2371.method_10211();
            for (AccessoriesInventoryGroup slot : ((Map)this.inventory).values()) {
                for (AccessoriesInventorySlot entry : slot.normal) {
                    allItems.add((Object)new class_3545((Object)entry.stack, (Object)entry.dropRule));
                }
                for (AccessoriesInventorySlot entry : slot.cosmetic) {
                    allItems.add((Object)new class_3545((Object)entry.stack, (Object)entry.dropRule));
                }
            }
            return allItems;
        }

        @Override
        public CompatComponent<Map<String, AccessoriesInventoryGroup>> filterInv(Predicate<com.b1n_ry.yigd.util.DropRule> predicate) {
            HashMap<String, AccessoriesInventoryGroup> filtered = new HashMap<String, AccessoriesInventoryGroup>();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                class_2371 normalSlot = class_2371.method_10211();
                class_2371 cosmeticSlot = class_2371.method_10211();
                for (AccessoriesInventorySlot pair : inventorySlot.normal) {
                    if (predicate.test(pair.dropRule)) {
                        normalSlot.add((Object)pair);
                        continue;
                    }
                    normalSlot.add((Object)AccessoriesInventorySlot.EMPTY);
                }
                for (AccessoriesInventorySlot pair : inventorySlot.cosmetic) {
                    if (predicate.test(pair.dropRule)) {
                        cosmeticSlot.add((Object)pair);
                        continue;
                    }
                    cosmeticSlot.add((Object)AccessoriesInventorySlot.EMPTY);
                }
                filtered.put((String)entry.getKey(), new AccessoriesInventoryGroup((class_2371<AccessoriesInventorySlot>)normalSlot, (class_2371<AccessoriesInventorySlot>)cosmeticSlot));
            }
            return new AccessoriesCompatComponent((Map<String, AccessoriesInventoryGroup>)filtered);
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            for (AccessoriesInventoryGroup inventorySlot : ((Map)this.inventory).values()) {
                for (AccessoriesInventorySlot pair : inventorySlot.normal) {
                    class_1799 stack = pair.stack;
                    if (!predicate.test(stack)) continue;
                    stack.method_7934(itemCount);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            for (AccessoriesInventoryGroup inventorySlot : ((Map)this.inventory).values()) {
                Collections.fill(inventorySlot.normal, AccessoriesInventorySlot.EMPTY);
                Collections.fill(inventorySlot.cosmetic, AccessoriesInventorySlot.EMPTY);
            }
        }

        @Override
        public class_2487 writeNbt(class_7225.class_7874 registryLookup) {
            class_2487 nbt = new class_2487();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                class_2487 slotNbt = new class_2487();
                class_2487 normalNbt = InventoryComponent.listToNbt(inventorySlot.normal, pair -> {
                    class_2487 itemNbt = (class_2487)pair.stack.method_57358(registryLookup);
                    itemNbt.method_10582("dropRule", pair.dropRule.name());
                    itemNbt.method_10556("visible", pair.visible);
                    return itemNbt;
                }, pair -> pair.stack.method_7960());
                class_2487 cosmeticNbt = InventoryComponent.listToNbt(inventorySlot.cosmetic, pair -> {
                    class_2487 itemNbt = (class_2487)pair.stack.method_57358(registryLookup);
                    itemNbt.method_10582("dropRule", pair.dropRule.name());
                    itemNbt.method_10556("visible", pair.visible);
                    return itemNbt;
                }, pair -> pair.stack.method_7960());
                slotNbt.method_10566("normal", (class_2520)normalNbt);
                slotNbt.method_10566("cosmetic", (class_2520)cosmeticNbt);
                nbt.method_10566((String)entry.getKey(), (class_2520)slotNbt);
            }
            return nbt;
        }
    }
}

