/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.util.DropRule;
import java.util.function.Predicate;
import net.levelz.access.LevelManagerAccess;
import net.levelz.level.LevelManager;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_7225;

public class LevelzCompat
implements InvModCompat<Float> {
    @Override
    public String getModName() {
        return "levelz";
    }

    @Override
    public void clear(class_3222 player) {
        LevelManager manager = ((LevelManagerAccess)player).getLevelManager();
        manager.setLevelProgress(0.0f);
    }

    @Override
    public CompatComponent<Float> readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        float value = nbt.method_10583("value");
        return new LevelzCompatComponent(Float.valueOf(value));
    }

    @Override
    public CompatComponent<Float> getNewComponent(class_3222 player) {
        return new LevelzCompatComponent(player);
    }

    private static class LevelzCompatComponent
    extends CompatComponent<Float> {
        public LevelzCompatComponent(class_3222 player) {
            super(player);
        }

        public LevelzCompatComponent(Float inventory) {
            super(inventory);
        }

        @Override
        public Float getInventory(class_3222 player) {
            LevelManager manager = ((LevelManagerAccess)player).getLevelManager();
            return Float.valueOf(manager.getLevelProgress());
        }

        @Override
        public class_2371<class_1799> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            this.inventory = Float.valueOf(((Float)this.inventory).floatValue() + ((Float)mergingComponent.inventory).floatValue());
            return class_2371.method_10211();
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            LevelManager manager = ((LevelManagerAccess)player).getLevelManager();
            manager.setLevelProgress(((Float)this.inventory).floatValue());
            return class_2371.method_10211();
        }

        @Override
        public void handleDropRules(DeathContext context) {
        }

        @Override
        public class_2371<class_3545<class_1799, DropRule>> getAsStackDropList() {
            return class_2371.method_10211();
        }

        @Override
        public CompatComponent<Float> filterInv(Predicate<DropRule> predicate) {
            if (predicate.test(YigdConfig.getConfig().compatConfig.defaultLevelzDropRule)) {
                return new LevelzCompatComponent((Float)this.inventory);
            }
            return new LevelzCompatComponent(Float.valueOf(0.0f));
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            return false;
        }

        @Override
        public void clear() {
            this.inventory = Float.valueOf(0.0f);
        }

        @Override
        public boolean containsGraveItems() {
            return ((Float)this.inventory).floatValue() != 0.0f;
        }

        @Override
        public class_2487 writeNbt(class_7225.class_7874 registryLookup) {
            class_2487 nbt = new class_2487();
            nbt.method_10548("value", ((Float)this.inventory).floatValue());
            return nbt;
        }
    }
}

