/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.AdjustDropRuleEvent;
import com.b1n_ry.yigd.events.DropItemEvent;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.b1n_ry.yigd.util.PairModificationConsumer;
import com.b1n_ry.yigd.util.YigdTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;

public class InventoryComponent {
    private final class_2371<class_3545<class_1799, DropRule>> items = class_2371.method_10211();
    private final Map<String, CompatComponent<?>> modInventoryItems;
    public final int mainSize;
    public final int armorSize;
    public final int offHandSize;
    private static final Random RANDOM = new Random();
    public static final class_3545<class_1799, DropRule> EMPTY_ITEM_PAIR = new class_3545((Object)class_1799.field_8037, (Object)GraveOverrideAreas.INSTANCE.defaultDropRule);

    public InventoryComponent(class_3222 player) {
        for (class_1799 stack : this.getInventoryItems(player)) {
            this.items.add((Object)new class_3545((Object)stack, (Object)DropRule.PUT_IN_GRAVE));
        }
        this.modInventoryItems = this.getModInventoryItems(player);
        class_1661 inventory = player.method_31548();
        this.mainSize = inventory.field_7547.size();
        this.armorSize = inventory.field_7548.size();
        this.offHandSize = inventory.field_7544.size();
    }

    private InventoryComponent(class_2371<class_3545<class_1799, DropRule>> items, Map<String, CompatComponent<?>> modInventoryItems, int mainSize, int armorSize, int offHandSize) {
        this.items.addAll(items);
        this.modInventoryItems = modInventoryItems;
        this.mainSize = mainSize;
        this.armorSize = armorSize;
        this.offHandSize = offHandSize;
    }

    public class_2371<class_3545<class_1799, DropRule>> getItems() {
        return this.items;
    }

    public class_2371<class_1799> getAllExtraItems(boolean withoutEmpty) {
        class_2371 stacks = class_2371.method_10211();
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            for (class_3545 pair : compatComponent.getAsStackDropList()) {
                class_1799 stack = (class_1799)pair.method_15442();
                if (withoutEmpty && stack.method_7960()) continue;
                stacks.add((Object)stack);
            }
        }
        return stacks;
    }

    public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
        predicate = predicate.and(stack -> stack.method_7947() >= itemCount);
        for (class_3545 pair : this.items) {
            class_1799 stack2 = (class_1799)pair.method_15442();
            if (!predicate.test(stack2)) continue;
            stack2.method_7934(itemCount);
            return true;
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (!compatComponent.removeItem(predicate, itemCount)) continue;
            return true;
        }
        return false;
    }

    private class_2371<class_1799> getInventoryItems(class_3222 player) {
        class_1661 inventory = player.method_31548();
        class_2371 items = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < inventory.method_5439(); ++i) {
            items.set(i, (Object)inventory.method_5438(i));
        }
        return items;
    }

    private Map<String, CompatComponent<?>> getModInventoryItems(class_3222 player) {
        HashMap modInventories = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            modInventories.put(compatMod.getModName(), compatMod.getNewComponent(player));
        }
        return modInventories;
    }

    public void onDeath(DeathContext context) {
        YigdConfig config = YigdConfig.getConfig();
        if (config.inventoryConfig.dropPlayerHead) {
            class_1799 playerHead = new class_1799((class_1935)class_1802.field_8575);
            playerHead.method_57379(class_9334.field_49617, (Object)new class_9296(context.player().method_7334()));
            this.items.add((Object)new class_3545((Object)playerHead, (Object)GraveOverrideAreas.INSTANCE.defaultDropRule));
        }
        this.handleDropRules(context);
        InventoryComponent dropInventory = this.filteredInv(dropRule -> dropRule == DropRule.DROP);
        dropInventory.dropAll(context.world(), context.deathPos());
    }

    private void handleDropRules(DeathContext context) {
        for (int i = 0; i < this.items.size(); ++i) {
            class_3545 pair = (class_3545)this.items.get(i);
            class_1799 item = (class_1799)pair.method_15442();
            if (item.method_7960()) continue;
            DropRule dropRule = ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(item, i, context, true);
            pair.method_34965((Object)dropRule);
        }
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            CompatComponent<?> compatComponent = this.modInventoryItems.get(modName);
            compatComponent.handleDropRules(context);
        }
        ((AdjustDropRuleEvent)AdjustDropRuleEvent.EVENT.invoker()).adjustDropRules(this, context);
    }

    public void applyLoss() {
        int to;
        int from;
        YigdConfig config = YigdConfig.getConfig();
        YigdConfig.InventoryConfig.ItemLossConfig itemLoss = config.inventoryConfig.itemLoss;
        if (itemLoss.usePercentRange) {
            class_2371 vanillaStacks = class_2371.method_10211();
            for (class_3545 pair : this.items) {
                if (((class_1799)pair.method_15442()).method_7960() || pair.method_15441() == DropRule.DESTROY) continue;
                vanillaStacks.add((Object)((class_1799)pair.method_15442()));
            }
            int itemCount = vanillaStacks.size();
            if (!itemLoss.affectStacks) {
                itemCount = 0;
                for (class_1799 stack : vanillaStacks) {
                    itemCount += stack.method_7947();
                }
            }
            from = (int)((float)(itemCount * itemLoss.lossRangeFrom) / 100.0f);
            to = (int)((float)(itemCount * itemLoss.lossRangeTo) / 100.0f);
        } else {
            from = itemLoss.lossRangeFrom;
            to = itemLoss.lossRangeTo;
        }
        int amount = from < to ? new Random().nextInt(from, to + 1) : from;
        for (int i = 0; i < amount; ++i) {
            if (Math.random() > (double)itemLoss.percentChanceOfLoss / 100.0) continue;
            this.loseRandomItem();
        }
    }

    private void loseRandomItem() {
        YigdConfig config = YigdConfig.getConfig();
        YigdConfig.InventoryConfig.ItemLossConfig itemLoss = config.inventoryConfig.itemLoss;
        ArrayList<Integer> itemSlots = new ArrayList<Integer>();
        int vanillaLimit = this.items.size();
        for (int i = 0; i < vanillaLimit; ++i) {
            class_3545 pair2 = (class_3545)this.items.get(i);
            class_1799 class_17992 = (class_1799)pair2.method_15442();
            if (class_17992.method_7960() || pair2.method_15441() == DropRule.KEEP && !itemLoss.canLoseSoulbound || class_17992.method_31573(YigdTags.LOSS_IMMUNE)) continue;
            itemSlots.add(i);
        }
        class_2371 extraItems = class_2371.method_10211();
        if (itemLoss.includeModdedInventories) {
            for (CompatComponent compatComponent : this.modInventoryItems.values()) {
                for (class_3545 tuple : compatComponent.getAsStackDropList()) {
                    if (((class_1799)tuple.method_15442()).method_7960()) continue;
                    extraItems.add((Object)((class_1799)tuple.method_15442()));
                }
            }
            for (int i = 0; i < extraItems.size(); ++i) {
                itemSlots.add(vanillaLimit + i);
            }
        }
        if (itemSlots.isEmpty()) {
            return;
        }
        int random = RANDOM.nextInt(itemSlots.size());
        int n = (Integer)itemSlots.get(random);
        if (itemLoss.affectStacks) {
            if (n >= vanillaLimit) {
                class_1799 toBeRemoved = (class_1799)extraItems.get(n - vanillaLimit);
                this.handleItemPairs(s -> !s.equals("vanilla"), (stack, s, pair) -> {
                    if (stack.equals(toBeRemoved)) {
                        pair.method_34965((Object)DropRule.DESTROY);
                    }
                });
            } else {
                ((class_3545)this.items.get(n)).method_34965((Object)DropRule.DESTROY);
            }
        } else {
            class_1799 stack2 = n >= vanillaLimit ? (class_1799)extraItems.get(n - vanillaLimit) : (class_1799)((class_3545)this.items.get(n)).method_15442();
            stack2.method_7934(1);
            if (stack2.method_7960() || stack2.method_7947() == 0) {
                itemSlots.remove((Object)n);
            }
        }
    }

    public void dropAll(class_3218 world, class_243 pos) {
        for (class_3545 pair : this.items) {
            class_1799 stack = (class_1799)pair.method_15442();
            if (stack.method_7960()) continue;
            InventoryComponent.dropItemIfToBeDropped(stack, pos.field_1352, pos.field_1351, pos.field_1350, world);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            compatComponent.dropItems(world, pos);
        }
    }

    public void dropGraveItems(class_3218 world, class_243 pos) {
        for (class_3545 pair : this.items) {
            class_1799 stack = (class_1799)pair.method_15442();
            if (stack.method_7960() || pair.method_15441() != DropRule.PUT_IN_GRAVE) continue;
            pair.method_34965((Object)DropRule.DROP);
            InventoryComponent.dropItemIfToBeDropped(stack, pos.field_1352, pos.field_1351, pos.field_1350, world);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            compatComponent.dropGraveItems(world, pos);
        }
    }

    public class_2371<class_1799> merge(InventoryComponent mergingComponent, class_3222 merger) {
        YigdConfig config = YigdConfig.getConfig();
        class_2371 extraItems = class_2371.method_10211();
        for (int i = 0; i < mergingComponent.items.size(); ++i) {
            int combinationSlot;
            int currentComponentIndex;
            if (i < mergingComponent.mainSize) {
                groupIndex = i;
                currentComponentIndex = groupIndex < this.mainSize ? groupIndex : 0;
            } else if (i < mergingComponent.mainSize + mergingComponent.armorSize) {
                groupIndex = i - mergingComponent.mainSize;
                currentComponentIndex = groupIndex < this.armorSize ? groupIndex + this.mainSize : this.mainSize;
            } else if (i < mergingComponent.mainSize + mergingComponent.armorSize + mergingComponent.offHandSize) {
                groupIndex = i - (mergingComponent.mainSize + mergingComponent.armorSize);
                currentComponentIndex = groupIndex < this.offHandSize ? groupIndex + this.mainSize + this.armorSize : this.mainSize + this.armorSize;
            } else {
                groupIndex = i - (mergingComponent.mainSize + mergingComponent.armorSize + mergingComponent.offHandSize);
                currentComponentIndex = groupIndex + this.mainSize + this.armorSize + this.offHandSize;
            }
            class_1799 mergingStack = ((class_1799)((class_3545)mergingComponent.items.get(i)).method_15442()).method_7972();
            if (currentComponentIndex > this.items.size()) {
                extraItems.add((Object)mergingStack);
                continue;
            }
            Iterator currentStack = (class_1799)((class_3545)this.items.get(currentComponentIndex)).method_15442();
            if (config.graveConfig.treatBindingCurse && i >= mergingComponent.mainSize && i < mergingComponent.mainSize + mergingComponent.armorSize && class_1890.method_60142((class_1799)mergingStack, (class_9331)class_9701.field_51656)) {
                if (!currentStack.method_7960()) {
                    extraItems.add((Object)currentStack);
                }
                this.items.set(currentComponentIndex, EMPTY_ITEM_PAIR);
                currentStack = (class_1799)((class_3545)this.items.get(currentComponentIndex)).method_15442();
            }
            if (config.graveConfig.mergeStacksOnRetrieve && (combinationSlot = this.findMatchingStackSlot(mergingStack)) != -1) {
                this.mergeItemInSlot(mergingStack, combinationSlot);
            }
            if (mergingStack.method_7960()) continue;
            if (currentStack.method_7960()) {
                this.items.set(currentComponentIndex, (Object)new class_3545((Object)mergingStack, (Object)DropRule.PUT_IN_GRAVE));
                continue;
            }
            extraItems.add((Object)mergingStack);
        }
        for (InvModCompat<?> modCompat : InvModCompat.invCompatMods) {
            String modName = modCompat.getModName();
            if (!mergingComponent.modInventoryItems.containsKey(modName)) continue;
            CompatComponent<?> mergingCompatComponent = mergingComponent.modInventoryItems.get(modName);
            if (!this.modInventoryItems.containsKey(modName)) {
                for (class_3545 pair : mergingCompatComponent.getAsStackDropList()) {
                    class_1799 item = (class_1799)pair.method_15442();
                    if (item.method_7960()) continue;
                    extraItems.add((Object)item);
                }
                continue;
            }
            CompatComponent<?> compatComponent = this.modInventoryItems.get(modName);
            class_2371<class_1799> extraModItems = compatComponent.merge(mergingCompatComponent, merger);
            extraItems.addAll(extraModItems);
        }
        this.addStacksToMain((class_2371<class_1799>)extraItems);
        return extraItems;
    }

    private int findMatchingStackSlot(class_1799 stack) {
        for (int i = 0; i < this.mainSize; ++i) {
            class_1799 iStack = (class_1799)((class_3545)this.items.get(i)).method_15442();
            if (!class_1799.method_31577((class_1799)stack, (class_1799)iStack) || !iStack.method_7946() || iStack.method_7914() <= iStack.method_7947()) continue;
            return i;
        }
        return -1;
    }

    private void mergeItemInSlot(class_1799 toMerge, int slot) {
        class_1799 mergeTo = (class_1799)((class_3545)this.items.get(slot)).method_15442();
        int remaining = mergeTo.method_7914() - mergeTo.method_7947();
        int ableToAdd = Math.min(toMerge.method_7947(), remaining);
        mergeTo.method_7933(ableToAdd);
        toMerge.method_7934(ableToAdd);
    }

    public class_2371<class_1799> pullBindingCurseItems(class_3222 playerRef) {
        class_2371 bindingItems = class_2371.method_10211();
        for (int i = 0; i < this.armorSize; ++i) {
            class_1799 armorStack = (class_1799)((class_3545)this.items.get(this.mainSize + i)).method_15442();
            if (!class_1890.method_60142((class_1799)armorStack, (class_9331)class_9701.field_51656)) continue;
            bindingItems.add((Object)armorStack);
            this.items.set(this.mainSize + i, EMPTY_ITEM_PAIR);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            bindingItems.addAll(compatComponent.pullBindingCurseItems(playerRef));
        }
        return bindingItems;
    }

    private void addStacksToMain(class_2371<class_1799> extraItems) {
        YigdConfig config = YigdConfig.getConfig();
        while (!extraItems.isEmpty()) {
            class_1799 stack = (class_1799)extraItems.getFirst();
            int addToSlot = -1;
            if (config.graveConfig.mergeStacksOnRetrieve) {
                addToSlot = this.findMatchingStackSlot(stack);
            }
            if (addToSlot == -1 && (addToSlot = this.findEmptySlot()) == -1) {
                return;
            }
            class_1799 addToStack = (class_1799)((class_3545)this.items.get(addToSlot)).method_15442();
            if (addToStack.method_7960()) {
                this.items.set(addToSlot, (Object)new class_3545((Object)stack, (Object)GraveOverrideAreas.INSTANCE.defaultDropRule));
                extraItems.removeFirst();
                continue;
            }
            this.mergeItemInSlot(stack, addToSlot);
            if (!stack.method_7960()) continue;
            extraItems.removeFirst();
        }
    }

    private int findEmptySlot() {
        for (int i = 0; i < this.mainSize; ++i) {
            if (!((class_1799)((class_3545)this.items.get(i)).method_15442()).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public boolean containsAny(Predicate<class_1799> itemPredicate, Predicate<String> modPredicate, Predicate<Integer> slotPredicate) {
        if (modPredicate.test("vanilla")) {
            for (int i = 0; i < this.items.size(); ++i) {
                class_3545 pair = (class_3545)this.items.get(i);
                if (!slotPredicate.test(i) || !itemPredicate.test((class_1799)pair.method_15442())) continue;
                return true;
            }
        }
        for (Map.Entry<String, CompatComponent<?>> entry : this.modInventoryItems.entrySet()) {
            CompatComponent<?> compatComponent = entry.getValue();
            if (!modPredicate.test(entry.getKey()) || !compatComponent.containsAny(itemPredicate)) continue;
            return true;
        }
        return false;
    }

    public void handleItemPairs(Predicate<String> modPredicate, PairModificationConsumer modification) {
        if (modPredicate.test("vanilla")) {
            for (int i = 0; i < this.items.size(); ++i) {
                class_3545 pair = (class_3545)this.items.get(i);
                modification.accept((class_1799)pair.method_15442(), i, (class_3545<class_1799, DropRule>)pair);
            }
        }
        for (Map.Entry<String, CompatComponent<?>> entry : this.modInventoryItems.entrySet()) {
            CompatComponent<?> compatComponent = entry.getValue();
            if (!modPredicate.test(entry.getKey())) continue;
            compatComponent.handleItemPairs(modification);
        }
    }

    public boolean isGraveEmpty() {
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (!compatComponent.containsGraveItems()) continue;
            return false;
        }
        for (class_3545 pair : this.items) {
            if (((class_1799)pair.method_15442()).method_7960() || pair.method_15441() != DropRule.PUT_IN_GRAVE) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (compatComponent.isEmpty()) continue;
            return false;
        }
        for (class_3545 pair : this.items) {
            if (((class_1799)pair.method_15442()).method_7960()) continue;
            return false;
        }
        return true;
    }

    public int graveSize() {
        int size = 0;
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            for (class_3545 pair : compatComponent.getAsStackDropList()) {
                if (((class_1799)pair.method_15442()).method_7960() || pair.method_15441() != DropRule.PUT_IN_GRAVE) continue;
                ++size;
            }
        }
        for (class_3545 pair : this.items) {
            if (((class_1799)pair.method_15442()).method_7960() || pair.method_15441() != DropRule.PUT_IN_GRAVE) continue;
            ++size;
        }
        return size;
    }

    public class_2371<class_1799> applyToPlayer(class_3222 player) {
        class_2371 extraItems = class_2371.method_10211();
        class_1661 inventory = player.method_31548();
        int invMainSize = inventory.field_7547.size();
        int invArmorSize = inventory.field_7548.size();
        int invOffHandSize = inventory.field_7544.size();
        for (int i = 0; i < this.items.size(); ++i) {
            int playerInvIndex;
            if (i < this.mainSize) {
                groupIndex = i;
                playerInvIndex = groupIndex < invMainSize ? groupIndex : -1;
            } else if (i < this.mainSize + this.armorSize) {
                groupIndex = i - this.mainSize;
                playerInvIndex = groupIndex < invArmorSize ? groupIndex + invMainSize : -1;
            } else if (i < this.mainSize + this.armorSize + this.offHandSize) {
                groupIndex = i - (this.mainSize + this.armorSize);
                playerInvIndex = groupIndex < invOffHandSize ? groupIndex + invMainSize + invArmorSize : -1;
            } else {
                groupIndex = i - (this.mainSize + this.armorSize + this.offHandSize);
                playerInvIndex = groupIndex + invMainSize + invArmorSize + invOffHandSize;
            }
            class_1799 stack = ((class_1799)((class_3545)this.items.get(i)).method_15442()).method_7972();
            if (playerInvIndex >= inventory.method_5439() || playerInvIndex == -1) {
                extraItems.add((Object)stack);
                continue;
            }
            inventory.method_5447(playerInvIndex, stack);
        }
        for (InvModCompat<?> modCompat : InvModCompat.invCompatMods) {
            String modName = modCompat.getModName();
            if (!this.modInventoryItems.containsKey(modName)) continue;
            class_2371<class_1799> extraModItems = this.modInventoryItems.get(modName).storeToPlayer(player);
            extraItems.addAll(extraModItems);
        }
        return extraItems;
    }

    public InventoryComponent filteredInv(Predicate<DropRule> filter) {
        class_2371 filteredItems = class_2371.method_10211();
        for (class_3545 pair : this.items) {
            if (filter.test((DropRule)((Object)pair.method_15441()))) {
                filteredItems.add((Object)pair);
                continue;
            }
            filteredItems.add(EMPTY_ITEM_PAIR);
        }
        HashMap filteredModInventories = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            if (!this.modInventoryItems.containsKey(modName)) continue;
            CompatComponent<?> compatInv = this.modInventoryItems.get(modName);
            CompatComponent<?> filteredCompatInv = compatInv.filterInv(filter);
            filteredModInventories.put(modName, filteredCompatInv);
        }
        return new InventoryComponent((class_2371<class_3545<class_1799, DropRule>>)filteredItems, filteredModInventories, this.mainSize, this.armorSize, this.offHandSize);
    }

    public void clear() {
        Collections.fill(this.items, EMPTY_ITEM_PAIR);
        for (CompatComponent<?> component : this.modInventoryItems.values()) {
            component.clear();
        }
    }

    public class_2487 toNbt(class_7225.class_7874 lookupRegistry) {
        class_2487 nbt = new class_2487();
        class_2487 vanillaInventoryNbt = InventoryComponent.listToNbt(this.items, pair -> {
            class_2487 itemNbt = (class_2487)((class_1799)pair.method_15442()).method_57358(lookupRegistry);
            itemNbt.method_10582("dropRule", ((DropRule)((Object)((Object)pair.method_15441()))).name());
            return itemNbt;
        }, pair -> ((class_1799)pair.method_15442()).method_7960());
        vanillaInventoryNbt.method_10569("mainSize", this.mainSize);
        vanillaInventoryNbt.method_10569("armorSize", this.armorSize);
        vanillaInventoryNbt.method_10569("offHandSize", this.offHandSize);
        class_2487 modInventoriesNbt = new class_2487();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            CompatComponent<?> compatInv;
            String modName = compatMod.getModName();
            if (!this.modInventoryItems.containsKey(modName) || (compatInv = this.modInventoryItems.get(modName)).isEmpty()) continue;
            modInventoriesNbt.method_10566(modName, (class_2520)compatInv.writeNbt(lookupRegistry));
        }
        nbt.method_10566("vanilla", (class_2520)vanillaInventoryNbt);
        nbt.method_10566("mods", (class_2520)modInventoriesNbt);
        return nbt;
    }

    public static InventoryComponent fromNbt(class_2487 nbt, class_7225.class_7874 lookupRegistry) {
        class_2487 vanillaInvNbt = nbt.method_10562("vanilla");
        class_2371<class_3545<class_1799, DropRule>> items = InventoryComponent.listFromNbt(vanillaInvNbt, itemNbt -> {
            class_1799 stack = class_1799.method_57359((class_7225.class_7874)lookupRegistry, (class_2487)itemNbt);
            DropRule dropRule = GraveOverrideAreas.INSTANCE.defaultDropRule;
            if (itemNbt.method_10545("dropRule")) {
                dropRule = DropRule.valueOf(itemNbt.method_10558("dropRule"));
            }
            return new class_3545((Object)stack, (Object)dropRule);
        }, EMPTY_ITEM_PAIR);
        int mainSize = vanillaInvNbt.method_10550("mainSize");
        int armorSize = vanillaInvNbt.method_10550("armorSize");
        int offHandSize = vanillaInvNbt.method_10550("offHandSize");
        class_2487 modInventoriesNbt = nbt.method_10562("mods");
        HashMap compatComponents = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            if (!modInventoriesNbt.method_10545(modName)) continue;
            class_2487 modNbt = modInventoriesNbt.method_10562(modName);
            compatComponents.put(modName, compatMod.readNbt(modNbt, lookupRegistry));
        }
        return new InventoryComponent(items, compatComponents, mainSize, armorSize, offHandSize);
    }

    public static <T> class_2487 listToNbt(class_2371<T> list, Function<T, class_2487> mappingFunction, Predicate<T> isEmpty) {
        return InventoryComponent.listToNbt(list, mappingFunction, isEmpty, "Items", "Slot");
    }

    public static <T> class_2487 listToNbt(class_2371<T> list, Function<T, class_2487> mappingFunction, Predicate<T> isEmpty, String listName, String itemName) {
        class_2487 nbt = new class_2487();
        int size = list.size();
        nbt.method_10569("size", size);
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < size; ++i) {
            Object item = list.get(i);
            if (isEmpty.test(item)) continue;
            class_2487 itemNbt = mappingFunction.apply(item);
            itemNbt.method_10569(itemName, i);
            nbtList.add((Object)itemNbt);
        }
        nbt.method_10566(listName, (class_2520)nbtList);
        return nbt;
    }

    public static <T> class_2371<T> listFromNbt(class_2487 nbt, Function<class_2487, T> mappingFunction, T emptyValue) {
        return InventoryComponent.listFromNbt(nbt, mappingFunction, emptyValue, "Items", "Slot");
    }

    public static <T> class_2371<T> listFromNbt(class_2487 nbt, Function<class_2487, T> mappingFunction, T emptyValue, String listName, String itemName) {
        int size = nbt.method_10550("size");
        class_2371 list = class_2371.method_10213((int)size, emptyValue);
        class_2499 nbtList = nbt.method_10554(listName, 10);
        for (class_2520 element : nbtList) {
            class_2487 itemNbt = (class_2487)element;
            int index = itemNbt.method_10550(itemName);
            T item = mappingFunction.apply(itemNbt);
            list.set(index, item);
        }
        return list;
    }

    public static void dropItemIfToBeDropped(class_1799 stack, double x, double y, double z, class_3218 world) {
        if (((DropItemEvent)DropItemEvent.EVENT.invoker()).shouldDropItem(stack, x, y, z, world)) {
            class_1264.method_5449((class_1937)world, (double)x, (double)y, (double)z, (class_1799)stack.method_7972());
        }
    }

    public static void clearPlayer(class_3222 player) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            inventory.method_5447(i, class_1799.field_8037);
        }
        for (InvModCompat<?> invModCompat : InvModCompat.invCompatMods) {
            invModCompat.clear(player);
        }
    }
}

