/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.data;

import java.time.LocalDateTime;
import java.time.Month;
import java.util.EnumMap;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class TimePoint {
    private final long time;
    private final long timeOfDay;
    private final LocalDateTime irlTime;
    private static final EnumMap<Month, String> MONTH_NAMES = new EnumMap<Month, String>(Month.class){
        {
            this.put(Month.JANUARY, "January");
            this.put(Month.FEBRUARY, "February");
            this.put(Month.MARCH, "March");
            this.put(Month.APRIL, "April");
            this.put(Month.MAY, "May");
            this.put(Month.JUNE, "June");
            this.put(Month.JULY, "July");
            this.put(Month.AUGUST, "August");
            this.put(Month.SEPTEMBER, "September");
            this.put(Month.OCTOBER, "October");
            this.put(Month.NOVEMBER, "November");
            this.put(Month.DECEMBER, "December");
        }
    };

    public TimePoint(class_3218 world) {
        this(world.method_8510(), world.method_8532(), LocalDateTime.now());
    }

    public TimePoint(long time, long timeOfDay, LocalDateTime irlTime) {
        this.time = time;
        this.timeOfDay = timeOfDay;
        this.irlTime = irlTime;
    }

    public long getTime() {
        return this.time;
    }

    public long getDay() {
        return this.timeOfDay / 24000L;
    }

    public String getMonthName() {
        return MONTH_NAMES.get(this.irlTime.getMonth());
    }

    public int getDate() {
        return this.irlTime.getDayOfMonth();
    }

    public int getYear() {
        return this.irlTime.getYear();
    }

    public int getHour(boolean timePostfix) {
        int hour = this.irlTime.getHour();
        return timePostfix ? (11 + hour) % 12 + 1 : hour;
    }

    public int getMinute() {
        return this.irlTime.getMinute();
    }

    public String getTimePostfix(boolean actuallyUseIt) {
        if (actuallyUseIt) {
            return this.irlTime.getHour() >= 12 ? " PM" : " AM";
        }
        return "";
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10544("time", this.time);
        nbt.method_10544("timeOfDay", this.timeOfDay);
        class_2487 irlTimeNbt = new class_2487();
        irlTimeNbt.method_10569("year", this.irlTime.getYear());
        irlTimeNbt.method_10569("month", this.irlTime.getMonthValue());
        irlTimeNbt.method_10569("date", this.irlTime.getDayOfMonth());
        irlTimeNbt.method_10569("hour", this.irlTime.getHour());
        irlTimeNbt.method_10569("minute", this.irlTime.getMinute());
        nbt.method_10566("realTime", (class_2520)irlTimeNbt);
        return nbt;
    }

    public static TimePoint fromNbt(class_2487 nbt) {
        long time = nbt.method_10537("time");
        long timeOfDay = nbt.method_10537("timeOfDay");
        class_2487 irlTimeNbt = nbt.method_10562("realTime");
        int year = irlTimeNbt.method_10550("year");
        int month = irlTimeNbt.method_10550("month");
        int date = irlTimeNbt.method_10550("date");
        int hour = irlTimeNbt.method_10550("hour");
        int minute = irlTimeNbt.method_10550("minute");
        LocalDateTime dateTime = LocalDateTime.of(year, month, date, hour, minute);
        return new TimePoint(time, timeOfDay, dateTime);
    }
}

