/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.math.LongMath;
import java.text.NumberFormat;
import snownee.jade.overlay.DisplayHelper;

public class FluidTextHelper {
    public static final long BUCKET = 81000L;
    private static final char[] SUPERSCRIPT = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
    private static final char FRACTION_BAR = '\u2044';
    private static final char[] SUBSCRIPT = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};

    public static String getUnicodeFraction(long numerator, long denominator, boolean simplify) {
        if (numerator < 0L || denominator < 0L) {
            throw new IllegalArgumentException("Numerator and denominator must be non negative.");
        }
        if (simplify && denominator != 0L) {
            long g = LongMath.gcd((long)numerator, (long)denominator);
            numerator /= g;
            denominator /= g;
        }
        StringBuilder numString = new StringBuilder();
        while (numerator > 0L) {
            numString.append(SUPERSCRIPT[(int)(numerator % 10L)]);
            numerator /= 10L;
        }
        StringBuilder denomString = new StringBuilder();
        while (denominator > 0L) {
            denomString.append(SUBSCRIPT[(int)(denominator % 10L)]);
            denominator /= 10L;
        }
        return numString.reverse().toString() + "\u2044" + String.valueOf(denomString.reverse());
    }

    public static String getUnicodeMillibuckets(long droplets, boolean simplify) {
        long g;
        long mb = droplets / 81L;
        long leftover = droplets % 81000L;
        if (leftover == 0L || droplets >= 8100000L) {
            return DisplayHelper.INSTANCE.humanReadableNumber(mb, "B", true);
        }
        if (droplets % 81L == 0L) {
            return NumberFormat.getNumberInstance().format(mb) + "mB";
        }
        if (simplify && (g = LongMath.gcd((long)leftover, (long)81000L)) >= 1000L) {
            long b = mb / 1000L;
            String text = b == 0L ? "" : NumberFormat.getNumberInstance().format(b) + " ";
            return text + FluidTextHelper.getUnicodeFraction(leftover, 81000L, true) + "B";
        }
        String text = mb == 0L ? "" : NumberFormat.getNumberInstance().format(mb) + " ";
        return text + FluidTextHelper.getUnicodeFraction(droplets % 81L, 81L, simplify) + "mB";
    }

    private FluidTextHelper() {
    }
}

