/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.dynamax;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.yajatkaul.mega_showdown.config.ShowdownConfig;
import com.cobblemon.yajatkaul.mega_showdown.event.dynamax.DynamaxEvent;
import com.cobblemon.yajatkaul.mega_showdown.event.dynamax.DynamaxEventEnd;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class DynamaxEventLogic {
    private static final Map<UUID, ScalingData> activeScalingAnimations = new HashMap<UUID, ScalingData>();
    private static final WeakHashMap<UUID, class_1309> entityCache = new WeakHashMap();
    private static MinecraftServer server;

    public static void register() {
        DynamaxEvent.EVENT.register((battle, pokemon, gmax) -> {
            class_1937 patt0$temp;
            if (gmax.booleanValue()) {
                new StringSpeciesFeature("dynamax_form", "gmax").apply(pokemon.getEffectedPokemon());
                for (ActiveBattlePokemon activeBattlePokemon : battle.getActivePokemon()) {
                    if (activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != pokemon.getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != pokemon) continue;
                    battle.sendSidedUpdate(activeBattlePokemon.getActor(), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pokemon, true), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pokemon, false), false);
                }
            }
            pokemon.getEntity().method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if (server == null && (patt0$temp = pokemonEntity.method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)patt0$temp;
                server = serverWorld.method_8503();
            }
            DynamaxEventLogic.startGradualScaling((class_1309)pokemonEntity, ShowdownConfig.dynamaxScaleFactor.get().intValue());
            class_1937 patt1$temp = pokemon.getEntity().method_37908();
            if (patt1$temp instanceof class_3218) {
                String teamName;
                class_3218 serverLevel = (class_3218)patt1$temp;
                class_2995 scoreboard = serverLevel.method_14170();
                class_268 team = scoreboard.method_1153(teamName = "glow_" + UUID.randomUUID().toString().substring(0, 8));
                if (team == null) {
                    team = scoreboard.method_1171(teamName);
                    if (pokemon.getEffectedPokemon().getSpecies().getName().equals("Calyrex")) {
                        team.method_1141(class_124.field_1078);
                    } else {
                        team.method_1141(class_124.field_1061);
                    }
                }
                scoreboard.method_1172(pokemon.getEntity().method_5667().toString(), team);
            }
        });
        DynamaxEventEnd.EVENT.register((battle, pokemon) -> {
            class_1937 patt0$temp;
            new StringSpeciesFeature("dynamax_form", "none").apply(pokemon.getEffectedPokemon());
            for (ActiveBattlePokemon activeBattlePokemon : battle.getActivePokemon()) {
                if (activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != pokemon.getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != pokemon) continue;
                battle.sendSidedUpdate(activeBattlePokemon.getActor(), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pokemon, true), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), pokemon, false), false);
            }
            pokemon.getEntity().method_6016(class_1294.field_5912);
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if (server == null && (patt0$temp = pokemonEntity.method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)patt0$temp;
                server = serverWorld.method_8503();
            }
            DynamaxEventLogic.startGradualScaling((class_1309)pokemonEntity, 1.0f);
        });
        ServerTickEvents.END_SERVER_TICK.register(serverInstance -> {
            server = serverInstance;
            DynamaxEventLogic.updateScalingAnimations();
        });
    }

    public static void startGradualScaling(class_1309 entity, float targetScale) {
        UUID entityId = entity.method_5667();
        class_1324 scaleAttribute = entity.method_5996(class_5134.field_47760);
        if (scaleAttribute != null) {
            entityCache.put(entityId, entity);
            float startScale = (float)scaleAttribute.method_6201();
            int durationTicks = 60;
            ScalingData scalingData = new ScalingData(entity.method_37908().method_27983().toString(), entityId, startScale, targetScale, durationTicks, 0);
            activeScalingAnimations.put(entityId, scalingData);
        }
    }

    private static void updateScalingAnimations() {
        if (server == null) {
            return;
        }
        Iterator<Map.Entry<UUID, ScalingData>> iterator = activeScalingAnimations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ScalingData> entry = iterator.next();
            UUID entityId = entry.getKey();
            ScalingData data = entry.getValue();
            ++data.currentTick;
            class_1309 entity = entityCache.get(entityId);
            if (entity == null || entity.method_31481()) {
                for (class_3218 world : server.method_3738()) {
                    entity = (class_1309)world.method_14190(entityId);
                    if (entity == null) continue;
                    entityCache.put(entityId, entity);
                    break;
                }
            }
            if (entity != null && !entity.method_31481()) {
                class_1324 scaleAttribute = entity.method_5996(class_5134.field_47760);
                if (scaleAttribute != null) {
                    float progress = Math.min(1.0f, (float)data.currentTick / (float)data.durationTicks);
                    float newScale = data.startScale + (data.targetScale - data.startScale) * progress;
                    scaleAttribute.method_6192((double)newScale);
                }
                if (data.currentTick < data.durationTicks) continue;
                iterator.remove();
                entityCache.remove(entityId);
                continue;
            }
            iterator.remove();
            entityCache.remove(entityId);
        }
    }

    private static class ScalingData {
        final String worldId;
        final UUID entityId;
        final float startScale;
        final float targetScale;
        final int durationTicks;
        int currentTick;

        public ScalingData(String worldId, UUID entityId, float startScale, float targetScale, int durationTicks, int currentTick) {
            this.worldId = worldId;
            this.entityId = entityId;
            this.startScale = startScale;
            this.targetScale = targetScale;
            this.durationTicks = durationTicks;
            this.currentTick = currentTick;
        }
    }
}

