/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.hud.moveslots;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.SentOutState;
import com.mojang.blaze3d.systems.RenderSystem;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class MoveSlotsRender {
    private static final class_2960 TYPE_ICON_LOCATION = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/types.png");
    private static final int TYPE_ICON_SIZE = 36;
    private static final int DRAW_SIZE = (int)(36.0f * CobblemonFightOrFlight.visualEffectConfig().move_indicator_size);
    private static final float TEXT_SIZE = 0.5f;

    public static void render(class_332 graphics, float tickDelta, Pokemon pokemon) {
        Move move;
        PokemonEntity entity;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (!CobblemonFightOrFlight.visualEffectConfig().enable_move_indicator) {
            return;
        }
        if (player == null || player.method_7325() || pokemon == null) {
            CobblemonFightOrFlight.LOGGER.info("Failed to render the icon.");
            return;
        }
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        PokemonState state = pokemon.getState();
        if (state instanceof SentOutState && (entity = pokemon.getEntity()) != null && (move = PokemonUtils.getMove(entity)) != null) {
            int originX = (int)((float)screenWidth * CobblemonFightOrFlight.visualEffectConfig().move_indicator_x_relative);
            int originY = (int)((float)screenHeight * CobblemonFightOrFlight.visualEffectConfig().move_indicator_y_relative);
            class_327 font = minecraft.field_1772;
            MoveSlotsRender.renderMoveSlot(graphics, font, originX, originY, entity, move);
        }
    }

    public static void renderMoveSlot(class_332 graphics, class_327 font, int x, int y, PokemonEntity entity, Move move) {
        ElementalType type = move.getType();
        int cooldown = ((PokemonInterface)entity).getAttackTime();
        int maxCooldown = ((PokemonInterface)entity).getMaxAttackTime();
        float cooldownPer = (float)cooldown / (float)maxCooldown;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (cooldown > 2) {
            graphics.method_51422(0.5f, 0.5f, 0.5f, 1.0f);
        }
        graphics.method_25293(TYPE_ICON_LOCATION, x, y, DRAW_SIZE, DRAW_SIZE, (float)(36 * type.getTextureXMultiplier()), 0.0f, 36, 36, 648, 36);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        if (cooldown > 1 && maxCooldown != 0) {
            graphics.method_51422(0.65f, 0.8f, 1.0f, 0.95f);
            int cdHeight = (int)((float)DRAW_SIZE * (1.0f - cooldownPer));
            graphics.method_25293(TYPE_ICON_LOCATION, x, y + DRAW_SIZE - cdHeight, DRAW_SIZE, cdHeight, (float)(36 * type.getTextureXMultiplier()), 36.0f - (float)(cdHeight * 36) / (float)DRAW_SIZE, 36, (int)((float)(cdHeight * 36) / (float)DRAW_SIZE), 648, 36);
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
        RenderSystem.disableBlend();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 1.0f);
        graphics.method_27534(font, (class_2561)move.getDisplayName(), (int)((float)x / 0.5f), (int)((float)y / 0.5f), 0xFFFFFF);
        poseStack.method_22909();
    }
}

