/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.data.behavior;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.utils.PokemonUtils;

public abstract class PokemonBehaviorData {
    public static final Map<String, List<MoveData>> behaviorData = new HashMap<String, List<MoveData>>();
    private final List<String> species;
    private final String form;
    private final String gender;
    private final List<String> biome;
    private final List<String> ability;
    private final List<String> move;
    private final List<String> nature;
    private final String levelRequirement;
    private final String type;
    private final float value;

    public PokemonBehaviorData(List<String> species, String form, String gender, List<String> ability, List<String> move, List<String> nature, List<String> biome, String levelRequirement, String type, float value) {
        this.species = species;
        this.form = form;
        this.ability = ability;
        this.gender = gender;
        this.move = move;
        this.nature = nature;
        this.biome = biome;
        this.levelRequirement = levelRequirement;
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public float getValue() {
        return this.value;
    }

    public boolean check(PokemonEntity pokemonEntity) {
        if (pokemonEntity != null) {
            return this.check(pokemonEntity.getPokemon()) && this.checkBiome(pokemonEntity);
        }
        return false;
    }

    public boolean check(Pokemon pokemon) {
        if (pokemon == null) {
            return false;
        }
        return this.checkItem(this.species, pokemon.getSpecies().getName()) && this.checkItem(this.form, pokemon.getForm().getName()) && this.checkItem(this.gender, pokemon.getGender().toString()) && this.checkItem(this.nature, PokemonUtils.getNatureName(pokemon)) && this.checkItem(this.ability, pokemon.getAbility().getName()) && this.checkLevel(pokemon);
    }

    private boolean checkItem(String targetData, String pokemonData) {
        if (!targetData.isEmpty()) {
            return Objects.equals(targetData.toLowerCase(), pokemonData.toLowerCase());
        }
        return true;
    }

    private boolean checkItem(List<String> targetData, String pokemonData) {
        if (!targetData.isEmpty()) {
            return targetData.contains(pokemonData);
        }
        return true;
    }

    private boolean checkLevel(Pokemon pokemon) {
        String pattern = "([<>=])(\\d+)";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(this.levelRequirement);
        if (m.find()) {
            try {
                if (m.groupCount() == 2) {
                    int lvl = Integer.parseInt(m.group(2));
                    int pokemonLvl = pokemon.getLevel();
                    String operator = m.group(1);
                    if (Objects.equals(operator, "=")) {
                        return pokemonLvl == lvl;
                    }
                    if (Objects.equals(operator, "<")) {
                        return pokemonLvl < lvl;
                    }
                    if (Objects.equals(operator, ">")) {
                        return pokemonLvl > lvl;
                    }
                }
            }
            catch (NumberFormatException e) {
                CobblemonFightOrFlight.LOGGER.warn("Failed to convert the level requirement in the datapack");
                return true;
            }
        }
        return this.levelRequirement.isEmpty();
    }

    private boolean checkBiome(PokemonEntity pokemonEntity) {
        return this.biome.contains(pokemonEntity.method_37908().method_23753(pokemonEntity.method_24515()).method_55840());
    }
}

