/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Objects;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1682;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public abstract class AbstractPokemonProjectile
extends class_1682 {
    private static final class_2940<String> type = class_2945.method_12791(AbstractPokemonProjectile.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Float> damage = class_2945.method_12791(AbstractPokemonProjectile.class, (class_2941)class_2943.field_13320);

    public AbstractPokemonProjectile(class_1299<? extends AbstractPokemonProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void initPosition(class_1309 shooter) {
        this.method_7432((class_1297)shooter);
        class_2338 blockPos = shooter.method_24515();
        float angle = shooter.method_36454();
        double radius = 0.5 * (double)shooter.method_17681();
        double d = (double)blockPos.method_10263() + 0.5 - radius * Math.sin(angle);
        double e = (double)blockPos.method_10264() + Math.max((double)0.3f, (double)shooter.method_17682() * 0.67);
        double f = (double)blockPos.method_10260() + 0.5 + radius * Math.cos(angle);
        this.method_5808(d, e, f, this.method_36454(), this.method_36455());
    }

    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("Type", (String)this.field_6011.method_12789(type));
        compound.method_10548("Damage", ((Float)this.field_6011.method_12789(damage)).floatValue());
    }

    public void method_5773() {
        super.method_5773();
        this.makeParticle(2);
    }

    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(type, (Object)compound.method_10558("Type"));
        this.field_6011.method_12778(damage, (Object)Float.valueOf(compound.method_10583("Damage")));
    }

    protected void makeParticle(int particleAmount) {
        if (this.getElementalType() == null) {
            return;
        }
        PokemonAttackEffect.makeTypeEffectParticle(particleAmount, (class_1297)this, this.getElementalType());
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(damage)).floatValue();
    }

    public void setDamage(float Damage) {
        this.field_6011.method_12778(damage, (Object)Float.valueOf(Damage));
    }

    public String getElementalType() {
        return (String)this.field_6011.method_12789(type);
    }

    public void setElementalType(String Type2) {
        this.field_6011.method_12778(type, (Object)Type2);
    }

    public void applyTypeEffect(PokemonEntity pokemonEntity, class_1309 hurtTarget) {
        if (!Objects.equals(this.getElementalType(), pokemonEntity.getPokemon().getPrimaryType().getName())) {
            // empty if block
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(type, (Object)"normal");
        builder.method_56912(damage, (Object)Float.valueOf(1.0f));
    }

    protected void method_7454(class_3966 result) {
        super.method_7454(result);
        class_1297 owner = this.method_24921();
        class_1297 target = result.method_17782();
        if (owner instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)owner;
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                Move move = PokemonUtils.getMove(pokemonEntity);
                PokemonUtils.setHurtByPlayer(pokemonEntity, target);
                PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, target, move);
            }
        }
    }

    protected boolean method_26958(class_1297 target) {
        return target != this.method_24921() && super.method_26958(target);
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
    }

    public void accurateShoot(double x, double y, double z, float velocity, float inaccuracy) {
        double horizontalDistance = Math.sqrt(x * x + z * z);
        float g = (float)this.method_56989();
        double v2 = velocity * velocity;
        double delta = Math.sqrt(2.0 * v2 * (double)g * y + v2 * v2 - (double)(g * g) * horizontalDistance * horizontalDistance);
        double t = Math.sqrt(2.0 * ((double)g * y + v2 - delta)) / (double)g;
        double result = y + 0.5 * (double)g * t * t;
        this.method_7485(x, result, z, velocity, inaccuracy);
    }
}

