/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.experience.ExperienceSource;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.goals.targeting.CaughtByTargetGoal;
import me.rufia.fightorflight.goals.targeting.PokemonCommandedTargetGoal;
import me.rufia.fightorflight.goals.targeting.PokemonNearestAttackableTargetGoal;
import me.rufia.fightorflight.goals.targeting.PokemonOwnerHurtByTargetGoal;
import me.rufia.fightorflight.goals.targeting.PokemonOwnerHurtTargetGoal;
import me.rufia.fightorflight.goals.targeting.PokemonProactiveTargetGoal;
import me.rufia.fightorflight.goals.targeting.PokemonTauntedTargetGoal;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.FOFEVCalculator;
import me.rufia.fightorflight.utils.FOFExpCalculator;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonMultipliers;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1471;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonEntityMixin
extends class_1308
implements PokemonInterface {
    @Unique
    @Nullable
    private class_1309 fightorflight$clientSideCachedAttackTarget;
    @Unique
    private static final class_2940<Integer> DATA_ID_ATTACK_TARGET = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> DATA_ID_CAPTURED_BY = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> ATTACK_TIME = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> MAX_ATTACK_TIME = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<String> MOVE = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13326);
    @Unique
    private static final class_2940<Integer> CRY_CD = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<String> COMMAND = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13326);
    @Unique
    private static final class_2940<String> COMMAND_DATA = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13326);
    @Unique
    private static final class_2940<class_2338> TARGET_BLOCK_POS = class_2945.method_12791(PokemonEntityMixin.class, (class_2941)class_2943.field_13324);

    @Shadow(remap=false)
    public abstract void cry();

    @Shadow(remap=false)
    public abstract Pokemon getPokemon();

    protected void createTargetBlockPos() {
        String data = this.getCommandData();
        class_2338 blockPos = class_2338.field_10980;
        if (data.startsWith("POS_")) {
            if (data.equals("POS_SELF")) {
                blockPos = new class_2338(this.method_31477(), this.method_31479(), this.method_31479());
            }
        } else {
            class_2382 vec3i = FOFUtils.stringToVec3i(data);
            if (vec3i != null) {
                blockPos = new class_2338(vec3i.method_10263(), vec3i.method_10264(), vec3i.method_10260());
            }
        }
        this.setTargetBlockPos(blockPos);
    }

    protected PokemonEntityMixin(class_1299<? extends class_1471> entityType, class_1937 level) {
        super(entityType, level);
    }

    public class_1309 method_5968() {
        if (this.method_37908().field_9236) {
            if (this.fightorflight$clientSideCachedAttackTarget != null) {
                return this.fightorflight$clientSideCachedAttackTarget;
            }
            class_1297 entity = this.method_37908().method_8469(((Integer)this.field_6011.method_12789(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof class_1309) {
                this.fightorflight$clientSideCachedAttackTarget = (class_1309)entity;
                return this.fightorflight$clientSideCachedAttackTarget;
            }
        }
        return super.method_5968();
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    protected void registerFOFGoals(CallbackInfo ci) {
        PokemonEntity pokemonEntity = (PokemonEntity)this;
        this.field_6185.method_6277(1, new PokemonCommandedTargetGoal<class_1309>((class_1308)pokemonEntity, class_1309.class, false));
        this.field_6185.method_6277(2, (class_1352)new PokemonOwnerHurtByTargetGoal(pokemonEntity));
        this.field_6185.method_6277(3, (class_1352)new PokemonOwnerHurtTargetGoal(pokemonEntity));
        this.field_6185.method_6277(3, new PokemonTauntedTargetGoal<PokemonEntity>((class_1308)pokemonEntity, PokemonEntity.class, false));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)pokemonEntity, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new CaughtByTargetGoal((class_1308)pokemonEntity));
        this.field_6185.method_6277(5, new PokemonNearestAttackableTargetGoal<class_1657>((class_1308)pokemonEntity, class_1657.class, PokemonUtils.getAttackRadius() * 3.0f, true, true));
        this.field_6185.method_6277(5, new PokemonProactiveTargetGoal<class_1308>((class_1308)pokemonEntity, class_1308.class, 5, false, false, arg -> arg instanceof class_1569 && (CobblemonFightOrFlight.commonConfig().do_pokemon_defend_creeper_proactive || !(arg instanceof class_1548))));
    }

    @Inject(method={"onSyncedDataUpdated"}, at={@At(value="TAIL")})
    public void onSyncedDataUpdated(class_2940<?> key, CallbackInfo ci) {
        if (DATA_ID_ATTACK_TARGET.equals(key)) {
            this.fightorflight$clientSideCachedAttackTarget = null;
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void defineSynchedData(class_2945.class_9222 builder, CallbackInfo callbackInfo) {
        builder.method_56912(DATA_ID_ATTACK_TARGET, (Object)0);
        builder.method_56912(DATA_ID_CAPTURED_BY, (Object)0);
        builder.method_56912(ATTACK_TIME, (Object)0);
        builder.method_56912(MAX_ATTACK_TIME, (Object)-1);
        builder.method_56912(MOVE, (Object)"");
        builder.method_56912(CRY_CD, (Object)0);
        builder.method_56912(COMMAND, (Object)"");
        builder.method_56912(COMMAND_DATA, (Object)"");
        builder.method_56912(TARGET_BLOCK_POS, (Object)class_2338.field_10980);
        PokemonEntity.Companion.createAttributes();
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="HEAD")})
    private void writeAdditionalNbt(class_2487 compoundTag, CallbackInfoReturnable<Boolean> ci) {
        compoundTag.method_10569(CRY_CD.toString(), 0);
        compoundTag.method_10582(COMMAND.toString(), this.getCommand());
        compoundTag.method_10582(COMMAND_DATA.toString(), this.getCommandData());
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void readAdditionalNbt(class_2487 compoundTag, CallbackInfo ci) {
        this.field_6011.method_12778(CRY_CD, (Object)compoundTag.method_10550(CRY_CD.toString()));
    }

    public void method_5980(class_1309 target) {
        super.method_5980(target);
        if (target != null) {
            this.field_6011.method_12778(DATA_ID_ATTACK_TARGET, (Object)target.method_5628());
        }
    }

    @Override
    public int getAttackTime() {
        return (Integer)this.field_6011.method_12789(ATTACK_TIME);
    }

    @Override
    public void setAttackTime(int val) {
        this.field_6011.method_12778(ATTACK_TIME, (Object)val);
    }

    @Override
    public int getMaxAttackTime() {
        return (Integer)this.field_6011.method_12789(MAX_ATTACK_TIME);
    }

    @Override
    public void setMaxAttackTime(int val) {
        this.field_6011.method_12778(MAX_ATTACK_TIME, (Object)val);
    }

    @Override
    public boolean usingBeam() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().single_beam_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public boolean usingSound() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().sound_based_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public boolean usingMagic() {
        if (this.getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(this.getCurrentMove());
    }

    @Override
    public void setCurrentMove(Move move) {
        this.field_6011.method_12778(MOVE, (Object)move.getName());
    }

    @Override
    public String getCurrentMove() {
        return (String)this.field_6011.method_12789(MOVE);
    }

    @Override
    public int getNextCryTime() {
        return (Integer)this.field_6011.method_12789(CRY_CD);
    }

    @Override
    public void setNextCryTime(int time) {
        this.field_6011.method_12778(CRY_CD, (Object)time);
    }

    @Override
    public void setCommand(String cmd) {
        this.field_6011.method_12778(COMMAND, (Object)cmd);
    }

    @Override
    public String getCommand() {
        return (String)this.field_6011.method_12789(COMMAND);
    }

    @Override
    public void setCommandData(String cmdData) {
        this.field_6011.method_12778(COMMAND_DATA, (Object)cmdData);
        this.createTargetBlockPos();
    }

    @Override
    public String getCommandData() {
        return (String)this.field_6011.method_12789(COMMAND_DATA);
    }

    @Override
    public class_2338 getTargetBlockPos() {
        return (class_2338)this.field_6011.method_12789(TARGET_BLOCK_POS);
    }

    @Override
    public void setTargetBlockPos(class_2338 blockPos) {
        this.field_6011.method_12778(TARGET_BLOCK_POS, (Object)blockPos);
    }

    @Override
    public int getCapturedBy() {
        return (Integer)this.field_6011.method_12789(DATA_ID_CAPTURED_BY);
    }

    @Override
    public void setCapturedBy(int id) {
        this.field_6011.method_12778(DATA_ID_CAPTURED_BY, (Object)id);
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private float hurtDamageTweak(float amount) {
        if (PokemonUtils.shouldRetreat((PokemonEntity)this)) {
            PokemonAttackEffect.pokemonRecallWithAnimation((PokemonEntity)this);
            return 0.0f;
        }
        PokemonMultipliers pokemonMultipliers = new PokemonMultipliers((PokemonEntity)this);
        Pokemon pokemon = this.getPokemon();
        float def = Math.max(pokemon.getDefence(), pokemon.getSpecialDefence());
        return amount * (1.0f - pokemonMultipliers.getMaximumDamageReduction() * Math.min(CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier, class_3532.method_16439((float)(def / (float)CobblemonFightOrFlight.commonConfig().defense_stat_limit), (float)0.0f, (float)CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier)));
    }

    protected void method_6074(class_1282 damageSource, float damageAmount) {
        float newHealth;
        float d;
        float prevHealth = this.method_6032();
        super.method_6074(damageSource, damageAmount);
        if (PokemonUtils.isUsingNewHealthMechanic() && this.field_6008 == 20 && (d = (newHealth = this.method_6032()) - prevHealth) < 0.0f) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity)this, -d, false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void hurtImmune(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity;
        class_1297 class_12972;
        if (CobblemonFightOrFlight.commonConfig().suffocation_immunity && source.method_48792().equals((Object)this.method_48923().method_48822().method_48792())) {
            cir.setReturnValue((Object)false);
        }
        if ((class_12972 = source.method_5529()) instanceof class_1309 && !PokemonAttackEffect.shouldBeHurtByAllyMob((PokemonEntity)this, livingEntity = (class_1309)class_12972)) {
            cir.setReturnValue((Object)false);
        }
        if (CobblemonFightOrFlight.commonConfig().slow_down_after_hurt && !this.getPokemon().isPlayerOwned()) {
            this.method_6092(new class_1293(class_1294.field_5909, 100, 0));
        }
    }

    public void method_6025(float healAmount) {
        if (PokemonUtils.isUsingNewHealthMechanic()) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity)this, healAmount, true);
        }
        super.method_6025(healAmount);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        class_1309 targetEntity;
        if (Objects.equals(this.getCommand(), PokeStaffComponent.CMDMODE.CLEAR.name())) {
            this.setCommand(PokeStaffComponent.CMDMODE.NOCMD.name());
        }
        if ((targetEntity = this.method_5968()) != null && targetEntity.method_5805()) {
            if (this.getNextCryTime() == 0) {
                this.cry();
                if (CobblemonFightOrFlight.commonConfig().multiple_cries) {
                    this.setNextCryTime(CobblemonFightOrFlight.commonConfig().time_to_cry_again);
                } else {
                    this.setNextCryTime(-1);
                }
            }
        } else {
            this.setNextCryTime(0);
        }
        if (this.getNextCryTime() >= 0) {
            this.setNextCryTime(this.getNextCryTime() - 1);
        }
        if (this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
        }
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="TAIL")})
    private void dropAllDeathLootInject(class_3218 world, class_1282 source, CallbackInfo ci) {
        PokemonEntity pokemonEntity;
        class_1309 class_13092 = this.method_6065();
        if (class_13092 instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)class_13092).method_35057() != null) {
            PokemonEntity self = (PokemonEntity)this;
            pokemonEntity.getPokemon().addExperience((ExperienceSource)new SidemodExperienceSource("fightorflight"), FOFExpCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon()));
            if (CobblemonFightOrFlight.commonConfig().can_gain_ev) {
                Map<Stat, Integer> map = FOFEVCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon());
                for (Map.Entry<Stat, Integer> entry : map.entrySet()) {
                    pokemonEntity.getPokemon().getEvs().add(entry.getKey(), entry.getValue().intValue());
                }
            }
        }
    }
}

