/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DrawableColor MISSING_TEXTURE_COLOR_MAGENTA = DrawableColor.of(Color.MAGENTA);
    public static final DrawableColor MISSING_TEXTURE_COLOR_BLACK = DrawableColor.BLACK;
    public static final class_2960 FULLY_TRANSPARENT_TEXTURE = class_2960.method_60655((String)"fancymenu", (String)"textures/fully_transparent.png");

    public static void renderMissing(@NotNull class_332 graphics, int x, int y, int width, int height) {
        int partW = width / 2;
        int partH = height / 2;
        graphics.method_25294(x, y, x + partW, y + partH, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
        graphics.method_25294(x + partW, y, x + width, y + partH, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.method_25294(x, y + partH, x + partW, y + height, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.method_25294(x + partW, y + partH, x + width, y + height, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
    }

    public static void blitRepeat(@NotNull class_332 graphics, @NotNull class_2960 location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight) {
        graphics.method_25290(location, x, y, 0.0f, 0.0f, areaRenderWidth, areaRenderHeight, texWidth, texHeight);
    }

    public static void blitNineSlicedTexture(@NotNull class_332 graphics, @NotNull class_2960 texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderTop, int borderRight, int borderBottom, int borderLeft) {
        int pieceHeight;
        int j;
        int pieceWidth;
        int i;
        graphics.method_25290(texture, x, y, 0.0f, 0.0f, borderLeft, borderTop, textureWidth, textureHeight);
        graphics.method_25290(texture, x + width - borderRight, y, (float)(textureWidth - borderRight), 0.0f, borderRight, borderTop, textureWidth, textureHeight);
        graphics.method_25290(texture, x, y + height - borderBottom, 0.0f, (float)(textureHeight - borderBottom), borderLeft, borderBottom, textureWidth, textureHeight);
        graphics.method_25290(texture, x + width - borderRight, y + height - borderBottom, (float)(textureWidth - borderRight), (float)(textureHeight - borderBottom), borderRight, borderBottom, textureWidth, textureHeight);
        int centerWidth = textureWidth - borderLeft - borderRight;
        int centerHeight = textureHeight - borderTop - borderBottom;
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.method_25290(texture, x + i, y, (float)borderLeft, 0.0f, pieceWidth, borderTop, textureWidth, textureHeight);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.method_25290(texture, x + i, y + height - borderBottom, (float)borderLeft, (float)(textureHeight - borderBottom), pieceWidth, borderBottom, textureWidth, textureHeight);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.method_25290(texture, x, y + j, 0.0f, (float)borderTop, borderLeft, pieceHeight, textureWidth, textureHeight);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.method_25290(texture, x + width - borderRight, y + j, (float)(textureWidth - borderRight), (float)borderTop, borderRight, pieceHeight, textureWidth, textureHeight);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            for (int j2 = borderTop; j2 < height - borderBottom; j2 += centerHeight) {
                int pieceHeight2 = Math.min(centerHeight, height - borderBottom - j2);
                graphics.method_25290(texture, x + i, y + j2, (float)borderLeft, (float)borderTop, pieceWidth, pieceHeight2, textureWidth, textureHeight);
            }
        }
    }

    public static float getPartialTick() {
        return class_310.method_1551().method_60646().method_60637(false);
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        class_1041 m = class_310.method_1551().method_22683();
        m.method_15997((double)m.method_4476(((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).intValue(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue()));
    }

    public static void resetShaderColor(class_332 graphics) {
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void setShaderColor(class_332 graphics, DrawableColor color) {
        Color c = color.getColor();
        float a = Math.min(1.0f, Math.max(0.0f, (float)c.getAlpha() / 255.0f));
        RenderingUtils.setShaderColor(graphics, color, a);
    }

    public static void setShaderColor(class_332 graphics, DrawableColor color, float alpha) {
        Color c = color.getColor();
        float r = Math.min(1.0f, Math.max(0.0f, (float)c.getRed() / 255.0f));
        float g = Math.min(1.0f, Math.max(0.0f, (float)c.getGreen() / 255.0f));
        float b = Math.min(1.0f, Math.max(0.0f, (float)c.getBlue() / 255.0f));
        graphics.method_51422(r, g, b, alpha);
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull class_332 graphics, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(graphics, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull class_332 graphics, float minX, float minY, float maxX, float maxY, float z, int color) {
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        if (minX < maxX) {
            float $$8 = minX;
            minX = maxX;
            maxX = $$8;
        }
        if (minY < maxY) {
            float $$9 = minY;
            minY = maxY;
            maxY = $$9;
        }
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_22918(matrix4f, minX, minY, z).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, minX, maxY, z).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, maxX, maxY, z).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, maxX, minY, z).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)Objects.requireNonNull(bufferBuilder.method_60794()));
        RenderSystem.disableBlend();
    }

    public static void blitF(@NotNull class_332 graphics, class_2960 location, float x, float y, float f3, float f4, float width, float height, float width2, float height2) {
        RenderingUtils.blit(graphics, location, x, y, width, height, f3, f4, width, height, width2, height2);
    }

    private static void blit(class_332 $$0, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10) {
        RenderingUtils.blit($$0, location, $$1, $$1 + $$3, $$2, $$2 + $$4, 0.0f, $$7, $$8, $$5, $$6, $$9, $$10);
    }

    private static void blit(class_332 graphics, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.innerBlit(graphics, location, $$1, $$2, $$3, $$4, $$5, ($$8 + 0.0f) / $$10, ($$8 + $$6) / $$10, ($$9 + 0.0f) / $$11, ($$9 + $$7) / $$11);
    }

    private static void innerBlit(class_332 graphics, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderSystem.setShaderTexture((int)0, (class_2960)location);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f $$10 = graphics.method_51448().method_23760().method_23761();
        class_287 $$11 = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        $$11.method_22918($$10, $$1, $$3, $$5).method_22913($$6, $$8);
        $$11.method_22918($$10, $$1, $$4, $$5).method_22913($$6, $$9);
        $$11.method_22918($$10, $$2, $$4, $$5).method_22913($$7, $$9);
        $$11.method_22918($$10, $$2, $$3, $$5).method_22913($$7, $$8);
        class_286.method_43433((class_9801)Objects.requireNonNull($$11.method_60794()));
    }
}

