/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.experimental.lai;

import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.ActionKeys;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.BattleEvaluator;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.BattleState;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.RatedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class BattleMemory<T>
extends class_18 {
    private static final Random RNG = new Random();
    private static final double RATING_MARGIN = 0.075;
    private static final String FILE = "rctapi.lai.knowledge";
    private BattleEvaluator evaluator = new BattleEvaluator();
    private Map<String, RatedAction<T>> exactActions = new HashMap<String, RatedAction<T>>();
    private Map<String, RatedAction<T>> fuzzyActions = new HashMap<String, RatedAction<T>>();
    private BattleState previousState;
    private BattleState currentState;
    private RatedAction<T> previousAction;

    public static <T> BattleMemory<T> load(MinecraftServer server) {
        return BattleMemory.load(server, FILE);
    }

    public static <T> BattleMemory<T> load(MinecraftServer server, String path) {
        return (BattleMemory)server.method_30002().method_17983().method_17924(new class_18.class_8645(BattleMemory::new, BattleMemory::of, class_4284.field_19212), path);
    }

    public static <T> BattleMemory<T> of(class_2487 tag, class_7225.class_7874 provider) {
        BattleMemory<T> bm = new BattleMemory<T>();
        class_2487 exacts = tag.method_10562("exacts");
        class_2487 fuzzies = tag.method_10562("fuzzies");
        exacts.method_10541().forEach(key -> bm.exactActions.put((String)key, new RatedAction(exacts.method_10574(key))));
        fuzzies.method_10541().forEach(key -> bm.fuzzyActions.put((String)key, new RatedAction(fuzzies.method_10574(key))));
        return bm;
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 provider) {
        class_2487 exacts = new class_2487();
        class_2487 fuzzies = new class_2487();
        this.exactActions.entrySet().forEach(kv -> exacts.method_10549((String)kv.getKey(), ((RatedAction)kv.getValue()).getRating()));
        this.fuzzyActions.entrySet().forEach(kv -> fuzzies.method_10549((String)kv.getKey(), ((RatedAction)kv.getValue()).getRating()));
        tag.method_10566("exacts", (class_2520)exacts);
        tag.method_10566("fuzzies", (class_2520)fuzzies);
        return tag;
    }

    public void next(ActiveBattlePokemon pkmn) {
        this.currentState = BattleState.of(pkmn);
        if (this.previousAction != null) {
            this.evaluator.update(this.previousAction, this.previousState, this.currentState);
            this.method_80();
        }
        this.previousState = this.currentState;
        this.previousAction = null;
    }

    public Optional<T> getChoice() {
        return this.previousAction != null ? Optional.of(this.previousAction.get()) : Optional.empty();
    }

    public RatedAction<T> getOrAdd(ActiveBattlePokemon from, BattlePokemon to, Supplier<T> supplier) {
        return this.storeIfBest(this.exactActions.compute(ActionKeys.switchKey(from, to), (k, v) -> {
            if (v == null) {
                return this.getOrAddFuzzy(ActionKeys.switchFuzzyKey(from, to), supplier);
            }
            return v.withSupplier(supplier);
        }));
    }

    public RatedAction<T> getOrAdd(BagItem item, BattlePokemon target, Supplier<T> supplier) {
        return this.storeIfBest(this.exactActions.compute(ActionKeys.itemKey(item, target), (k, v) -> {
            if (v == null) {
                return this.getOrAddFuzzy(ActionKeys.itemFuzzyKey(item, target), supplier);
            }
            return v.withSupplier(supplier);
        }));
    }

    public RatedAction<T> getOrAdd(ActiveBattlePokemon pkmn, InBattleMove move, Targetable target, Supplier<T> supplier) {
        return this.storeIfBest(this.exactActions.compute(ActionKeys.moveKey(pkmn, move, target), (k, v) -> {
            if (v == null) {
                return this.getOrAddFuzzy(ActionKeys.moveFuzzyKey(pkmn, move, target), supplier);
            }
            return v.withSupplier(supplier);
        }));
    }

    protected RatedAction<T> getOrAddFuzzy(String key, Supplier<T> supplier) {
        return this.fuzzyActions.compute(key, (k, v) -> {
            if (v == null) {
                return new RatedAction(supplier);
            }
            return v.withSupplier(supplier);
        });
    }

    protected RatedAction<T> storeIfBest(RatedAction<T> nextAction) {
        double r = nextAction.getRating();
        double m = 0.075 * RNG.nextDouble();
        if (this.previousAction == null || r + m > this.previousAction.getRating()) {
            this.previousAction = nextAction;
        }
        return nextAction;
    }
}

