/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.experimental.lai;

import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.ForcePassActionResponse;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.SwitchActionResponse;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.BattleMemory;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import java.util.List;

public class LearningBattleAI
implements BattleAI {
    private final BattleMemory<ShowdownActionResponse> battleMemory;

    public LearningBattleAI(BattleMemory<ShowdownActionResponse> battleMemory) {
        this.battleMemory = battleMemory;
    }

    public ShowdownActionResponse choose(ActiveBattlePokemon pkmn, ShowdownMoveset moveset, boolean forceSwitch) {
        this.battleMemory.next(pkmn);
        List<BattlePokemon> switchCandidates = pkmn.getActor().getPokemonList().stream().filter(BattlePokemon::canBeSentOut).toList();
        for (BattlePokemon candidate : switchCandidates) {
            this.battleMemory.getOrAdd(pkmn, candidate, () -> {
                candidate.setWillBeSwitchedIn(true);
                return new SwitchActionResponse(candidate.getUuid());
            });
        }
        if (!forceSwitch && pkmn.hasPokemon()) {
            Object object;
            if (pkmn.getActor().canFitForcedAction() && (object = pkmn.getActor()) instanceof BattleManager.TrainerEntityBattleActor) {
                BattleManager.TrainerEntityBattleActor actor = (BattleManager.TrainerEntityBattleActor)((Object)object);
                for (BagItem candidate : actor.getBag().getItems()) {
                    for (BattlePokemon target : pkmn.getActor().getPokemonList()) {
                        if (!candidate.canUse(pkmn.getBattle(), target)) continue;
                        this.battleMemory.getOrAdd(candidate, target, () -> {
                            actor.forceChoose((ShowdownActionResponse)new BagItemActionResponse(actor.getBag().use(candidate), pkmn.getBattlePokemon(), pkmn.getBattlePokemon().getUuid().toString()));
                            return new ForcePassActionResponse();
                        });
                    }
                }
            }
            if (moveset != null) {
                List<InBattleMove> moveCandidates = moveset.moves.stream().filter(InBattleMove::canBeUsed).toList();
                if (moveCandidates.isEmpty()) {
                    return new MoveActionResponse("struggle", null, null);
                }
                for (InBattleMove move : moveCandidates) {
                    List targets = move.getTargets(pkmn);
                    if (targets == null) {
                        this.battleMemory.getOrAdd(pkmn, move, null, () -> new MoveActionResponse(move.id, null, null));
                        continue;
                    }
                    for (Targetable target : targets) {
                        if (!target.hasPokemon()) continue;
                        this.battleMemory.getOrAdd(pkmn, move, target, () -> new MoveActionResponse(move.id, target.getPNX(), null));
                    }
                }
            }
        }
        return this.battleMemory.getChoice().orElse((ShowdownActionResponse)PassActionResponse.INSTANCE);
    }
}

