/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.ai.utils.Debug;
import com.gitlab.srcmc.rctapi.api.ai.utils.TypeChart;
import java.util.Collection;
import net.minecraft.class_1792;

public class BattleEffects {
    public static void dump(BattlePokemon pkmn) {
        int n = 2;
        Debug.Action action = () -> ModCommon.LOG.info("CONTEXTS DUMP " + pkmn.getName().getString() + ", turn: " + BattleStates.get(pkmn.getActor().getBattle()).getPokemonState(pkmn).age(Custom.TURN));
        int n2 = 2;
        Debug.Action action2 = () -> {
            ModCommon.LOG.info("CONTEXT TYPES:");
            pkmn.getContextManager().getBuckets().forEach((t, c) -> c.forEach(bc -> ModCommon.LOG.info(String.format(" - id: %s, turn: %d, type: %s, damaging: %b, exclusive: %b", bc.getId(), bc.getTurn(), bc.getType().name(), bc.getType().getDamaging(), bc.getType().getExclusive()))));
            ModCommon.LOG.info("SIDE CONTEXT:");
            pkmn.actor.getSide().getContextManager().getBuckets().forEach((t, c) -> c.forEach(bc -> ModCommon.LOG.info(String.format(" - id: %s, turn: %d, type: %s, damaging: %b, exclusive: %b", bc.getId(), bc.getTurn(), bc.getType().name(), bc.getType().getDamaging(), bc.getType().getExclusive()))));
            ModCommon.LOG.info("BATTLE CONTEXT:");
            pkmn.actor.battle.getContextManager().getBuckets().forEach((t, c) -> c.forEach(bc -> ModCommon.LOG.info(String.format(" - id: %s, turn: %d, type: %s, damaging: %b, exclusive: %b", bc.getId(), bc.getTurn(), bc.getType().name(), bc.getType().getDamaging(), bc.getType().getExclusive()))));
        };
        int n3 = 3;
        Debug.Action action3 = () -> {
            ModCommon.LOG.info("MAJOR ACTIONS:");
            pkmn.actor.battle.getMajorBattleActions().values().forEach(msg -> ModCommon.LOG.info(" - " + msg.getRawMessage()));
            ModCommon.LOG.info("MINOR ACTIONS:");
            pkmn.actor.battle.getMinorBattleActions().values().forEach(msg -> ModCommon.LOG.info(" - " + msg.getRawMessage()));
        };
    }

    public static enum Custom {
        TURN(1, Integer.MAX_VALUE),
        BLOCK(2),
        MEANLOOK(4),
        SPIDERWEB(8),
        ITEM_ENDED(16),
        WISH(32, 1, true),
        PROTECT(64, 1);

        private long mask;
        private int expires;
        private boolean persists;

        private Custom(int mask) {
            this(mask, -1);
        }

        private Custom(int mask, int expires) {
            this(mask, expires, false);
        }

        private Custom(int mask, int expires, boolean persists) {
            this.mask = mask;
            this.expires = expires;
            this.persists = persists;
        }

        public long mask() {
            return this.mask;
        }

        public int expires() {
            return this.expires;
        }

        public boolean persists() {
            return this.persists;
        }
    }

    public static class Field {

        public static final class Gravity {
            public static boolean gravity(BattlePokemon pkmn) {
                return Gravity.has(pkmn, "gravity");
            }

            private static boolean has(BattlePokemon pkmn, String gravityId) {
                Collection ctx = pkmn.actor.battle.getContextManager().get(BattleContext.Type.GRAVITY);
                return ctx != null && ctx.stream().anyMatch(bc -> bc.getId().equals(gravityId));
            }
        }

        public static final class Room {
            public static boolean trickroom(BattlePokemon pkmn) {
                return Room.has(pkmn, "trickroom");
            }

            private static boolean has(BattlePokemon pkmn, String roomId) {
                Collection ctx = pkmn.actor.battle.getContextManager().get(BattleContext.Type.ROOM);
                return ctx != null && ctx.stream().anyMatch(bc -> bc.getId().equals(roomId));
            }
        }

        public static final class Weather {
            public static boolean harshsunlight(BattlePokemon pkmn) {
                return Weather.has(pkmn, "harshsunlight");
            }

            public static boolean rain(BattlePokemon pkmn) {
                return Weather.has(pkmn, "rain");
            }

            public static boolean sandstorm(BattlePokemon pkmn) {
                return Weather.has(pkmn, "sandstorm");
            }

            public static boolean hail(BattlePokemon pkmn) {
                return Weather.has(pkmn, "hail");
            }

            public static boolean snow(BattlePokemon pkmn) {
                return Weather.has(pkmn, "snow");
            }

            public static boolean fog(BattlePokemon pkmn) {
                return Weather.has(pkmn, "fog");
            }

            public static boolean extremelyharshsunlight(BattlePokemon pkmn) {
                return Weather.has(pkmn, "extremelyharshsunlight");
            }

            public static boolean heavyrain(BattlePokemon pkmn) {
                return Weather.has(pkmn, "heavyrain");
            }

            public static boolean strongwinds(BattlePokemon pkmn) {
                return Weather.has(pkmn, "strongwinds");
            }

            public static boolean shadowaura(BattlePokemon pkmn) {
                return Weather.has(pkmn, "shadowaura");
            }

            private static boolean has(BattlePokemon pkmn, String weatherId) {
                Collection ctx = pkmn.actor.battle.getContextManager().get(BattleContext.Type.WEATHER);
                return ctx != null && ctx.stream().anyMatch(bc -> bc.getId().equals(weatherId));
            }
        }

        public static final class Terrain {
            public static boolean electricterrain(BattlePokemon pkmn) {
                return Terrain.has(pkmn, "electricterrain");
            }

            public static boolean grassyterrain(BattlePokemon pkmn) {
                return Terrain.has(pkmn, "grassyterrain");
            }

            public static boolean mistyterrain(BattlePokemon pkmn) {
                return Terrain.has(pkmn, "mistyterrain");
            }

            public static boolean psychicterrain(BattlePokemon pkmn) {
                return Terrain.has(pkmn, "psychicterrain");
            }

            private static boolean has(BattlePokemon pkmn, String terrainId) {
                Collection ctx = pkmn.actor.battle.getContextManager().get(BattleContext.Type.TERRAIN);
                return ctx != null && ctx.stream().anyMatch(bc -> bc.getId().equals(terrainId));
            }
        }
    }

    public static class Side {

        public static final class Tailwind {
            public static boolean tailwind(BattlePokemon pkmn) {
                return Tailwind.has(pkmn, "tailwind");
            }

            private static boolean has(BattlePokemon pkmn, String tailwindId) {
                Collection ctx = pkmn.actor.getSide().getContextManager().get(BattleContext.Type.TAILWIND);
                return ctx != null && ctx.stream().anyMatch(bc -> bc.getId().equals(tailwindId));
            }
        }

        public static final class Hazard {
            public static int spikes(BattlePokemon pkmn) {
                return Hazard.get(pkmn, "spikes");
            }

            public static int stealthrock(BattlePokemon pkmn) {
                return Hazard.get(pkmn, "stealthrock");
            }

            public static int toxicspikes(BattlePokemon pkmn) {
                return Hazard.get(pkmn, "toxicspikes");
            }

            public static int stickyweb(BattlePokemon pkmn) {
                return Hazard.get(pkmn, "stickyweb");
            }

            public static int sharpsteel(BattlePokemon pkmn) {
                return Hazard.get(pkmn, "sharpsteel");
            }

            private static int get(BattlePokemon pkmn, String hazardId) {
                Collection ctx = pkmn.actor.getSide().getContextManager().get(BattleContext.Type.HAZARD);
                return ctx != null ? (int)ctx.stream().filter(bc -> bc.getId().equals(hazardId)).count() : 0;
            }
        }

        public static final class Screen {
            public static boolean auroraveil(BattlePokemon pkmn) {
                return Screen.has(pkmn, "auroraveil");
            }

            public static boolean lightscreen(BattlePokemon pkmn) {
                return Screen.has(pkmn, "lightscreen");
            }

            public static boolean reflect(BattlePokemon pkmn) {
                return Screen.has(pkmn, "reflect");
            }

            private static boolean has(BattlePokemon pkmn, String screenId) {
                Collection ctx = pkmn.actor.getSide().getContextManager().get(BattleContext.Type.SCREEN);
                return ctx != null && ctx.stream().anyMatch(bc -> bc.getId().equals(screenId));
            }
        }
    }

    public class Pokemon {
        public Pokemon(BattleEffects this$0) {
        }

        public static final class State {
            public static boolean raised(BattlePokemon pkmn) {
                if (Field.Gravity.gravity(pkmn)) {
                    return false;
                }
                if (Volatile.ingrain(pkmn)) {
                    return false;
                }
                if (Volatile.smackdown(pkmn)) {
                    return false;
                }
                if (pkmn.getEffectedPokemon().heldItem().method_31574((class_1792)CobblemonItems.IRON_BALL) && !BattleStates.get(pkmn.actor.battle).getPokemonState(pkmn).has(Custom.ITEM_ENDED)) {
                    return false;
                }
                if (pkmn.getEffectedPokemon().heldItem().method_31574((class_1792)CobblemonItems.AIR_BALLOON) && !BattleStates.get(pkmn.actor.battle).getPokemonState(pkmn).has(Custom.ITEM_ENDED)) {
                    return true;
                }
                if (pkmn.getEffectedPokemon().getAbility().getName().equals("levitate")) {
                    return true;
                }
                for (ElementalType t : pkmn.getEffectedPokemon().getTypes()) {
                    if (!t.equals(ElementalTypes.INSTANCE.getFLYING())) continue;
                    return true;
                }
                if (Volatile.magnetrise(pkmn)) {
                    return true;
                }
                return Volatile.telekinesis(pkmn);
            }

            public static boolean magnetic(BattlePokemon pkmn) {
                return TypeChart.is(pkmn, 512);
            }

            public static boolean trapped(BattlePokemon pkmn) {
                return !TypeChart.is(pkmn, 256) && (BattleStates.get(pkmn.getActor().getBattle()).getPokemonState(pkmn).has(Custom.BLOCK) || BattleStates.get(pkmn.getActor().getBattle()).getPokemonState(pkmn).has(Custom.MEANLOOK) || BattleStates.get(pkmn.getActor().getBattle()).getPokemonState(pkmn).has(Custom.SPIDERWEB)) || !pkmn.getEffectedPokemon().getHeldItem$common().method_31574((class_1792)CobblemonItems.SHED_SHELL) && (!pkmn.getEffectedPokemon().getAbility().getName().equals("shadowtag") && pkmn.getActor().getSide().getOppositeSide().getActivePokemon().stream().filter(p -> p.isAlive()).map(p -> p.getBattlePokemon()).anyMatch(p -> p.getEffectedPokemon().getAbility().getName().equals("shadowtag")) || State.magnetic(pkmn) && pkmn.getActor().getSide().getOppositeSide().getActivePokemon().stream().filter(p -> p.isAlive()).map(p -> p.getBattlePokemon()).anyMatch(p -> p.getEffectedPokemon().getAbility().getName().equals("magnetpull")) || !State.raised(pkmn) && pkmn.getActor().getSide().getOppositeSide().getActivePokemon().stream().filter(p -> p.isAlive()).map(p -> p.getBattlePokemon()).anyMatch(p -> p.getEffectedPokemon().getAbility().getName().equals("arenatrap")));
            }
        }

        public class Status {
            public Status(Pokemon this$1) {
            }

            public static boolean psn(BattlePokemon pkmn) {
                return Status.has(pkmn, "psn");
            }

            public static boolean tox(BattlePokemon pkmn) {
                return Status.has(pkmn, "tox");
            }

            public static boolean par(BattlePokemon pkmn) {
                return Status.has(pkmn, "par");
            }

            public static boolean slp(BattlePokemon pkmn) {
                return Status.has(pkmn, "slp");
            }

            public static boolean frz(BattlePokemon pkmn) {
                return Status.has(pkmn, "frz");
            }

            public static boolean brn(BattlePokemon pkmn) {
                return Status.has(pkmn, "brn");
            }

            public static boolean any(BattlePokemon pkmn) {
                Collection ctx = pkmn.getContextManager().get(BattleContext.Type.STATUS);
                return ctx != null && !ctx.isEmpty();
            }

            private static boolean has(BattlePokemon pkmn, String effId) {
                Collection ctx = pkmn.getContextManager().get(BattleContext.Type.STATUS);
                return ctx != null && ctx.stream().filter(bc -> bc.getId().equals(effId)).findFirst().isPresent();
            }
        }

        public class Volatile {
            public Volatile(Pokemon this$1) {
            }

            public static boolean attract(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "attract");
            }

            public static boolean confusion(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "confusion");
            }

            public static boolean cursed(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "cursed");
            }

            public static boolean leech(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "leech");
            }

            public static boolean ingrain(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "ingrain");
            }

            public static boolean aquaring(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "aquaring");
            }

            public static boolean smackdown(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "smackdown");
            }

            public static boolean telekinesis(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "telekinesis");
            }

            public static boolean magnetrise(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "magnetrise");
            }

            public static boolean yawn(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "yawn");
            }

            public static boolean taunt(BattlePokemon pkmn) {
                return Volatile.has(pkmn, "taunt");
            }

            public static boolean any(BattlePokemon pkmn) {
                Collection ctx = pkmn.getContextManager().get(BattleContext.Type.VOLATILE);
                return ctx != null && !ctx.isEmpty();
            }

            private static boolean has(BattlePokemon pkmn, String volId) {
                Collection ctx = pkmn.getContextManager().get(BattleContext.Type.VOLATILE);
                return ctx != null && ctx.stream().filter(bc -> bc.getId().equals(volId)).findFirst().isPresent();
            }
        }

        public static final class Boost {
            public static double atk(BattlePokemon pkmn) {
                return Boost.get(pkmn, "atk");
            }

            public static double def(BattlePokemon pkmn) {
                return Boost.get(pkmn, "def");
            }

            public static double spa(BattlePokemon pkmn) {
                return Boost.get(pkmn, "spa");
            }

            public static double spd(BattlePokemon pkmn) {
                return Boost.get(pkmn, "spd");
            }

            public static double spe(BattlePokemon pkmn) {
                return Boost.get(pkmn, "spe");
            }

            public static double evasion(BattlePokemon pkmn) {
                return Boost.get(pkmn, "evasion");
            }

            public static double avg(BattlePokemon pkmn) {
                return (Boost.atk(pkmn) + Boost.def(pkmn) + Boost.spa(pkmn) + Boost.spd(pkmn) + Boost.spd(pkmn) + Boost.evasion(pkmn)) / 6.0;
            }

            private static double get(BattlePokemon pkmn, String statId) {
                Collection bctx = pkmn.getContextManager().get(BattleContext.Type.BOOST);
                Collection uctx = pkmn.getContextManager().get(BattleContext.Type.UNBOOST);
                return (double)((bctx == null ? 0L : bctx.stream().filter(c -> c.getId().equals(statId)).count()) - (uctx == null ? 0L : uctx.stream().filter(c -> c.getId().equals(statId)).count())) / 6.0;
            }
        }
    }
}

