/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.gitlab.srcmc.rctapi.api.ai.utils.TypeChart;
import java.util.Collection;
import java.util.Random;

public class PokeMath {
    private static final Random RANDOM = new Random();
    private static final String WEATHER_SUN = "sunny";
    private static final String WEATHER_RAIN = "raining";

    private static double damage(int attackerLevel, int attackerEffectiveAttack, int defenderEffectiveDefence, double movePower, boolean physical, boolean multiTarget, boolean rain, boolean sun, boolean parentalBond, boolean glaiveRush, boolean burn, boolean zmove, boolean reflect, boolean lightscreen, boolean attackerHasStatus, ElementalType moveType, BattlePokemon attacker, BattlePokemon defender) {
        Pokemon attackerEp = attacker.getEffectedPokemon();
        ElementalType attackerPrimaryType = attackerEp.getPrimaryType();
        ElementalType attackerSecondaryType = attackerEp.getSecondaryType();
        Ability attackerAbility = attackerEp.getAbility();
        int baseDamage = (int)(((double)(2 * attackerLevel) / 5.0 + 2.0) * movePower * (double)attackerEffectiveAttack / (double)defenderEffectiveDefence / 50.0) + 2;
        if (multiTarget) {
            baseDamage = (int)((double)baseDamage * 0.75);
        }
        if (parentalBond) {
            baseDamage = (int)((double)baseDamage * 0.25);
        }
        if (glaiveRush) {
            baseDamage *= 2;
        }
        if (burn && physical && !attackerAbility.getDisplayName().equals("cobblemon.ability.guts")) {
            baseDamage = (int)((double)baseDamage * 0.5);
        }
        if (attackerHasStatus && attackerAbility.getDisplayName().equals("cobblemon.ability.guts")) {
            baseDamage = (int)((double)baseDamage * 1.5);
        }
        if (sun && moveType.equals(ElementalTypes.INSTANCE.getFIRE()) || rain && moveType.equals(ElementalTypes.INSTANCE.getWATER())) {
            baseDamage = (int)((double)baseDamage * 1.5);
        }
        if (sun && moveType.equals(ElementalTypes.INSTANCE.getWATER()) || rain && moveType.equals(ElementalTypes.INSTANCE.getFIRE())) {
            baseDamage = (int)((double)baseDamage * 0.5);
        }
        if (moveType.equals(attackerPrimaryType) || moveType.equals(attackerSecondaryType)) {
            baseDamage = (int)((double)baseDamage * 1.5);
        }
        return (baseDamage = (int)((double)baseDamage * TypeChart.getEffectiveness(moveType, defender))) > 0 ? Math.max(1.0, (double)baseDamage * (RANDOM.nextDouble() * 0.15 + 0.85)) : (double)baseDamage;
    }

    public static int damage(BattlePokemon attacker, BattlePokemon defender, InBattleMove inBattleMove) {
        Move move = TypeChart.getMove(inBattleMove);
        String damageCategory = move.getDamageCategory().getName();
        if (damageCategory.equals(DamageCategories.INSTANCE.getSTATUS().getName())) {
            return 0;
        }
        boolean isPhysicalMove = damageCategory.equals(DamageCategories.INSTANCE.getPHYSICAL().getName());
        boolean isAttackerBurned = false;
        PersistentStatusContainer statusContainer = attacker.getEffectedPokemon().getStatus();
        Collection weather = attacker.getContextManager().get(BattleContext.Type.WEATHER);
        Collection status = attacker.getContextManager().get(BattleContext.Type.STATUS);
        double acc = move.getAccuracy() / 100.0;
        if (statusContainer != null && !statusContainer.isExpired()) {
            isAttackerBurned = statusContainer.getStatus().equals(Statuses.INSTANCE.getBURN());
        }
        return (int)Math.ceil((acc + RANDOM.nextDouble() * (1.0 - acc)) * PokeMath.damage(attacker.getEffectedPokemon().getLevel(), attacker.getEffectedPokemon().getStat((Stat)(isPhysicalMove ? Stats.ATTACK : Stats.SPECIAL_ATTACK)), defender.getEffectedPokemon().getStat((Stat)(isPhysicalMove ? Stats.DEFENCE : Stats.SPECIAL_DEFENCE)), move.getPower(), isPhysicalMove, false, weather != null && weather.stream().anyMatch(c -> c.getId().equals(WEATHER_RAIN)), weather != null && weather.stream().anyMatch(c -> c.getId().equals(WEATHER_SUN)), false, false, isAttackerBurned, false, false, false, status != null && !status.isEmpty(), move.getType(), attacker, defender));
    }
}

