/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.models;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.api.util.Text;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class PokemonModel
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String species;
    private Text nickname;
    private String gender;
    private int level;
    private String nature;
    private String ability;
    private Set<String> moveset;
    private StatsModel ivs;
    private StatsModel evs;
    private boolean shiny;
    private String heldItem;
    private Set<String> aspects;

    public String getSpecies() {
        return this.species;
    }

    public Text getNickname() {
        return this.nickname;
    }

    public String getGender() {
        return this.gender;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNature() {
        return this.nature;
    }

    public String getAbility() {
        return this.ability;
    }

    public Set<String> getMoveset() {
        return Collections.unmodifiableSet(this.moveset);
    }

    public StatsModel getIVs() {
        return this.ivs;
    }

    public StatsModel getEVs() {
        return this.evs;
    }

    public boolean isShiny() {
        return this.shiny;
    }

    public String getHeldItem() {
        return this.heldItem;
    }

    public Set<String> getAspects() {
        return Collections.unmodifiableSet(this.aspects);
    }

    public PokemonModel() {
        this("", "GENDERLESS", 1, "", "", Set.of(), new StatsModel(), new StatsModel(), false, "", Set.of());
    }

    public PokemonModel(@NotNull String species, @NotNull String gender, int level, @NotNull String nature, @NotNull String ability, @NotNull Set<String> moveset, @NotNull StatsModel ivs, @NotNull StatsModel evs, boolean shiny, @NotNull String heldItem, @NotNull Set<String> aspects) {
        this(species, Text.empty(), gender, level, nature, ability, moveset, ivs, evs, shiny, heldItem, aspects);
    }

    public PokemonModel(@NotNull String species, @NotNull String nickname, @NotNull String gender, int level, @NotNull String nature, @NotNull String ability, @NotNull Set<String> moveset, @NotNull StatsModel ivs, @NotNull StatsModel evs, boolean shiny, @NotNull String heldItem, @NotNull Set<String> aspects) {
        this(species, Text.literal(nickname), gender, level, nature, ability, moveset, ivs, evs, shiny, heldItem, aspects);
    }

    public PokemonModel(@NotNull String species, @NotNull Text nickname, @NotNull String gender, int level, @NotNull String nature, @NotNull String ability, @NotNull Set<String> moveset, @NotNull StatsModel ivs, @NotNull StatsModel evs, boolean shiny, @NotNull String heldItem, @NotNull Set<String> aspects) {
        this.species = species;
        this.nickname = nickname;
        this.gender = gender;
        this.level = level;
        this.nature = nature;
        this.ability = ability;
        this.moveset = moveset;
        this.ivs = ivs;
        this.evs = evs;
        this.shiny = shiny;
        this.heldItem = heldItem;
        this.aspects = aspects;
    }

    public PokemonModel(Pokemon pokemon) {
        this.species = pokemon.getSpecies().getName();
        this.nickname = pokemon.getNickname() != null ? Text.literal(pokemon.getNickname().getString()) : Text.empty();
        this.gender = pokemon.getGender().method_15434();
        this.level = pokemon.getLevel();
        this.nature = pokemon.getNature().getName().toString();
        this.ability = pokemon.getAbility().getName();
        this.moveset = pokemon.getMoveSet().getMoves().stream().map(m -> m.getName()).collect(Collectors.toSet());
        this.ivs = new StatsModel();
        this.ivs.hp = pokemon.getIvs().getOrDefault((Stat)Stats.HP);
        this.ivs.atk = pokemon.getIvs().getOrDefault((Stat)Stats.ATTACK);
        this.ivs.def = pokemon.getIvs().getOrDefault((Stat)Stats.DEFENCE);
        this.ivs.spa = pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK);
        this.ivs.spd = pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE);
        this.ivs.spe = pokemon.getIvs().getOrDefault((Stat)Stats.SPEED);
        this.evs = new StatsModel();
        this.evs.hp = pokemon.getEvs().getOrDefault((Stat)Stats.HP);
        this.evs.atk = pokemon.getEvs().getOrDefault((Stat)Stats.ATTACK);
        this.evs.def = pokemon.getEvs().getOrDefault((Stat)Stats.DEFENCE);
        this.evs.spa = pokemon.getEvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK);
        this.evs.spd = pokemon.getEvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE);
        this.evs.spe = pokemon.getEvs().getOrDefault((Stat)Stats.SPEED);
        this.shiny = pokemon.getShiny();
        this.heldItem = class_7923.field_41178.method_10221((Object)pokemon.heldItem().method_7909()).toString();
        this.aspects = pokemon.getAspects();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PokemonModel)) return false;
        PokemonModel other = (PokemonModel)obj;
        if (!this.species.equals(other.species)) return false;
        if (!this.nickname.equals(other.nickname)) return false;
        if (!this.gender.equals(other.gender)) return false;
        if (this.level != other.level) return false;
        if (!this.nature.equals(other.nature)) return false;
        if (!this.ability.equals(other.ability)) return false;
        if (!this.moveset.equals(other.moveset)) return false;
        if (!this.ivs.equals(other.ivs)) return false;
        if (!this.evs.equals(other.evs)) return false;
        if (this.shiny != other.shiny) return false;
        if (!this.heldItem.equals(other.heldItem)) return false;
        if (!this.aspects.equals(other.aspects)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.species, this.nickname, this.gender, this.level, this.nature, this.ability, this.moveset, this.ivs, this.evs, this.shiny, this.heldItem, this.aspects);
    }

    public static class StatsModel
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private int hp;
        private int atk;
        private int def;
        private int spa;
        private int spd;
        private int spe;

        public int getHP() {
            return this.hp;
        }

        public int getAtk() {
            return this.atk;
        }

        public int getDef() {
            return this.def;
        }

        public int getSpA() {
            return this.spa;
        }

        public int getSpD() {
            return this.spd;
        }

        public int getSpe() {
            return this.spe;
        }

        public StatsModel() {
        }

        public StatsModel(int hp, int atk, int def, int spa, int spd, int spe) {
            this.hp = hp;
            this.atk = atk;
            this.def = def;
            this.spa = spa;
            this.spd = spd;
            this.spe = spe;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof StatsModel)) return false;
            StatsModel other = (StatsModel)obj;
            if (this.hp != other.hp) return false;
            if (this.atk != other.atk) return false;
            if (this.def != other.def) return false;
            if (this.spa != other.spa) return false;
            if (this.spd != other.spd) return false;
            if (this.spe != other.spe) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.hp, this.atk, this.def, this.spa, this.spd, this.spe);
        }
    }
}

