/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.trainer;

import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.pokemon.OriginalTrainerType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.properties.UncatchableProperty;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerBag;
import com.gitlab.srcmc.rctapi.api.util.Text;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TrainerNPC
implements Trainer {
    public static final String DUMMY_TAG = "rctapi:dummy";
    private Text name;
    private Text entityName;
    private Pokemon[] team;
    private TrainerBag bag;
    private BattleAI battleAI;
    private class_1309 entity;
    private static class_1309 dummyEntity;

    public TrainerNPC(@NotNull Pokemon[] team, @NotNull TrainerBag bag, @NotNull BattleAI battleAI, @NotNull class_1309 entity) {
        this(Text.empty(), team, bag, battleAI, entity);
    }

    public TrainerNPC(@NotNull String name, @NotNull Pokemon[] team, @NotNull TrainerBag bag, @NotNull BattleAI battleAI, @NotNull class_1309 entity) {
        this(Text.literal(name), team, bag, battleAI, entity);
    }

    public TrainerNPC(@NotNull Text name, @NotNull Pokemon[] team, @NotNull TrainerBag bag, @NotNull BattleAI battleAI, @NotNull class_1309 entity) {
        this.name = name;
        this.team = team;
        this.bag = bag;
        this.battleAI = battleAI;
        this.setEntity(entity);
    }

    public TrainerNPC(@NotNull TrainerNPC other) {
        this.name = other.name;
        this.team = TrainerNPC.copyTeam(other.team);
        this.bag = other.bag;
        this.battleAI = other.battleAI;
        this.setEntity(other.entity);
    }

    public void setEntity(@NotNull class_1309 entity) {
        this.entity = entity;
        this.entityName = Text.literal(entity.method_5476().getString());
    }

    @NotNull
    public BattleAI getBattleAI() {
        return this.battleAI;
    }

    @NotNull
    public TrainerBag getBag() {
        return this.bag;
    }

    @Override
    @NotNull
    public Text getName() {
        return this.name.getComponent(new Object[0]).getString().isEmpty() && this.getEntity().method_5476() != null ? this.entityName : this.name;
    }

    @Override
    @NotNull
    public Pokemon[] getTeam() {
        return this.team;
    }

    @Override
    @NotNull
    public class_1309 getEntity() {
        return this.entity;
    }

    void initTeam(String otId) {
        for (Pokemon pkmn : this.team) {
            pkmn.setOriginalTrainer(otId);
            pkmn.setOriginalTrainerName(this.getName().getComponent(new Object[0]).getString());
            pkmn.setOriginalTrainerType$common(OriginalTrainerType.NPC);
            pkmn.getCustomProperties().add(UncatchableProperty.INSTANCE.uncatchable());
        }
    }

    private static Pokemon[] copyTeam(Pokemon[] team) {
        Pokemon[] copy = new Pokemon[team.length];
        for (int i = 0; i < team.length; ++i) {
            copy[i] = team[i].clone(true, null);
        }
        return copy;
    }

    public static class_1309 getDummyEntity(MinecraftServer server) {
        if (dummyEntity == null || dummyEntity.method_5682() != server || !dummyEntity.method_5805()) {
            if (dummyEntity != null) {
                dummyEntity.method_31472();
            }
            class_1646 dummy = (class_1646)class_1299.field_6077.method_5883((class_1937)server.method_30002());
            dummy = (class_1646)class_1299.field_6077.method_5883((class_1937)server.method_30002());
            dummy.method_5780(DUMMY_TAG);
            dummy.method_5875(true);
            dummy.method_5684(true);
            dummy.method_5648(true);
            dummy.method_5977(true);
            dummy.field_5960 = true;
            dummy.method_5814(0.0, 1.073741823E9, 0.0);
            dummyEntity = dummy;
        }
        return dummyEntity;
    }
}

