/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.util;

import com.gitlab.srcmc.rctapi.ModCommon;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class JTO<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Map<TypeToken<?>, Map<String, Parser<?>>> PARSERS = new HashMap();
    private static final Gson GSON = new Gson();
    private String type = "";
    private JsonObject data = new JsonObject();
    private transient T target;
    private transient Supplier<T> func;

    protected JTO() {
        this.init();
    }

    private void init() {
        this.func = () -> {
            TypeToken tt = TypeToken.of(Wrapper.clazz());
            Map parsers = PARSERS.getOrDefault(tt, Map.of());
            Parser parser = (Parser)parsers.get(this.type);
            if (parser != null) {
                this.target = parser.func.apply(this.data);
                this.func = () -> this.target;
            } else {
                ModCommon.LOG.error(String.format("No JTO parser registered for type '%s'", this.type));
            }
            return this.target;
        };
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.type);
        oos.writeObject(this.data.toString());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.type = (String)ois.readObject();
        this.data = JsonParser.parseString((String)((String)ois.readObject())).getAsJsonObject();
        this.init();
    }

    public T get() {
        return this.func.get();
    }

    public static <T> void registerParser(String type, Function<JsonObject, T> func) {
        type = type.toLowerCase();
        TypeToken tt = TypeToken.of(Wrapper.clazz());
        Map parsers = PARSERS.computeIfAbsent(tt, key -> new HashMap());
        if (parsers.containsKey(type)) {
            throw new IllegalArgumentException("A parser for the type '" + type + "' is already registered");
        }
        parsers.put(type, new Parser<T>(func));
    }

    public static <Model, T> void registerParser(String type, Function<Model, T> converter, Supplier<Model> defaultModel, Class<Model> clazz) {
        type = type.toLowerCase();
        JTO.registerParser(type, jso -> {
            Object model = jso != null ? GSON.fromJson((JsonElement)jso, clazz) : defaultModel.get();
            return converter.apply(model);
        });
    }

    public static <T> JTO<T> of(Supplier<T> supplier) {
        JTO<T> jto = new JTO<T>();
        jto.func = supplier;
        return jto;
    }

    private static class Wrapper<T> {
        private Wrapper() {
        }

        static <T> Class<?> clazz() {
            Wrapper<T> dummy = new Wrapper<T>();
            return dummy.getClass();
        }
    }

    private static class Parser<T> {
        public final Function<JsonObject, T> func;

        Parser(Function<JsonObject, T> func) {
            this.func = func;
        }
    }
}

