/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.mixins;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BattleActor.class})
public class BattleActorMixin {
    @Inject(method={"turn"}, at={@At(value="HEAD")}, remap=false)
    private void injectTurn(CallbackInfo ci) {
        BattleActor self = (BattleActor)this;
        BattleState battleState = RCTApi.getInstances().map(e -> ((RCTApi)e.getValue()).getBattleManager().getState(self.battle.getBattleId())).filter(bs -> bs != null).findFirst().orElse(null);
        if (battleState != null) {
            BattleStates.BattleState bs2 = BattleStates.get(battleState.getBattle());
            bs2.getActorState(self).nextTurn();
            self.getActivePokemon().stream().filter(ActiveBattlePokemon::hasPokemon).forEach(pkmn -> bs2.getPokemonState(pkmn.getBattlePokemon()).nextTurn());
        }
    }

    @Inject(method={"canFitForcedAction"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void injectCanFitForcedAction(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            int maxItems;
            BattleActor self = (BattleActor)this;
            BattleState battleState = RCTApi.getInstances().map(e -> ((RCTApi)e.getValue()).getBattleManager().getState(self.battle.getBattleId())).filter(bs -> bs != null).findFirst().orElse(null);
            if (battleState != null && (maxItems = battleState.getRules().getMaxItemUses()) >= 0) {
                BattleState.ActorState actorState = battleState.getState(self.getUuid());
                cir.setReturnValue((Object)(actorState.getItemsUsed() < maxItems ? 1 : 0));
            }
        }
    }
}

