/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.gdarp.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.dark_roleplay.gdarp.CommonClass;

public class PackConfig {
    private static boolean hasLoadedConfig = false;
    private static Optional<List<String>> REQUIRED_DATAPACKS;
    private static Optional<List<String>> OPTIONAL_DATAPACKS;
    private static Optional<List<String>> REQUIRED_RESOURCEPACKS;
    private static Optional<List<String>> OPTIONAL_RESOURCEPACKS;
    private static Optional<Boolean> ENABLE_SYSTEM_GLOBAL;
    private static Path SYSTEM_GLOBAL_PATH;

    public static boolean isSystemGlobalPath(Path other) {
        return SYSTEM_GLOBAL_PATH != null && other.startsWith(SYSTEM_GLOBAL_PATH);
    }

    public static void loadConfigs() {
        if (hasLoadedConfig) {
            return;
        }
        if (Files.notExists(CommonClass.getGameDir().resolve("config").resolve("global_data_and_resourcepacks.toml"), new LinkOption[0])) {
            try {
                Files.createDirectories(new File(CommonClass.getGameDir().toFile(), "/config/").toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Path forgeDefaultCfgPath = CommonClass.getGameDir().resolve("defaultconfigs").resolve("global_data_and_resourcepacks.toml");
            if (Files.exists(forgeDefaultCfgPath, new LinkOption[0])) {
                try {
                    Files.copy(forgeDefaultCfgPath, CommonClass.getGameDir().resolve("config/global_data_and_resourcepacks.toml"), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(CommonClass.getGameDir().toFile(), "/config/global_data_and_resourcepacks.toml")).defaultData(PackConfig.class.getClassLoader().getResource("default_config.toml")).build();
        config.load();
        ENABLE_SYSTEM_GLOBAL = config.getOptional("enable_system_global_packs");
        boolean enableSystemGlobal = ENABLE_SYSTEM_GLOBAL.orElse(false);
        REQUIRED_DATAPACKS = config.getOptional("datapacks.required");
        OPTIONAL_DATAPACKS = config.getOptional("datapacks.optional");
        REQUIRED_RESOURCEPACKS = config.getOptional("resourcepacks.required");
        if (enableSystemGlobal) {
            String userHome = System.getProperty("user.home");
            SYSTEM_GLOBAL_PATH = Path.of(userHome, ".minecraft_global_packs");
            REQUIRED_DATAPACKS.ifPresent(packs -> packs.add(SYSTEM_GLOBAL_PATH.resolve("required_datapacks").toFile().getPath()));
            OPTIONAL_DATAPACKS.ifPresent(packs -> packs.add(SYSTEM_GLOBAL_PATH.resolve("optional_datapacks").toFile().getPath()));
            REQUIRED_RESOURCEPACKS.ifPresent(packs -> packs.add(SYSTEM_GLOBAL_PATH.resolve("required_resourcepacks").toFile().getPath()));
            OPTIONAL_RESOURCEPACKS = Optional.of(Arrays.asList(SYSTEM_GLOBAL_PATH.resolve("optional_resourcepacks").toFile().getPath()));
        } else {
            OPTIONAL_RESOURCEPACKS = Optional.empty();
        }
        config.close();
        hasLoadedConfig = true;
    }

    public static void createFolders() {
        PackConfig.loadConfigs();
        if (ENABLE_SYSTEM_GLOBAL.orElse(false).booleanValue()) {
            String userHome = System.getProperty("user.home");
            try {
                Files.createDirectories(Paths.get(userHome, ".minecraft_global_packs", "1.21", "required_datapacks"), new FileAttribute[0]);
                Files.createDirectories(Paths.get(userHome, ".minecraft_global_packs", "1.21", "optional_datapacks"), new FileAttribute[0]);
                Files.createDirectories(Paths.get(userHome, ".minecraft_global_packs", "1.21", "required_resourcepacks"), new FileAttribute[0]);
                Files.createDirectories(Paths.get(userHome, ".minecraft_global_packs", "1.21", "optional_resourcepacks"), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < 4; ++i) {
            Optional<List<String>> folders = switch (i) {
                case 0 -> PackConfig.getRequiredDatapacks();
                case 1 -> PackConfig.getOptionalDatapacks();
                case 2 -> PackConfig.getRequiredResourcePacks();
                case 3 -> PackConfig.getOptionalResourcePacks();
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
            folders.ifPresent(files -> files.stream().map(str -> Path.of(str, new String[0])).map(str -> PackConfig.isSystemGlobalPath(str) ? str : CommonClass.GAME_DIR.resolve((Path)str)).forEach(path -> {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
        }
    }

    public static Optional<List<String>> getRequiredDatapacks() {
        PackConfig.loadConfigs();
        return REQUIRED_DATAPACKS;
    }

    public static Optional<List<String>> getOptionalDatapacks() {
        PackConfig.loadConfigs();
        return OPTIONAL_DATAPACKS;
    }

    public static Optional<List<String>> getRequiredResourcePacks() {
        PackConfig.loadConfigs();
        return REQUIRED_RESOURCEPACKS;
    }

    public static Optional<List<String>> getOptionalResourcePacks() {
        PackConfig.loadConfigs();
        return OPTIONAL_RESOURCEPACKS;
    }
}

