/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class EnumArgumentType<T extends Enum<T>>
implements ArgumentType<Enum<T>> {
    private final DynamicCommandExceptionType noValueException;
    private final String noElementMessage;
    private final Class<T> enumClass;

    private EnumArgumentType(Class<T> enumClass, String noElementMessage) {
        this.enumClass = enumClass;
        this.noElementMessage = noElementMessage;
        this.noValueException = new DynamicCommandExceptionType(o -> class_2561.method_43470((String)this.noElementMessage.replace("{}", o.toString())));
    }

    public static <T extends Enum<T>> EnumArgumentType<T> create(Class<T> enumClass) {
        EnumArgumentType type = new EnumArgumentType(enumClass, "Invalid enum value '{}'");
        ArgumentTypeRegistry.registerArgumentType((class_2960)class_2960.method_60655((String)"owo", (String)("enum_" + enumClass.getName().toLowerCase(Locale.ROOT))), type.getClass(), (class_2314)class_2319.method_41999(() -> type));
        return type;
    }

    public static <T extends Enum<T>> EnumArgumentType<T> create(Class<T> enumClass, String noElementMessage) {
        EnumArgumentType type = new EnumArgumentType(enumClass, noElementMessage);
        ArgumentTypeRegistry.registerArgumentType((class_2960)class_2960.method_60655((String)"owo", (String)("enum_" + enumClass.getName().toLowerCase(Locale.ROOT))), type.getClass(), (class_2314)class_2319.method_41999(() -> type));
        return type;
    }

    public T get(CommandContext<?> context, String name) {
        return (T)((Enum)context.getArgument(name, this.enumClass));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::toString), (SuggestionsBuilder)builder);
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException e) {
            throw this.noValueException.create((Object)name);
        }
    }
}

