/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import dev.architectury.registry.registries.RegistrySupplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.PokemonEgg;
import ludichat.cobbreeding.components.CobbreedingComponents;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3532;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lludichat/cobbreeding/EggUtilities;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/FormData;", "pokemon", "Lnet/minecraft/class_1799;", "selectEggItem", "(Lcom/cobblemon/mod/common/pokemon/FormData;)Lnet/minecraft/class_1799;", "Lcom/cobblemon/mod/common/pokemon/Species;", "", "calculateTimer", "(Lcom/cobblemon/mod/common/pokemon/Species;)I", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "properties", "timer", "getEggFromPokemonProperties", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Ljava/lang/Integer;)Lnet/minecraft/class_1799;", "itemStack", "", "isEgg", "(Lnet/minecraft/class_1799;)Z", "a", "b", "areSameEgg", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1799;)Z", "common"})
public final class EggUtilities {
    @NotNull
    public static final EggUtilities INSTANCE = new EggUtilities();

    private EggUtilities() {
    }

    @JvmStatic
    @NotNull
    public static final class_1799 selectEggItem(@NotNull FormData pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (Intrinsics.areEqual((Object)pokemon.getSpecies().showdownId(), (Object)"manaphy")) {
            RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get("manaphy_egg");
            Intrinsics.checkNotNull(registrySupplier);
            return new class_1799((class_1935)registrySupplier.get());
        }
        ElementalType type1 = pokemon.getPrimaryType();
        ElementalType type2 = pokemon.getSecondaryType();
        if (type2 != null && !Intrinsics.areEqual((Object)type1, (Object)type2)) {
            RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get(type1.getName() + "_" + type2.getName() + "_pokemon_egg");
            Intrinsics.checkNotNull(registrySupplier);
            return new class_1799((class_1935)registrySupplier.get());
        }
        RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get(type1.getName() + "_pokemon_egg");
        Intrinsics.checkNotNull(registrySupplier);
        return new class_1799((class_1935)registrySupplier.get());
    }

    @JvmStatic
    public static final int calculateTimer(@NotNull Species pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return class_3532.method_15375((float)((float)(pokemon.getEggCycles() * 600) * Cobbreeding.INSTANCE.getConfig().getEggHatchMultiplier()));
    }

    @JvmStatic
    @Nullable
    public static final class_1799 getEggFromPokemonProperties(@NotNull PokemonProperties properties, @Nullable Integer timer) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        String string = properties.getSpecies();
        Intrinsics.checkNotNull((Object)string);
        Species species = PokemonSpecies.INSTANCE.getByName(string);
        if (species != null) {
            FormData form = species.getStandardForm();
            if (properties.getForm() != null) {
                String string2 = properties.getForm();
                Intrinsics.checkNotNull((Object)string2);
                form = species.getFormByShowdownId(string2);
            }
            class_1799 eggItem = null;
            if (Cobbreeding.INSTANCE.getConfig().getCustomColors()) {
                eggItem = EggUtilities.selectEggItem(form);
            } else {
                RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get("pokemon_egg");
                Intrinsics.checkNotNull(registrySupplier);
                eggItem = new class_1799((class_1935)registrySupplier.get());
            }
            eggItem.method_57379((class_9331)CobbreedingComponents.EGG_INFO.get(), (Object)PokemonProperties.asString$default((PokemonProperties)properties, null, (int)1, null));
            Integer n = timer == null ? (Integer)eggItem.method_57379((class_9331)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(species)) : (Integer)eggItem.method_57379((class_9331)CobbreedingComponents.TIMER.get(), (Object)timer);
            return eggItem;
        }
        return null;
    }

    public static /* synthetic */ class_1799 getEggFromPokemonProperties$default(PokemonProperties pokemonProperties, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return EggUtilities.getEggFromPokemonProperties(pokemonProperties, n);
    }

    private final boolean isEgg(class_1799 itemStack) {
        return itemStack.method_7909() instanceof PokemonEgg;
    }

    @JvmStatic
    public static final boolean areSameEgg(@NotNull class_1799 a, @NotNull class_1799 b) {
        Object comp_b;
        Object comp_a;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return INSTANCE.isEgg(a) && INSTANCE.isEgg(b) && (comp_a = a.method_57825((class_9331)CobbreedingComponents.POKEMON_PROPERTIES.get(), (Object)0)).equals(comp_b = b.method_57825((class_9331)CobbreedingComponents.POKEMON_PROPERTIES.get(), (Object)0));
    }
}

