```json
{
  "title": "Creaking Heart",
  "icon": "minecraft:creaking_heart",
  "categories": [
    "minecraft:blocks",
    "minecraft:group/spawn_eggs"
  ],
  "associated_items": [
    "minecraft:creaking_heart"
  ]
}
```

&spotlight(minecraft:creaking_heart)
A **creaking heart** is a living block that can be [crafted](^minecraft:crafting) or found inside trees in [pale gardens](^minecraft:pale_garden).

;;;;;

![Creaking Heart](minecraft:textures/gui/image/creaking_heart.png,fit)

A disabled creaking heart (left) and a active creaking heart (right).

;;;;;

&title(Crafting)
<recipe;minecraft:creaking_heart>

;;;;;

&title(Breaking)
Creaking hearts drop as an item only when [mined](^minecraft:breaking) by a [tool](^minecraft:tool) enchanted with Silk Touch. Otherwise, they drop 1-3 resin clumps; Fortune can increase the maximum drops by 1 per level (up to 6 with Fortune 3).

;;;;;

&title(Natural Generation)
Creaking hearts occasionally generate inside the top trunks of [pale oak trees](^minecraft:pale_oak_tree) in the [pale garden](^minecraft:pale_garden). Pale oaks grown from their [saplings](^minecraft:pale_oak_sapling) do not generate with hearts. 

;;;;;

&title(Usage)
Creaking hearts activates if placed between two [pale oak logs](^minecraft:pale_oak_log); then, during nighttime or [thunderstorms](^minecraft:thunderstorm), it spawns a [creaking](^minecraft:creaking) and protects it from all damage. [Breaking](^minecraft:breaking) a creaking heart that is protecting a creaking instantly kills it. Hitting a protected creaking causes [resin clumps](^minecraft:resin_clump) to grow near its linked creaking heart.

;;;;;

&title(Activation)
It has two states: disabled and active. Disabled is its default state, but if it is placed between two aligned [pale oak logs](^minecraft:pale_oak_log) and/or [its variants](^minecraft:tag/pale_oak_logs), the creaking heart becomes active, which is signified by it changing to its orange illuminated-looking texture. Removing one of these blocks reverts the heart to disabled if it hasn't already spawned a [creaking](^minecraft:creaking).

;;;;;

&title(Resin Clumps)
Creaking hearts generate [resin clumps](^minecraft:resin_clump) on nearby pale oak logs when its linked [creaking](^minecraft:creaking) is attacked by a player. There is a brief cooldown between each resin clump generation.

;;;;;

&title(Redstone Component)
A redstone comparator connected to a creaking heart outputs a signal if the heart has a linked [creaking](^minecraft:creaking). The strength of the signal depends on the [Euclidean distance](https://minecraft.wiki/w/Euclidean_distance) between the heart and its creaking.


Pistons of any kind cannot move creaking hearts.

;;;;;

&title(Ambient Sounds)
A creaking heart emits subtle eerie sounds when it is active and surrounded by any types of [logs](^minecraft:log_blocks), [stripped logs](^minecraft:stripped_log_blocks), [wood](^minecraft:wood_blocks), or [stripped wood](^minecraft:stripped_wood_blocks) on all 6 directions.
