--Extreme items
require("prototypes.items.extreme-belt")
require("prototypes.items.extreme-splitter")
require("prototypes.items.extreme-underground")

--Ultimate items
require("prototypes.items.ultimate-belt")
require("prototypes.items.ultimate-splitter")
require("prototypes.items.ultimate-underground")

--Superfast items
require("prototypes.items.high-speed-belt")
require("prototypes.items.high-speed-splitter")
require("prototypes.items.high-speed-underground")

--Recipes
require("prototypes.recipes.belts-recipes")
require("prototypes.recipes.splitters-recipes")
require("prototypes.recipes.undergrounds-recipes")

--Technology
require("prototypes.technology.extreme-tech")
require("prototypes.technology.ultimate-tech")
require("prototypes.technology.high-speed-tech")

--Variables
local tint = 
{
	["extreme"] = {r = 179, g = 247, b = 91, a = 255}, 
	["ultimate"] = {r = 255, g = 167, b = 75, a = 255}, 
	["high-speed"] = {r = 217, g = 142, b = 181, a = 255}
}

--If only LoaderRedux installed
if not mods["vanilla-loaders-hd"] and mods["LoaderRedux"] then

	local loader_redux = require("__LoaderRedux__.make_loader")
	data:extend({
	
		--Create loader items 
		loader_redux.make_loader_item("extreme-loader", "belt", "d-d", tint["extreme"]),
		loader_redux.make_loader_item("ultimate-loader", "belt", "d-e", tint["ultimate"]),
		loader_redux.make_loader_item("high-speed-loader", "belt", "d-f", tint["high-speed"]),
	
		--Create loader entity
		loader_redux.make_loader_entity("extreme-loader", data.raw["transport-belt"]["extreme-belt"], tint["extreme"], "ultimate-loader"),
		loader_redux.make_loader_entity("ultimate-loader", data.raw["transport-belt"]["ultimate-belt"], tint["ultimate"], "high-speed-loader"),
		loader_redux.make_loader_entity("high-speed-loader", data.raw["transport-belt"]["high-speed-belt"], tint["high-speed"], nil),
	})
	
	--Tech
	table.insert(data.raw.technology["extreme-logistics"].effects, 
	{
		type = "unlock-recipe",
		recipe = "extreme-loader"
	})
	
	table.insert(data.raw.technology["ultimate-logistics"].effects, 
	{
		type = "unlock-recipe",
		recipe = "ultimate-loader"
	})
	
	table.insert(data.raw.technology["high-speed-logistics"].effects, 
	{
		type = "unlock-recipe",
		recipe = "high-speed-loader"
	})
	
	require("prototypes.recipes.loaders-recipes")
end

--If vanila-loader-hd installed
if mods["vanilla-loaders-hd"] then

	--Create loaders
	vanillaHD.addLoader("extreme-loader", tint["extreme"], "extreme-belt", "extreme-logistics", "express-loader", "ultimate-loader")
	vanillaHD.addLoader("ultimate-loader", tint["ultimate"], "ultimate-belt", "ultimate-logistics", "extreme-loader", "high-speed-loader")
	vanillaHD.addLoader("high-speed-loader", tint["high-speed"], "high-speed-belt", "high-speed-logistics", "ultimate-loader", nil)
	
	--Set categories
	data.raw.recipe["extreme-loader"].category = "crafting-with-fluid"
	data.raw.recipe["ultimate-loader"].category = "crafting-with-fluid"
	data.raw.recipe["high-speed-loader"].category = "crafting-with-fluid"

	--Set recipes
	data.raw.recipe["extreme-loader"].ingredients =
	{
		{"express-loader", 1}, {"extreme-belt", 5}, 
		{"advanced-circuit", 10}, {"iron-gear-wheel", 40},
		{type="fluid", name="lubricant", amount=50},
	}
	data.raw.recipe["ultimate-loader"].ingredients =
	{
		{"extreme-loader", 1}, {"ultimate-belt", 5},
		{"processing-unit", 1}, {"iron-gear-wheel", 50},
		{type="fluid", name="lubricant", amount=60},
	}
	data.raw.recipe["high-speed-loader"].ingredients =
	{
		{"ultimate-loader", 1}, {"high-speed-belt", 5},
		{"processing-unit", 1}, {"low-density-structure", 1},
		{"iron-gear-wheel", 60}, 
		{type="fluid", name="lubricant", amount=70},
	}
	
	require("prototypes.recipes.loaders-recipes")
	
end