data:extend(
{
	{
		--Create item
		type = "item",
		name = "extreme-belt",
		icon = "__AdvancedBelts__/graphics/icons/extreme-items/extreme-belt.png",
		icon_size = 64,
		subgroup = "belt",
		order = "a[transport-belt]-d[extreme-belt]",
		place_result = "extreme-belt",
		stack_size = 100
	},
	{
		--Item description
		type = "transport-belt",
		name = "extreme-belt",
		icon = "__AdvancedBelts__/graphics/icons/extreme-items/extreme-belt.png",
		icon_size = 64,
		flags = {"placeable-neutral", "player-creation"},
		minable = {mining_time = 0.1, result = "extreme-belt"},
		corpse = "medium-remnants",
		
		--Resistances settings
		resistances =
		{
			{
				type = "fire",
				percent = 50
			}
		},
		
		--Main belt settings
		collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		animation_speed_coefficient = 32,
		next_upgrade = "ultimate-belt",
		fast_replaceable_group = "transport-belt",
		related_underground_belt = "extreme-underground",
		max_health = 180,
		speed = 0.125,
		
		--Set belt sound
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/express-transport-belt.ogg",
				volume = 0.2
			},
			persistent = true,
			use_doppler_shift = false
		},
		
		--Set belt animation
		belt_animation_set = 
		{
			animation_set = 
			{
				filename = "__AdvancedBelts__/graphics/entity/extreme-belt/extreme-belt.png",
				priority = "extra-high",
				width = 128,
				height = 128,
				scale = 0.5,
				frame_count = 32,
				direction_count = 20
			},
		},
		connector_frame_sprites = transport_belt_connector_frame_sprites
	}
})
