data:extend(
{
	{
		--Create item
		type = "item",
		name = "extreme-splitter",
		icon = "__AdvancedBelts__/graphics/icons/extreme-items/extreme-splitter.png",
		icon_size = 64,
		subgroup = "belt",
		order = "c[splitter]-d[extreme-splitter]",
		place_result = "extreme-splitter",
		stack_size = 50
	},
	{
		--Item description
		type = "splitter",
		name = "extreme-splitter",
		icon = "__AdvancedBelts__/graphics/icons/extreme-items/extreme-splitter.png",
		icon_size = 64,
		flags = {"placeable-neutral", "player-creation"},
		minable = {mining_time = 0.1, result = "extreme-splitter"},
		corpse = "medium-remnants",
		
		--Resistances settings
		resistances =
		{
			{
				type = "fire",
				percent = 60
			}
		},
		
		--Main belt settings
		collision_box = {{-0.9, -0.4}, {0.9, 0.4}},
		selection_box = {{-0.9, -0.5}, {0.9, 0.5}},
		animation_speed_coefficient = 32,
		next_upgrade = "ultimate-splitter",
		fast_replaceable_group = "transport-belt",
		structure_animation_speed_coefficient = 1.3,
		structure_animation_movement_cooldown = 10,
		belt_animation_set = data.raw["transport-belt"]["extreme-belt"].belt_animation_set,
		max_health = 200,
		speed = 0.125,
		
		--Set splitter structure
		structure =
		{
			north = {
						filename = "__AdvancedBelts__/graphics/entity/extreme-splitter/extreme-splitter-north.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 160,
						height = 70,
						shift = {0.25, 0.046875},
						scale = 0.5
					},
			east =	{
						filename = "__AdvancedBelts__/graphics/entity/extreme-splitter/extreme-splitter-east.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 84,
						shift = util.by_pixel(4, 13),
						scale = 0.5
					},
			south =	{
						filename = "__AdvancedBelts__/graphics/entity/extreme-splitter/extreme-splitter-south.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 164,
						height = 64,
						shift = util.by_pixel(4, 0),
						scale = 0.5
				},
			west =	{
						filename = "__AdvancedBelts__/graphics/entity/extreme-splitter/extreme-splitter-west.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 86,
						shift = util.by_pixel(6, 12),
						scale = 0.5
					},
		},
		
		--Set splitter structure patch
		structure_patch =
		{
			north = util.empty_sprite(),
			east =
					{
						filename = "__AdvancedBelts__/graphics/entity/extreme-splitter/extreme-splitter-east-top_patch.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 104,
						shift = util.by_pixel(4, -20),
						scale = 0.5
					},
			south = util.empty_sprite(),
			west =
					{
						filename = "__AdvancedBelts__/graphics/entity/extreme-splitter/extreme-splitter-west-top_patch.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 96,
						shift = util.by_pixel(6, -18),
						scale = 0.5
					}
		},
		ending_patch = ending_patch_prototype
	},
})