data:extend(
{
	{
		--Create item
		type = "item",
		name = "high-speed-belt",
		icon = "__AdvancedBelts__/graphics/icons/high-speed-items/high-speed-belt.png",
		icon_size = 64,
		subgroup = "belt",
		order = "a[transport-belt]-f[high-speed-belt]",
		place_result = "high-speed-belt",
		stack_size = 100
	},
	{
		--Item description
		type = "transport-belt",
		name = "high-speed-belt",
		icon = "__AdvancedBelts__/graphics/icons/high-speed-items/high-speed-belt.png",
		icon_size = 64,
		flags = {"placeable-neutral", "player-creation"},
		minable = {mining_time = 0.1, result = "high-speed-belt"},
		corpse = "medium-remnants",
		
		--Resistances settings
		resistances =
		{
			{
				type = "fire",
				percent = 50
			}
		},
		
		--Main belt settings
		collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		animation_speed_coefficient = 32,
		next_upgrade = nil,
		fast_replaceable_group = "transport-belt",
		related_underground_belt = "high-speed-underground",
		max_health = 200,
		speed = 0.1875,
		
		--Set belt sound
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/express-transport-belt.ogg",
				volume = 0.2
			},
			persistent = true,
			use_doppler_shift = false
		},
		
		--Set belt animation
		belt_animation_set = 
		{
			animation_set = 
			{
				filename = "__AdvancedBelts__/graphics/entity/high-speed-belt/high-speed-belt.png",
				priority = "extra-high",
				width = 128,
				height = 128,
				scale = 0.5,
				frame_count = 32,
				direction_count = 20
			},
		},
		connector_frame_sprites = transport_belt_connector_frame_sprites
	}
})

