data:extend(
{
	{
		--Create item
		type = "item",
		name = "high-speed-splitter",
		icon = "__AdvancedBelts__/graphics/icons/high-speed-items/high-speed-splitter.png",
		icon_size = 64,
		subgroup = "belt",
		order = "c[splitter]-f[high-speed-splitter]",
		place_result = "high-speed-splitter",
		stack_size = 50
	},
	{
		--Item description
		type = "splitter",
		name = "high-speed-splitter",
		icon = "__AdvancedBelts__/graphics/icons/high-speed-items/high-speed-splitter.png",
		icon_size = 64,
		flags = {"placeable-neutral", "player-creation"},
		minable = {mining_time = 0.1, result = "high-speed-splitter"},
		corpse = "medium-remnants",
		
		--Resistances settings
		resistances =
		{
			{
				type = "fire",
				percent = 60
			}
		},
		
		--Main belt settings
		collision_box = {{-0.9, -0.4}, {0.9, 0.4}},
		selection_box = {{-0.9, -0.5}, {0.9, 0.5}},
		animation_speed_coefficient = 32,
		next_upgrade = nil,
		fast_replaceable_group = "transport-belt",
		structure_animation_speed_coefficient = 1.5,
		structure_animation_movement_cooldown = 10,
		belt_animation_set = data.raw["transport-belt"]["high-speed-belt"].belt_animation_set,
		max_health = 220,
		speed = 0.1875,
		
		--Set splitter structure
		structure =
		{
			north = {
						filename = "__AdvancedBelts__/graphics/entity/high-speed-splitter/high-speed-splitter-north.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 160,
						height = 70,
						shift = {0.25, 0.046875},
						scale = 0.5
					},
			east =	{
						filename = "__AdvancedBelts__/graphics/entity/high-speed-splitter/high-speed-splitter-east.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 84,
						shift = util.by_pixel(4, 13),
						scale = 0.5
					},
			south =	{
						filename = "__AdvancedBelts__/graphics/entity/high-speed-splitter/high-speed-splitter-south.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 164,
						height = 64,
						shift = util.by_pixel(4, 0),
						scale = 0.5
				},
			west =	{
						filename = "__AdvancedBelts__/graphics/entity/high-speed-splitter/high-speed-splitter-west.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 86,
						shift = util.by_pixel(6, 12),
						scale = 0.5
					},
		},
		
		--Set splitter structure patch
		structure_patch =
		{
			north = util.empty_sprite(),
			east =
					{
						filename = "__AdvancedBelts__/graphics/entity/high-speed-splitter/high-speed-splitter-east-top_patch.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 104,
						shift = util.by_pixel(4, -20),
						scale = 0.5
					},
			south = util.empty_sprite(),
			west =
					{
						filename = "__AdvancedBelts__/graphics/entity/high-speed-splitter/high-speed-splitter-west-top_patch.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 96,
						shift = util.by_pixel(6, -18),
						scale = 0.5
					}
		},
		ending_patch = ending_patch_prototype
	},
})