data:extend(
{
	{
		--Create item
		type = "item",
		name = "high-speed-underground",
		icon = "__AdvancedBelts__/graphics/icons/high-speed-items/high-speed-underground.png",
		icon_size = 64,
		subgroup = "belt",
		order = "b[underground-belt]-f[high-speed-underground]",
		place_result = "high-speed-underground",
		stack_size = 50
	},
	{
		--Item description
		type = "underground-belt",
		name = "high-speed-underground",
		icon = "__AdvancedBelts__/graphics/icons/high-speed-items/high-speed-underground.png",
		icon_size = 64,
		flags = {"placeable-neutral", "player-creation"},
		minable = {mining_time = 0.1, result = "high-speed-underground"},
		corpse = "small-remnants",
		
		--Resistances settings
		resistances =
		{
			{
				type = "fire",
				percent = 60
			},
			{
				type = "impact",
				percent = 30
			}
		},
		
		--Main underground settings
		collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		animation_speed_coefficient = 32,
		next_upgrade = nil,
		belt_animation_set = data.raw["transport-belt"]["high-speed-belt"].belt_animation_set,
		fast_replaceable_group = "transport-belt",
		max_distance = 15,
		speed = 0.1875,
		max_health = 200,
		
		--Set underground sound
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/express-underground-belt.ogg",
				volume = 0.2
			},
			max_sounds_per_type = 2,
			audible_distance_modifier = 0.5,
			persistent = true,
			use_doppler_shift = false
		},
		
		--Set underground lines
		underground_sprite =
		{
			filename = "__core__/graphics/arrows/underground-lines.png",
			priority = "high",
			width = 64,
			height = 64,
			x = 64,
			scale = 0.5
		},
		underground_remove_belts_sprite =
		{
			filename = "__core__/graphics/arrows/underground-lines-remove.png",
			priority = "high",
			width = 64,
			height = 64,
			x = 64,
			scale = 0.5
		},
		
		--Set underground structure
		structure =
		{
			direction_in = 
			{
				sheet = 
				{
					filename = "__AdvancedBelts__/graphics/entity/high-speed-underground/high-speed-underground.png",
					priority = "extra-high",
					width = 192,
					height = 192,
					y = 192,
					scale = 0.5
				}
			},
			direction_out =
			{
				sheet =
				{
					filename = "__AdvancedBelts__/graphics/entity/high-speed-underground/high-speed-underground.png",
					priority = "extra-high",
					width = 192,
					height = 192,
					scale = 0.5
				}
			},
			direction_in_side_loading =
			{
				sheet =
				{
					filename = "__AdvancedBelts__/graphics/entity/high-speed-underground/high-speed-underground.png",
					priority = "extra-high",
					width = 192,
					height = 192,
					y = 192*3,
					scale = 0.5
				}
			},
			direction_out_side_loading =
			{
				sheet =
				{
					filename = "__AdvancedBelts__/graphics/entity/high-speed-underground/high-speed-underground.png",
					priority = "extra-high",
					width = 192,
					height = 192,
					y= 192*2,
					scale = 0.5
				
				}
			},
			back_patch =
			{
				sheet =
				{
					filename = "__AdvancedBelts__/graphics/entity/high-speed-underground/high-speed-underground-structure-back-patch.png",
					priority = "extra-high",
					width = 192,
					height = 192,
					scale = 0.5				
				}
			},
			front_patch =
			{
				sheet =
				{
					filename = "__AdvancedBelts__/graphics/entity/high-speed-underground/high-speed-underground-structure-front-patch.png",
					priority = "extra-high",
					width = 192,
					height = 192,
					scale = 0.5
				}
			}
		},
		
	ending_patch = ending_patch_prototype
	},
})