data:extend(
{
	{
		--Create item
		type = "item",
		name = "ultimate-belt",
		icon = "__AdvancedBelts__/graphics/icons/ultimate-items/ultimate-belt.png",
		icon_size = 64,
		subgroup = "belt",
		order = "a[transport-belt]-e[ultimate-belt]",
		place_result = "ultimate-belt",
		stack_size = 100
	},
	{
		--Item description
		type = "transport-belt",
		name = "ultimate-belt",
		icon = "__AdvancedBelts__/graphics/icons/ultimate-items/ultimate-belt.png",
		icon_size = 64,
		flags = {"placeable-neutral", "player-creation"},
		minable = {mining_time = 0.1, result = "ultimate-belt"},
		corpse = "medium-remnants",
		
		--Resistances settings
		resistances =
		{
			{
				type = "fire",
				percent = 50
			}
		},
		
		--Main belt settings
		collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		animation_speed_coefficient = 32,
		next_upgrade = "high-speed-belt",
		fast_replaceable_group = "transport-belt",
		related_underground_belt = "ultimate-underground",
		max_health = 190,
		speed = 0.15625,
		
		--Set belt sound
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/express-transport-belt.ogg",
				volume = 0.2
			},
			persistent = true,
			use_doppler_shift = false
		},
		
		--Set belt animation
		belt_animation_set = 
		{
			animation_set = 
			{
				filename = "__AdvancedBelts__/graphics/entity/ultimate-belt/ultimate-belt.png",
				priority = "extra-high",
				width = 128,
				height = 128,
				scale = 0.5,
				frame_count = 32,
				direction_count = 20
			},
		},
		connector_frame_sprites = transport_belt_connector_frame_sprites
	}
})
