data:extend(
{
	{
		--Create item
		type = "item",
		name = "ultimate-splitter",
		icon = "__AdvancedBelts__/graphics/icons/ultimate-items/ultimate-splitter.png",
		icon_size = 64,
		subgroup = "belt",
		order = "c[splitter]-e[ultimate-splitter]",
		place_result = "ultimate-splitter",
		stack_size = 50
	},
	{
		--Item description
		type = "splitter",
		name = "ultimate-splitter",
		icon = "__AdvancedBelts__/graphics/icons/ultimate-items/ultimate-splitter.png",
		icon_size = 64,
		flags = {"placeable-neutral", "player-creation"},
		minable = {mining_time = 0.1, result = "ultimate-splitter"},
		corpse = "medium-remnants",
		
		--Resistances settings
		resistances =
		{
			{
				type = "fire",
				percent = 60
			}
		},
		
		--Main belt settings
		collision_box = {{-0.9, -0.4}, {0.9, 0.4}},
		selection_box = {{-0.9, -0.5}, {0.9, 0.5}},
		animation_speed_coefficient = 32,
		next_upgrade = "high-speed-splitter",
		fast_replaceable_group = "transport-belt",
		structure_animation_speed_coefficient = 1.4,
		structure_animation_movement_cooldown = 10,
		belt_animation_set = data.raw["transport-belt"]["ultimate-belt"].belt_animation_set,
		max_health = 210,
		speed = 0.15625,
		
		--Set splitter structure
		structure =
		{
			north = {
						filename = "__AdvancedBelts__/graphics/entity/ultimate-splitter/ultimate-splitter-north.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 160,
						height = 70,
						shift = {0.25, 0.046875},
						scale = 0.5
					},
			east =	{
						filename = "__AdvancedBelts__/graphics/entity/ultimate-splitter/ultimate-splitter-east.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 84,
						shift = util.by_pixel(4, 13),
						scale = 0.5
					},
			south =	{
						filename = "__AdvancedBelts__/graphics/entity/ultimate-splitter/ultimate-splitter-south.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 164,
						height = 64,
						shift = util.by_pixel(4, 0),
						scale = 0.5
				},
			west =	{
						filename = "__AdvancedBelts__/graphics/entity/ultimate-splitter/ultimate-splitter-west.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 86,
						shift = util.by_pixel(6, 12),
						scale = 0.5
					},
		},
		
		--Set splitter structure patch
		structure_patch =
		{
			north = util.empty_sprite(),
			east =
					{
						filename = "__AdvancedBelts__/graphics/entity/ultimate-splitter/ultimate-splitter-east-top_patch.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 104,
						shift = util.by_pixel(4, -20),
						scale = 0.5
					},
			south = util.empty_sprite(),
			west =
					{
						filename = "__AdvancedBelts__/graphics/entity/ultimate-splitter/ultimate-splitter-west-top_patch.png",
						frame_count = 32,
						line_length = 8,
						priority = "extra-high",
						width = 90,
						height = 96,
						shift = util.by_pixel(6, -18),
						scale = 0.5
					}
		},
		ending_patch = ending_patch_prototype
	},
})