SWEP.PrintName				= "Handlung"
SWEP.Purpose				= ""
SWEP.Instructions 			= "Linksklick zum Auswählen der Handlung oder Beenden der Derzeitigen.\nRechtsklick zum Beenden der Handlung."
SWEP.Spawnable				= true

SWEP.Slot					= 0
SWEP.SlotPos				= 100
SWEP.DrawAmmo				= false
SWEP.DrawCrosshair			= false

SWEP.DefaultHoldType		= "normal"

SWEP.ViewModel 				= Model("models/weapons/c_arms.mdl")
SWEP.WorldModel 			= ""

SWEP.Primary.Automatic		= false
SWEP.Primary.ClipSize		= -1
SWEP.Primary.DefaultClip	= -1
SWEP.Primary.Automatic		= false
SWEP.Primary.Ammo			= "none"

SWEP.Secondary.Automatic	= false
SWEP.Secondary.ClipSize		= -1
SWEP.Secondary.DefaultClip	= -1
SWEP.Secondary.Automatic	= false
SWEP.Secondary.Ammo			= "none"

SWEP.Weight					= 1
SWEP.AutoSwitchTo			= false
SWEP.AutoSwitchFrom			= false

SWEP.deactivateOnMove		= 5

local Animations = {
	["cross_arms"] = "Arme verschränken",
	["cross_infront"] = "Arme kreuzen",
	["hello"] = "Zuwinken",
	["point"] = "Zeigen",
	["salute"] = "Salutieren",
	["surrender"] = "Ergeben"
}

AnimationSWEP = AnimationSWEP or {}
AnimationSWEP.GestureAngles = AnimationSWEP.GestureAngles or {}

AnimationSWEP.GestureAngles["cross_arms"] = {
	["ValveBiped.Bip01_R_UpperArm"] = Angle(3.809, 15.382, 2.654),
	["ValveBiped.Bip01_R_Forearm"] = Angle(-63.658, 1.8 , -84.928),
	["ValveBiped.Bip01_L_UpperArm"] = Angle(3.809, 15.382, 2.654),
	["ValveBiped.Bip01_L_Forearm"] = Angle(53.658, -29.718, 31.455),
	["ValveBiped.Bip01_R_Thigh"] = Angle(4.829, 0, 0),
	["ValveBiped.Bip01_L_Thigh"] = Angle(-8.89, 0, 0)
}

AnimationSWEP.GestureAngles["cross_infront"] = {
	["ValveBiped.Bip01_R_Forearm"] = Angle(-43.779933929443,-107.18412780762,15.918969154358),
	["ValveBiped.Bip01_R_UpperArm"] = Angle(20.256689071655, -57.223915100098, -6.1269416809082),
	["ValveBiped.Bip01_L_UpperArm"] = Angle(-28.913911819458, -59.408206939697, 1.0253102779388),
	["ValveBiped.Bip01_R_Thigh"] = Angle(4.7250719070435, -6.0294013023376, -0.46876749396324),
	["ValveBiped.Bip01_L_Thigh"] = Angle(-7.6583762168884, -0.21996378898621, 0.4060270190239),
	["ValveBiped.Bip01_L_Forearm"] = Angle(51.038677215576, -120.44165039063, -18.86986541748),
	["ValveBiped.Bip01_R_Hand"] = Angle(14.424224853516, -33.406204223633, -7.2624106407166),
	["ValveBiped.Bip01_L_Hand"] = Angle(25.959447860718, 31.564517974854, -14.979378700256)
}

AnimationSWEP.GestureAngles["hello"] = {
	["ValveBiped.Bip01_L_Forearm"] = Angle(25, -65, 25),
	["ValveBiped.Bip01_L_UpperArm"] = Angle(-70, -180, 70)
}

AnimationSWEP.GestureAngles["point"] = {
	["ValveBiped.Bip01_R_Finger2"] = Angle(4.151602268219, -52.963024139404, 0.42117667198181),
	["ValveBiped.Bip01_R_Finger21"] = Angle(0.00057629722869024, -58.618747711182, 0.001297949347645),
	["ValveBiped.Bip01_R_Finger3"] = Angle(4.151602268219, -52.963024139404, 0.42117667198181),
	["ValveBiped.Bip01_R_Finger31"] = Angle(0.00057629722869024, -58.618747711182, 0.001297949347645),
	["ValveBiped.Bip01_R_Finger4"] = Angle(4.151602268219, -52.963024139404, 0.42117667198181),
	["ValveBiped.Bip01_R_Finger41"] = Angle(0.00057629722869024, -58.618747711182, 0.001297949347645),
	["ValveBiped.Bip01_R_UpperArm"] = Angle(25.019514083862, -87.288040161133, -0.0012286090059206)
}

AnimationSWEP.GestureAngles["salute"] = {
	["ValveBiped.Bip01_R_UpperArm"] = Angle(80, -95, -77.5),
	["ValveBiped.Bip01_R_Forearm"] = Angle(35, -115, -5),
	["ValveBiped.Bip01_R_Hand"] = Angle(0, 0, 25)
}

AnimationSWEP.GestureAngles["surrender"] = {
	["ValveBiped.Bip01_L_Forearm"] = Angle(25, -65, 25),
	["ValveBiped.Bip01_R_Forearm"] = Angle(-25, -65, -25),
	["ValveBiped.Bip01_L_UpperArm"] = Angle(-70, -180, 70),
	["ValveBiped.Bip01_R_UpperArm"] = Angle(70, -180, -70)
}

AnimationSWEP.MovementDeactivate = AnimationSWEP.MovementDeactivate or {}

AnimationSWEP.MovementDeactivate["cross_arms"] = 80
AnimationSWEP.MovementDeactivate["cross_infront"] = 80
AnimationSWEP.MovementDeactivate["hello"] = 125
AnimationSWEP.MovementDeactivate["point"] = 80
AnimationSWEP.MovementDeactivate["salute"] = 80
AnimationSWEP.MovementDeactivate["surrender"] = 125

function SWEP:PreDrawViewModel()
	return true
end

function SWEP:Initialize()
	self:SetHoldType(self.DefaultHoldType)
end

if CLIENT then
	surface.CreateFont("AnimSWEP.Draw", {font = "Trebuchet MS", size = 22, weight = 1000, blursize = 0, scanlines = 0, antialias = true})

	local screenWidth = ScrW()
	local screenHeight = ScrH()

	local animation_time, animation_delay, gesture = 0, 0.75, ""
	local function DrawProgressBar(label, color, filled)
		filled = math.Clamp(filled, 0, 1)
		local w, h = 200, 20
		local centerx, centery = ScrW() / 2, 200
		local x, y = centerx - w / 2, centery - h / 2
		surface.SetDrawColor(Color(255, 255, 255, 200))
		surface.DrawOutlinedRect(x, y, w, h)
		surface.SetDrawColor(color)
		surface.DrawRect(x + 2, y + 2, (w - 4) * filled, h - 4)
		surface.SetDrawColor(color)
		surface.DrawRect(x + 2, y + 2, (w - 4) * filled, h - 4)
		draw.SimpleTextOutlined(label, "AnimSWEP.Draw", centerx, centery - 1, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
	end

	local function DrawHUD()
		local ply = LocalPlayer()
		local status = ply:GetMGVar("animationStatus", false)
		local name = Animations[ply:GetMGVar("animationClass", "")]
		if status and name then
			local progress = (CurTime() - ply:GetMGVar("animationStart", 0)) / animation_delay
			DrawProgressBar(name, Color(0, 175, 0, 150), progress)
		else
			hook.Remove("HUDPaint", "AnimationSWEP.Draw")
		end
	end

	hook.Add("mg_vars_update", "AnimationSWEP.Draw", function(ply, name, new, old)
		if name != "animationStatus" or new == false then return end
		hook.Add("HUDPaint", "AnimationSWEP.Draw", DrawHUD)
	end)

	local function LoadFont()
		screenWidth = ScrW()
		screenHeight = ScrH()
		surface.CreateFont("AnimSWEP.Base", {
			font = "Roboto",
			size = screenHeight * 0.0245,
			weight = 500,
		})
	end
	LoadFont()
	
	hook.Add("OnScreenSizeChanged", "AnimationSWEP.OnScreenSizeChanged", LoadFont)

	local MAT_Gesture = Material("edgehud/icon_gesture.png", "smooth")
	local edgeWidth = 2
	local function DrawEdges(x, y, width, height, edgeSize)
		surface.DrawRect(x, y, edgeSize, edgeWidth)
		surface.DrawRect(x, y + edgeWidth, edgeWidth,edgeSize - edgeWidth)
		local XRight = x + width
		surface.DrawRect(XRight - edgeSize, y, edgeSize, edgeWidth)
		surface.DrawRect(XRight - edgeWidth, y + edgeWidth, edgeWidth, edgeSize - edgeWidth)
		local YBottom = y + height
		surface.DrawRect(XRight - edgeSize, YBottom - edgeWidth, edgeSize, edgeWidth)
		surface.DrawRect(XRight - edgeWidth, YBottom - edgeSize, edgeWidth, edgeSize - edgeWidth)
		surface.DrawRect(x, YBottom - edgeWidth, edgeSize, edgeWidth)
		surface.DrawRect(x, YBottom - edgeSize, edgeWidth, edgeSize - edgeWidth)
	end

	local gestureFrame
	function SWEP:OpenFrame()
		if IsValid(gestureFrame) then return end
		hook.Add("HUDShouldDraw","EdgeHUD:RemoveCrosshair_GestureMenu",function(name)
			if name == "CHudCrosshair" then return false end
		end)
		local gesturePanels = {}
		gestureFrame = vgui.Create("DPanel")
		gestureFrame:SetSize(screenWidth, screenHeight)
		gestureFrame:Center()
		gestureFrame:MakePopup()
		gestureFrame:ParentToHUD()
		gestureFrame.Paint = function()
		end
		gestureFrame.OnRemove = function()
			hook.Remove("HUDShouldDraw","EdgeHUD:RemoveCrosshair_GestureMenu")
		end
		local closeCooldown = CurTime() + 0.2
		local allowClose = false
		gestureFrame.Think = function()
			if input.IsKeyDown(KEY_R) then
				if closeCooldown > CurTime() or !allowClose then return end
				gestureFrame:Remove()
			else
				allowClose = true
			end
		end
		for k, v in pairs(Animations) do
			local gestureButton = vgui.Create("DButton", gestureFrame)
			gestureButton:SetText(v)
			gestureButton.DoClick = function()
				RunConsoleCommand("animswep_play", k)
				gestureFrame:Remove()
			end
			table.insert(gesturePanels, gestureButton)
		end
		local radius = ScrH() * 0.35
		local seg = table.Count(gesturePanels)
		local circleData = {}
		for i = 1, seg do
			local a = math.rad((i / seg) * -360)
			table.insert(circleData, {x = screenWidth / 2 + math.sin(a) * radius, y = screenHeight / 2 + math.cos(a) * radius})
		end
		local buttonWidth = ScrH() * 0.18
		local buttonHeight = ScrH() * 0.075
		local iconSize = buttonHeight * 0.35
		local closeButtonGesture = vgui.Create("DButton", gestureFrame)
		closeButtonGesture:SetText("Schließen")
		closeButtonGesture:SetSize(ScrH() * 0.12, ScrH() * 0.04)
		closeButtonGesture:SetPos(ScrW() / 2 - closeButtonGesture:GetWide() / 2, ScrH() / 2 - closeButtonGesture:GetTall() / 2)
		closeButtonGesture.DoClick = function()
			gestureFrame:Remove()
		end
		table.insert(gesturePanels, closeButtonGesture)
		for k, v in pairs(gesturePanels) do
			v:SetFont("AnimSWEP.Base")
			v:SetTextColor(color_white)
			v.Paint = function(s, w, h)
				surface.SetDrawColor(s:IsHovered() and Color(80, 80, 80, 200) or Color(50, 50, 50, 200))
				surface.DrawRect(0, 0, w, h)
				surface.SetDrawColor(Color(255, 255, 255, 50))
				surface.DrawOutlinedRect(0, 0, w, h)
				surface.SetDrawColor(Color(255, 255, 255, 120))
				DrawEdges(0, 0, w, h, 8)
			end
			if circleData[k] then
				v:SetSize(buttonWidth,buttonHeight)
				v:SetPos(circleData[k].x - v:GetWide() / 2, circleData[k].y - v:GetTall() / 2)
				local oldPaint = v.Paint
				v.Paint = function(s, w, h)
					oldPaint(s, w, h)
					surface.SetDrawColor(color_white)
					surface.SetMaterial(MAT_Gesture)
					surface.DrawTexturedRect(w / 2 - iconSize / 2, h * 0.15, iconSize, iconSize)
					draw.SimpleText(v:GetValue(), "AnimSWEP.Base", w / 2, h * 0.85, color_white ,TEXT_ALIGN_CENTER, TEXT_ALIGN_BOTTOM)
					return true
				end
			end
		end
	end
end

function SWEP:PrimaryAttack()
	if !IsValid(self.Owner) then return end
	self:SetNextPrimaryFire(CurTime() + 0.2)
	if !self.Owner:GetMGVar("animationStatus", false) then
		if CLIENT then
			self:OpenFrame()
		end
	else
		if SERVER then
			timer.Simple(0, function()
				if !IsValid(self.Owner) then return end
				AnimationSWEP:SetCrossing(self.Owner, false)
			end)
		end
	end
end

function SWEP:SecondaryAttack()
	if !SERVER or !IsValid(self.Owner) then return end
	if self.Owner:GetMGVar("animationStatus", false) then
		AnimationSWEP:SetCrossing(self.Owner, false)
	end
end

if SERVER then
	concommand.Add("animswep_play", function(ply, cmd, args)
        if !IsValid(ply) then return end
		local wep = ply:GetActiveWeapon()
		if !wep:IsValid() or wep:GetClass() != "animation_base" then return end
		local Gesture = args[1]
		local Class = AnimationSWEP.GestureAngles[Gesture]
		if !Class then return end
		if !ply:Crouching() and ply:GetVelocity():LengthSqr() < (AnimationSWEP.MovementDeactivate[Gesture] or 25) and !ply:InVehicle() then
			if ply:GetMGVar("animationStatus", false) then
				AnimationSWEP:SetCrossing(ply, false)
				return
			end
			AnimationSWEP:SetCrossing(ply, true, Gesture, AnimationSWEP.MovementDeactivate[Gesture])
		end
	end)

	function SWEP:OnDrop()
		local ply = self.Owner
		if !IsValid(ply) then return end
		if ply:GetMGVar("animationStatus", false) then
			AnimationSWEP:SetCrossing(ply, false)
		end
	end

	function SWEP:Holster()
		local ply = self.Owner
		if !IsValid(ply) then return end
		if ply:GetMGVar("animationStatus", false) then
			AnimationSWEP:SetCrossing(ply, false)
		end
		return true
	end

	function SWEP:OnRemove()
		local ply = self.Owner
		if !IsValid(ply) then return end
		if ply:GetMGVar("animationStatus", false) then
			AnimationSWEP:SetCrossing(ply, false)
		end
	end
end