MG.AntiCrash = true

hook.Add("PhysgunPickup", "MG_BlockPhysgun", function(ply, ent)
	local can_physgun = hook.Run("MG_CanPhysgun", ply, ent)
	if isbool(can_physgun) then
		return can_physgun
	end
	if !MG.AllowPhysgunOnWorld and (ent:GetNW2Bool("MG_P_Blocked") or SERVER and ent:CreatedByMap()) then
		return false
	end
end)

hook.Add("CanTool", "MG_BlockToolgun", function(ply, tr, tool)
	local can_tool = hook.Run("MG_CanTool", ply, tr, tool)
	if isbool(can_tool) then
		return can_tool
	end
	local ent = tr.Entity
	if IsValid(ent) then
		if ent:GetNW2Bool("MG_T_Blocked") and MG.AllowedTools[tool] != true then
			return false
		elseif !MG.AllowToolgunOnWorld and (ent:GetNW2Bool("MG_T_Blocked_P") or SERVER and ent:CreatedByMap()) then
			return false
		end
	end
end)

if MG.EnableAntiPropMinge and MG.EnableGhostingCommands then
	properties.Add("MG_UnghostProp", {
		MenuLabel = MG.LanguageStrings["ghostdeac"],
		Order = 10000,
		MenuIcon = "icon16/shield_delete.png",
		Filter = function(self, ent, ply)
			if !IsValid(ent) or MG.ProtectGroups[ply:GetUserGroup()] != true then return false end
			local class = ent:GetClass()
			if ent:GetNW2Bool("MG_Disabled") then return false end
			if !MG.GhostAllEntities and class != "prop_physics" and class != "prop_physics_multiplayer" then return false end
			if MG.UseWhitelist and MG.MingeEntities[class] == true then return false end
			if !MG.UseWhitelist and MG.MingeEntities[class] != true then return false end
			return true
		end,
		Action = function(self, ent)
			self:MsgStart()
				net.WriteEntity(ent)
			self:MsgEnd()
		end,
		Receive = function(self, length, player)
			local ent = net.ReadEntity()
			if !IsValid(ent) or MG.ProtectGroups[player:GetUserGroup()] != true then return false end
			local class = ent:GetClass()
			if ent:GetNW2Bool("MG_Disabled") then return false end
			if !MG.GhostAllEntities and class != "prop_physics" and class != "prop_physics_multiplayer" then return false end
			if MG.UseWhitelist and MG.MingeEntities[class] == true then return false end
			if !MG.UseWhitelist and MG.MingeEntities[class] != true then return false end
			ent:SetNW2Bool("MG_Disabled", true)
			if MG.IsProtected(ent) then
				MG.SetProtected(ent, false)
				MG.DisableProtectionMode(ent)
			end
			MG.Notify(player, 0, 4, MG.LanguageStrings["unprotected"])
		end
	})

	properties.Add("MG_GhostProp", {
		MenuLabel = MG.LanguageStrings["ghostac"],
		Order = 10000,
		MenuIcon = "icon16/shield.png",
		Filter = function(self, ent, ply)
			if !IsValid(ent) or MG.ProtectGroups[ply:GetUserGroup()] != true then return false end
			if !ent:GetNW2Bool("MG_Disabled") then return false end
			local class = ent:GetClass()
			if !MG.GhostAllEntities and class != "prop_physics" and class != "prop_physics_multiplayer" then return false end
			if MG.UseWhitelist and MG.MingeEntities[class] == true then return false end
			if !MG.UseWhitelist and MG.MingeEntities[class] != true then return false end
			return true
		end,
		Action = function(self, ent)
			self:MsgStart()
				net.WriteEntity(ent)
			self:MsgEnd()
		end,
		Receive = function(self, length, player)
			local ent = net.ReadEntity()
			if !IsValid(ent) or MG.ProtectGroups[player:GetUserGroup()] != true then return false end
			if !ent:GetNW2Bool("MG_Disabled") then return false end
			local class = ent:GetClass()
			if !MG.GhostAllEntities and class != "prop_physics" and class != "prop_physics_multiplayer" then return false end
			if MG.UseWhitelist and MG.MingeEntities[class] == true then return false end
			if !MG.UseWhitelist and MG.MingeEntities[class] != true then return false end
			ent:SetNW2Bool("MG_Disabled", false)
			if MG.CheckForStuckingPlayers(ent) and !MG.IsProtected(ent) then
				MG.SetProtected(ent, true)
				MG.EnableProtectionMode(ent)
			else
				MG.SetProtected(ent, false)
			end
			local phys = ent:GetPhysicsObject()
			if phys:IsValid() then
				phys:EnableMotion(false)
			end
			MG.Notify(player, 0, 4, MG.LanguageStrings["protected"])
		end
	})
end

print("[MG AntiCrash] Shared initialised")