if SERVER then 
	include("ballistic_shields/sh_bs_util.lua") 
	include("ballistic_shields/sv_bs_util.lua") 
end
include("bs_config.lua") 
include("ballistic_shields/sh_bs_lang.lua") 

SWEP.PrintName = "Riot Schild"
SWEP.Instructions = "Linksklick zum Angreifen.\nRechtsklick um die Sichtbarkeit zu Konfigurieren."
SWEP.Spawnable = true

SWEP.ViewModel = ""
SWEP.WorldModel = Model("models/bshields/rshield.mdl")

SWEP.AutoSwitchTo = false
SWEP.AutoSwitchFrom	= false

SWEP.Slot = 3
SWEP.SlotPos = 20
SWEP.DrawAmmo = false
SWEP.DrawCrosshair = false

SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Automatic = false
SWEP.Primary.Ammo = "none"
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Automatic = false
SWEP.Secondary.Ammo = "none"

SWEP.CanVisToggle = 0
SWEP.VisToggle = false
SWEP.HitDistance = 55
SWEP.IsShield = true

local SwingSound = Sound("WeaponFrag.Throw")
local HitSound = Sound("Flesh.ImpactHard")

function SWEP:SetupDataTables()
	self:NetworkVar("Float", 0, "Hit")
end

function SWEP:Initialize()
	self:SetHoldType("melee2")
end

function SWEP:DrawWorldModel()
	self:SetNoDraw(true) 
end

local ShieldIcon = Material("bshields/ui/riot_shield", "smooth")
local BackgroundIcon = Material("bshields/ui/background")
function SWEP:DrawHUD()
	if (bshields.config.disablehud) then return end
	surface.SetDrawColor(255,255,255,200)	
	surface.SetMaterial(BackgroundIcon)
	surface.DrawTexturedRect(ScrW()/2-ScrH()/10, ScrH()/2-ScrH()/30+ScrH()/3, ScrH()/5, ScrH()/15)
	surface.SetDrawColor(255,255,255,125)
	draw.SimpleTextOutlined(bshields.lang[bshields.config.language].rshieldprim, "bshields.HUD", ScrW()/2-ScrH()/32, ScrH()/2-ScrH()/28+ScrH()/3+ScrH()/22, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER, 1, Color(20,20,20,255)) 
	surface.SetMaterial(ShieldIcon)
	surface.DrawTexturedRect(ScrW()/2-ScrH()/10.2, ScrH()/2-ScrH()/32+ScrH()/3, ScrH()/16, ScrH()/16) 
	if (self.VisToggle) then
		draw.SimpleTextOutlined(bshields.lang[bshields.config.language].sec, "bshields.HUD", ScrW()/2-ScrH()/32, ScrH()/2-ScrH()/28+ScrH()/3+ScrH()/48, Color(255, 255, 255, 25), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER, 1, Color(20,20,20,255)) 
	else
		draw.SimpleTextOutlined(bshields.lang[bshields.config.language].sec, "bshields.HUD", ScrW()/2-ScrH()/32, ScrH()/2-ScrH()/28+ScrH()/3+ScrH()/48, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER, 1, Color(20,20,20,255)) 
	end
end

function SWEP:PreDrawViewModel(vm)
	if !IsValid(vm) then return end
	local ply = LocalPlayer()
	local shield = ply.bs_shieldIndex and Entity(ply.bs_shieldIndex)
	if !IsValid(shield) then return end
	local col = shield:GetColor()
	col.a = self.VisToggle and 125 or 255
	shield:SetColor(col)
end

function SWEP:BuildShield()
	local owner = self:GetOwner()
	local holdtype = 0
	bshield_remove(owner)
	local owner_tb = owner:GetTable()
	owner_tb.bs_type = "riot_shield"
	owner_tb.bs_shield = ents.Create("bs_shield")
	if !IsValid(owner_tb.bs_shield) then return end
	owner_tb.bs_shield.Model = "models/bshields/rshield.mdl"
	owner_tb.bs_shield.Mass = 30
	owner_tb.bs_shield:SetCollisionGroup(COLLISION_GROUP_WORLD)
	owner_tb.bs_shield:SetMoveType(MOVETYPE_NONE)
	owner_tb.bs_shield:SetPos(owner:GetPos())
	local att = owner:LookupAttachment("anim_attachment_RH")
	if (att == 0) then
		holdtype = 1
	end
	if (holdtype == 0) then	
		owner_tb.bs_shield:SetParent(owner, att)
		owner_tb.bs_shield:SetLocalAngles(bshields.shields[1][3].angles)
		owner_tb.bs_shield:SetLocalPos(bshields.shields[1][3].position)
	else
		att = owner:LookupAttachment("forward") != 0 and owner:LookupAttachment("forward") or owner:LookupAttachment("eyes") != 0 and owner:LookupAttachment("eyes")
		if (att == 0) then
			owner_tb.bs_shield:Remove()
			owner_tb.bs_shield = nil
			return
		end
		owner_tb.bs_shield:SetParent(owner, att)
		owner_tb.bs_shield:SetLocalAngles(bshields.shields[2][3].angles)
		owner_tb.bs_shield:SetLocalPos(bshields.shields[2][3].position)
	end
	owner_tb.bs_shield.holdtype = holdtype
	owner_tb.bs_shield.pos = {owner_tb.bs_shield:GetLocalAngles(), owner_tb.bs_shield:GetLocalPos()}
	owner_tb.bs_shield.model = owner:GetModel()
	owner_tb.bs_shield:Spawn()
	self.HP = self.HP or bshields.config.shieldhps["rshield"]
	owner_tb.bs_shield:SetHealth(self.HP)
	owner_tb.bs_shield.MaxHP = self.MaxHP
	owner_tb.bs_shield:ColorShield()
	net.Start("bs_shield_info")
		net.WriteUInt(owner_tb.bs_shield:EntIndex(), 16) 
	net.Send(owner)
end

function SWEP:Deploy()
	self.CanVisToggle = 0
	self.VisToggle = false
	self.HP = self.HP or bshields.config.shieldhps["rshield"]
	self.MaxHP = bshields.config.shieldhps["rshield"]
	if SERVER then
		timer.Simple(0, function()
			if IsValid(self) and IsValid(self.Owner) and self.Owner:GetActiveWeapon() == self then
				self:BuildShield()
			end
		end)
	end
	return true
end

function SWEP:Think()
	local owner = self:GetOwner()
	if owner:IsValid() then
		if owner.bs_shield and owner:GetModel() != owner.bs_shield.model then
			self:BuildShield()
		end
	end
	local hit = self:GetHit()
	if (hit > 0 and CurTime() > hit) then
		self:DealDamage()
		self:SetHit(0)
	end
end

function SWEP:PrimaryAttack()
	local owner = self.Owner
	if !IsValid(owner) then return end
	owner:SetAnimation(PLAYER_ATTACK1)
	if SERVER then
		if !IsValid(owner.bs_shield) then return end
		if owner.bs_shield.holdtype == 0 and owner:LookupAttachment("anim_attachment_RH") > 0 then
			owner.bs_shield:SetLocalAngles(Angle(6,-34,-12)) 
			owner.bs_shield:SetLocalPos(Vector(4,8,-1)) 
			timer.Simple(0.4,function()
				if !IsValid(owner) or !IsValid(owner.bs_shield) then return end
				owner.bs_shield:SetLocalAngles(owner.bs_shield.pos[1]) 
				owner.bs_shield:SetLocalPos(owner.bs_shield.pos[2]) 
			end)
		end
	end
	self:EmitSound(SwingSound)
	self:SetHit(CurTime() + 0.2)
	self:SetNextPrimaryFire(CurTime() + 1)
end

function SWEP:DealDamage()
	local owner = self.Owner
	owner:LagCompensation(true)

	local shield
	if SERVER then
		shield = owner.bs_shield
	elseif LocalPlayer().bs_shieldIndex then
		shield = Entity(LocalPlayer().bs_shieldIndex)
	end
	if !IsValid(shield) then return end

	local tr = util.TraceLine({
		start = owner:GetShootPos(),
		endpos = owner:GetShootPos() + owner:GetAimVector() * self.HitDistance,
		mask = MASK_SHOT_HULL,
		filter = {owner, shield}
	})

	if (!IsValid(tr.Entity)) then
		tr = util.TraceHull({
			start = owner:GetShootPos(),
			endpos = owner:GetShootPos() + owner:GetAimVector() * self.HitDistance,
			mins = Vector(-10, -10, -8),
			maxs = Vector(10, 10, 8),
			mask = MASK_SHOT_HULL,
			filter = {owner, shield}
		})
	end

	if (tr.Hit and !(game.SinglePlayer() and CLIENT)) then
		self:EmitSound(HitSound)
	end

	if (SERVER and IsValid(tr.Entity)) then
		local dmginfo = DamageInfo()

		local attacker = owner
		if (!IsValid(attacker)) then attacker = self end
		dmginfo:SetAttacker(attacker)

		dmginfo:SetInflictor(self)
		dmginfo:SetDamage(math.random(bshields.config.rshielddmgmin, bshields.config.rshielddmgmax))

		local pos = owner:GetShootPos()
		local dest = pos + (owner:GetAimVector() * 48)
		tr.Entity:DispatchTraceAttack(dmginfo, pos + (owner:GetAimVector() * 3), dest)

	end

	if (SERVER and IsValid(tr.Entity)) then
		local phys = tr.Entity:GetPhysicsObject()
		if (IsValid(phys)) then
			phys:ApplyForceOffset(owner:GetAimVector() * 80 * phys:GetMass(), tr.HitPos)
		end
	end

	owner:LagCompensation(false)
end

function SWEP:SecondaryAttack()
	if CLIENT then
		if self.CanVisToggle > CurTime() then return end
		surface.PlaySound("weapons/smg1/switch_single.wav")
		if !self.VisToggle then
			self.VisToggle = true
		else
			self.VisToggle = false
		end
		self.CanVisToggle = CurTime() + 0.2
	end
end

function SWEP:ShouldDrawViewModel()
	local ply = LocalPlayer()
	local shield = ply.bs_shieldIndex and Entity(ply.bs_shieldIndex)
	if !IsValid(shield) then return end
	local col = shield:GetColor()
	col.a = self.VisToggle and 125 or 255
	shield:SetColor(col)
end

if CLIENT then return end

function SWEP:Holster()
	bshield_remove(self.Owner, function(hp)
		self.HP = hp
	end)
	return true
end

function SWEP:OnRemove()
	bshield_remove(self.Owner, function(hp)
		self.HP = hp
	end)
end

function SWEP:OnDrop()
	bshield_remove(self.Owner, function(hp)
		self.HP = hp
	end)
end