
ENT.Type = "anim"
ENT.Base = "base_anim"
ENT.PrintName = "ATM"
ENT.Category = "GlorifiedBanking"
ENT.Spawnable = true
ENT.Model = Model("models/sterling/glorifiedpig_atm.mdl")

--Set up the network vars
function ENT:SetupDataTables()
	self:NetworkVar("Int", 0, "ScreenID")
	self:NetworkVar("Int", 1, "WithdrawalFee")
	self:NetworkVar("Int", 2, "DepositFee")
	self:NetworkVar("Int", 3, "TransferFee")
	self:NetworkVar("String", 0, "SignText")
	self:NetworkVar("Entity", 0, "CurrentUser")

	if SERVER then
		self:SetScreenID(1)
		self:SetCurrentUser(NULL)
		self:SetWithdrawalFee(0)
		self:SetDepositFee(0)
		self:SetTransferFee(0)
		self:SetSignText("ATM")
	else
		self:NetworkVarNotify("ScreenID", self.OnScreenChange)
	end
end

function ENT:PhysgunPickup(ply)
	return !GetConVar("mg_movemode") or GetConVar("mg_movemode"):GetInt() > 1 and ply:IsAdmin() or GetConVar("mg_movemode") and GetConVar("mg_movemode"):GetInt() > 0 and ply:IsSuperAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return !GetConVar("mg_movemode") or GetConVar("mg_movemode"):GetInt() > 1 and ply:IsAdmin() or GetConVar("mg_movemode") and GetConVar("mg_movemode"):GetInt() > 0 and ply:IsSuperAdmin()
end

--Define all of our possible screens
ENT.Screens = {
	[1] = { --Idle screen
		hideCursor = true
	},
	[2] = { --Lockdown screen
		hideCursor = true
	},
	[3] = { --Main Menu
		loggedIn = true
	},
	[4] = { --Withdrawal screen
		loggedIn = true,
		previousPage = 3,
		takesKeyInput = true
	},
	[5] = { --Deposit screen
		loggedIn = true,
		previousPage = 3,
		takesKeyInput = true
	},
	[6] = { --Transfer screen
		loggedIn = true,
		previousPage = 3,
		takesKeyInput = true
	},
	[7] = { --Transactions screen
		loggedIn = true,
		previousPage = 3,
		takesKeyInput = true
	}
}
