GlorifiedBanking.CardDesign = {
	namePos = { .042, .73 },
	nameAlign = TEXT_ALIGN_LEFT,
	idPos = { .042, .85 },
	idAlign = TEXT_ALIGN_LEFT
}

GlorifiedBanking.CardMaterial = Material("glorified_banking/bank_card.png", "smooth noclamp")

function GlorifiedBanking.GetPlayerBalance()
	local ply = LocalPlayer()
	if not ply:IsValid() then return 0 end
	return ply:getDarkRPVar( "bank" ) or 0
end

function GlorifiedBanking.CanPlayerAfford( affordAmount )
	local numberedAffordAmount = tonumber( affordAmount )
	if numberedAffordAmount != nil then
		return GlorifiedBanking.GetPlayerBalance() >= numberedAffordAmount
	end
end

local plyMeta = FindMetaTable( "Player" )
function plyMeta:GetBankBalance()
	return GlorifiedBanking.GetPlayerBalance()
end

function plyMeta:CanAffordBank( affordAmount )
	return GlorifiedBanking.CanPlayerAfford( affordAmount )
end