
local PANEL = {}
local OfflineModuleBase, QueryResults, ViewSteamID
local CurrentSteamID

function PANEL:Init()
	self:SetSize(ScrH() * .746, ScrH() * .8)
	self:Center()
	self:MakePopup()

	self.Theme = GlorifiedBanking.Themes.GetCurrent()

	self.Navbar = vgui.Create("GlorifiedBanking.AdminNavbar", self)

	local function changePage(page)
		if not IsValid(self.Page) then
			self.Page = vgui.Create(page, self)
			self.Page:Dock(FILL)
			self.Page.CanEditPlayers = self.CanEditPlayers

			return
		end

		self.Page:AlphaTo(0, 0.15, 0, function(anim, panel)
			self.Page:Remove()

			self.Page = vgui.Create(page, self)
			self.Page:Dock(FILL)
			self.Page:SetAlpha(0)
			self.Page:AlphaTo(255, 0.15)
			self.Page.CanEditPlayers = self.CanEditPlayers
		end)
	end

	self.Navbar:AddItem(GlorifiedBanking.i18n.GetPhrase("gbAdminMenuPlayers"), LEFT, function(s) changePage("GlorifiedBanking.Players") end)
	self.Navbar:AddItem(GlorifiedBanking.i18n.GetPhrase("gbAdminMenuLogs"), LEFT, function(s) changePage("GlorifiedBanking.Logs") end)
	self.Navbar:AddItem("OFFLINE", LEFT, function(s) 
		if IsValid(OfflineModuleBase) then OfflineModuleBase:Remove() end
		local base = vgui.Create("DFrame")
		base:SetSize(400, 250)
		base:SetTitle("Offline Spieler verwalten")
		base:Center()
		base:MakePopup()
		OfflineModuleBase = base

		ViewSteamID = vgui.Create("DTextEntry", base)
		ViewSteamID:SetPlaceholderText("System über SteamID durchsuchen...")
		ViewSteamID:Dock(TOP)

		QueryResults = vgui.Create("DListView", base)
		QueryResults:Dock(FILL)
		QueryResults:AddColumn("Name")
		QueryResults:AddColumn("Kontostand")
		QueryResults:AddColumn("SteamID"):SetFixedWidth(0)
		QueryResults.OnRowRightClick = function(lID, lPanel)
			local rightClickMenu = vgui.Create("DMenu", QueryResults)
			rightClickMenu:AddOption("Kontostand setzen", function()
			Derma_StringRequest("Bank Offlineverwaltung", "Setze den Kontostand eines Spielers.", "Betrag hier angeben", function(newBalance)
				newBalance = tonumber(newBalance)
				if !isnumber(newBalance) then
					notification.AddLegacy("Du musst eine gültige Zahl angeben.", 1, 4)
					surface.PlaySound("buttons/lightswitch2.wav")
					return
				end
				net.Start("GlorifiedBanking.AdminPanel.OfflineModule.SetBalance")
					net.WriteString(CurrentSteamID)
					net.WriteInt(newBalance, 32)
				net.SendToServer()
			end, nil, "Fortfahren", "Abbrechen")
			end):SetIcon("icon16/money.png")
			rightClickMenu:Open()
		end

		local SearchBttn = vgui.Create("DButton", base)
		SearchBttn:SetText("Suche starten")
		SearchBttn:Dock(BOTTOM)
		SearchBttn.DoClick = function()
			if !ViewSteamID:GetValue():match("^STEAM_%d:%d:%d+$") then
				notification.AddLegacy("Du musst eine gültige SteamID angeben.", 1, 4)
				surface.PlaySound("buttons/lightswitch2.wav")
				return
			end
			net.Start("GlorifiedBanking.AdminPanel.OfflineModule.Query")
				net.WriteString(ViewSteamID:GetValue())
			net.SendToServer()
		end
	end)

	self.Navbar:AddItem("LOCK", LEFT, function(s)
		self.LockdownMode = not self.LockdownMode

		net.Start("GlorifiedBanking.AdminPanel.SetLockdownStatus")
		 net.WriteBool(self.LockdownMode)
		net.SendToServer()
	end)

	self.Navbar:AddItem("X", RIGHT, function(s)
		self:AlphaTo(0, 0.3, 0, function(anim, panel)
			panel:Remove()
		end)
	end)

	self.Navbar:SelectTab(1)
	timer.Simple(0, function()
		changePage("GlorifiedBanking.Players")
	end)

	self:SetAlpha(0)
	self:AlphaTo(255, 0.3)
end

function PANEL:PerformLayout(w, h)
	self.Navbar:Dock(TOP)
	self.Navbar:SetSize(w, h * .06)

	if IsValid(self.Page) then
		self.Page:Dock(FILL)
	end
end

function PANEL:Paint(w, h)
	draw.RoundedBox(6, 0, 0, w, h, self.Theme.Data.Colors.adminMenuBackgroundCol)
end

vgui.Register("GlorifiedBanking.AdminMenu", PANEL, "EditablePanel")

function GlorifiedBanking.UI.OpenAdminMenu(lockdownEnabled, canEditPlayers)
	if not IsValid(LocalPlayer()) then return end

	if IsValid(GlorifiedBanking.UI.AdminMenu) then
		GlorifiedBanking.UI.AdminMenu:Remove()
		GlorifiedBanking.UI.AdminMenu = nil
	end

	GlorifiedBanking.UI.AdminMenu = vgui.Create("GlorifiedBanking.AdminMenu")
	GlorifiedBanking.UI.AdminMenu.LockdownMode = lockdownEnabled
	GlorifiedBanking.UI.AdminMenu.CanEditPlayers = canEditPlayers
end

net.Receive("GlorifiedBanking.AdminPanel.OpenAdminPanel", function()
	GlorifiedBanking.UI.OpenAdminMenu(net.ReadBool(), net.ReadBool())
end)

net.Receive("GlorifiedBanking.AdminPanel.OfflineModule.Query", function()
	if !IsValid(QueryResults) then return end
	local balance, lastname = net.ReadInt(32), net.ReadString()
	CurrentSteamID = ViewSteamID:GetValue()
	QueryResults:Clear()
	QueryResults:AddLine(lastname, "$"..string.Comma(balance))
end)
