
--[[ Interest Settings ]]--
	GlorifiedBanking.Config.INTEREST_ENABLED = true -- Should interest be enabled or not?
	GlorifiedBanking.Config.INTEREST_TIMER = 2700 -- How often should the player receive interest? This amount is in seconds.
	GlorifiedBanking.Config.INTEREST_MAX = 15000 -- What's the maximum amount a player can receive in interest?
	GlorifiedBanking.Config.DEFAULT_INTEREST_PERCENTAGE = 0.05 -- What % should the player get for interest per x seconds? Set to 0 to disable interest for normal players.

	local specialGroups = {
		["vip"] = 0.1,	
		["vip+"] = 0.15,
		["vip++"] = 0.2,
		["moderator_vip"] = 0.2,
		["admin_vip"] = 0.2,
		["superadmin_vip"] = 0.2,
		["developer"] = 0.2,
		["teamleiter"] = 0.2,
		["community-manager"] = 0.2,
		["infrastrukturadmin"] = 0.2,
		["stellv. owner"] = 0.2,
		["owner"] = 0.2,
	}
	GlorifiedBanking.Config.INTEREST_AMOUNT_CUSTOMFUNC = function( ply ) -- Special function to return different interest for certain players.
		local userGroup = ply:GetUserGroup()
		if specialGroups[userGroup] then
			return specialGroups[userGroup]
		end
	end
--[[ End Interest Settings ]]--

--[[ Other Config ]]--
	GlorifiedBanking.Config.CARD_PAYMENT_FEE = 0 --Percentage fee (0-100) taken from transactions done via card readers.
	GlorifiedBanking.Config.MAXIMUM_DISTANCE_FROM_ATM = 200 -- What is the maximum distance for the validation checks on the ATMs?
--[[ End Other Config ]]--
