
SWEP.Base = "weapon_basekit" -- Requires weapon_basekit

SWEP.PrintName = GlorifiedBanking.i18n.GetPhrase("gbCardName")
SWEP.Category = "GlorifiedBanking"
SWEP.Instructions = GlorifiedBanking.i18n.GetPhrase("gbCardInstructions")

SWEP.Spawnable = true
SWEP.AdminOnly = false

SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Automatic = false
SWEP.Primary.Ammo = "none"

SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Automatic = false
SWEP.Secondary.Ammo = "none"

SWEP.AutoSwitchTo = true
SWEP.AutoSwitchFrom = false

SWEP.UseHands = true
SWEP.ViewModel = ""
SWEP.ShowWorldModel = false
SWEP.WorldModel = Model("models/weapons/w_crowbar.mdl")

DEFINE_BASECLASS("weapon_basekit")

SWEP.WElements = {
	["card"] = {type = "Model", model = "models/mg_banking/card.mdl", bone = "ValveBiped.Bip01_R_Hand", rel = "", pos = Vector(4, 1.0, -0.425), angle = Angle(98.75, 92.75, -10.114), size = Vector(1, 1, 1), color = Color(255, 255, 255, 255), surpresslightning = false, material = "", skin = 0, bodygroup = {}}
}

function SWEP:SetupDataTables()
	self:NetworkVar("Entity", 0, "Using")
end

function SWEP:Initialize()
	self:SetHoldType("normal")

	if SERVER then return end

	self.CardDesign = GlorifiedBanking.CardDesign

	return BaseClass.Initialize(self)
end

function SWEP:PrimaryAttack()
end

function SWEP:SecondaryAttack()
end

function SWEP:OnDrop()
	self:Remove()
end

if SERVER then return end

SWEP.Slot = 1
SWEP.SlotPos = 8
SWEP.DrawAmmo = false
SWEP.DrawCrosshair = false

SWEP.BounceWeaponIcon = false

local theme = GlorifiedBanking.Themes.GetCurrent()
hook.Add("GlorifiedBanking.ThemeUpdated", "GlorifiedBanking.CardSWEP.ThemeUpdated", function(newTheme)
	theme = newTheme
end)

function SWEP:DrawWeaponSelection(x, y, wide, tall, alpha)
	surface.SetDrawColor(255, 255, 255, alpha)
	surface.SetMaterial(GlorifiedBanking.CardMaterial)
	y = y + 10
	x = x + 10
	wide = wide - 20
	surface.DrawTexturedRect(x, y,  wide , (wide / 2))
	self:PrintWeaponInfo(x + wide + 20, y + tall * 0.95, alpha)
end

function SWEP:DrawHUDBackground()
	local ply = self:GetOwner()
	if not IsValid(ply) or ply:InVehicle() or IsValid(self:GetUsing()) then return end

	local scrw, scrh = ScrW(), ScrH()
	local scale = scrh / 1080
	local pad = scale * 30
	local cardw, cardh = scale * 420, scale * 240
	local cardx = scrw - pad - cardw

	surface.SetDrawColor(color_white)
	surface.SetMaterial(GlorifiedBanking.CardMaterial)
	surface.DrawTexturedRect(cardx, scrh - pad - cardh, cardw, cardh)

	if not self.CardDisplayID then
		local id = tostring(ply:SteamID64() or "1234123412341234"):sub(-16)
		self.CardDisplayID  = id:sub(1, 4)

		for i = 4, 15, 4 do
			self.CardDisplayID = self.CardDisplayID .. " " .. id:sub(i, i + 3)
		end
	end

	draw.SimpleText(self.CardDisplayID, "GlorifiedBanking.CardSWEP.Info", cardx + cardw * self.CardDesign.idPos[1], scrh - pad - cardh + cardh * self.CardDesign.idPos[2], theme.Data.Colors.cardNumberTextCol, self.CardDesign.idAlign)
	draw.SimpleText(ply:Name(), "GlorifiedBanking.CardSWEP.Info", cardx + cardw * self.CardDesign.namePos[1], scrh - pad - cardh + cardh * self.CardDesign.namePos[2], theme.Data.Colors.cardNameTextCol, self.CardDesign.nameAlign)
end

local maxDist
function SWEP:PrimaryAttack()
	if not game.SinglePlayer() and not IsFirstTimePredicted() then return end

	if IsValid(self:GetUsing()) then return end

	local ply = self:GetOwner()

	local tr = ply:GetEyeTrace()
	if not tr.Hit then return end

	maxDist = maxDist or GlorifiedBanking.Config.MAXIMUM_DISTANCE_FROM_ATM * GlorifiedBanking.Config.MAXIMUM_DISTANCE_FROM_ATM
	if tr.HitPos:DistToSqr(ply:GetPos()) > maxDist then
		GlorifiedBanking.Notify(1, 3, GlorifiedBanking.i18n.GetPhrase("gbCardTooFarAway"))
		return
	end

	if not tr.Entity.InsertCard then
		local cantInsertPhrase = GlorifiedBanking.i18n.GetPhrase("gbCardCantInsert")
		if tr.Entity:GetClass() == "worldspawn" then
			cantInsertPhrase = GlorifiedBanking.i18n.GetPhrase("gbCardInsertAir")
		end
		GlorifiedBanking.Notify(1, 3, cantInsertPhrase)

		return
	end

	tr.Entity:InsertCard()
end

function SWEP:PreDrawViewModel()
	return true
end

function SWEP:DrawWorldModel()
	if IsValid(self:GetUsing()) then return end
	return BaseClass.DrawWorldModel(self)
end