local meta = FindMetaTable("Player")
function meta:MG_CarDealer_CanBuyCar(class)
	local cardata = MG_CarDealer.Util_GetCarData(class)
	local vehdata = MG_CarDealer.Util_GetVehicleData(class)
	if !cardata or !vehdata then return false, "Du kannst dieses Auto aufgrund eines unbekannten Fehlers nicht kaufen!", "Nicht kaufbar!" end
	if !self:canAfford(cardata.CarPrice) then return false, "Du hast nicht genug Geld um dieses Auto zu kaufen!", "Nicht genug Geld!" end
	local func = cardata.CanSee
	if func then
		local allowed, message = func(self)
		if allowed == false then
			return allowed, message
		end
	end
	if cardata.AvailableGroup and !cardata.AvailableGroup[self:GetUserGroup()] then
		return false, "Du musst einen VIP-Rang besitzen, um dieses Auto kaufen zu können!", "Nur für VIPs!"
	end
	if cardata.AvailableMap and !table.HasValue(cardata.AvailableMap, game.GetMap()) then
		return false, "Das Auto kann nicht auf dieser Map gefahren werden!", "Falsche Map!"
	end
	return true
end

function meta:MG_CarDealer_CanSellCar(class)
	local cardata = MG_CarDealer.Util_GetCarData(class)
	local vehdata = MG_CarDealer.Util_GetVehicleData(class)
	if !cardata or !vehdata then return false, "Du kannst dieses Auto aufgrund eines unbekannten Fehlers nicht verkaufen!", "Nicht verkaufbar!" end
	return true
end

function meta:MG_CarDealer_CheckCarLimit()
	if !MG_CarDealerConfig.UnlimitedCarSpawn then
		local sid = self:SteamID()
		for _,v in ipairs(ents.FindByClass("prop_vehicle_*")) do
			if (SERVER and v.IsPlayerCar and v.OwnerID == sid) or v:GetNWString("OwnerSID") == sid then
				return false, "Du musst zuerst dein altes Auto zurückbringen, bevor du ein Neues spawnen kannst!"
			end
		end
	end
	return true
end

function meta:MG_CarDealer_CanSpawnCar(class)
	local cardata = MG_CarDealer.Util_GetCarData(class)
	local vehdata = MG_CarDealer.Util_GetVehicleData(class)
	if !cardata or !vehdata then return false, "Du kannst dieses Auto aufgrund eines unbekannten Fehlers nicht spawnen!", "Nicht kaufbar!" end
	if MG_CarDealerConfig.ForbiddenJobs[self:Team()] then
		return false, MG_CarDealerConfig.ForbiddenJobs[self:Team()][1], MG_CarDealerConfig.ForbiddenJobs[self:Team()][2]
	end
	if cardata.AvailableTeam and !table.HasValue(cardata.AvailableTeam, self:Team()) then
		return false, "Du hast nicht den richtigen Job um dieses Auto zu fahren!", "Falscher Beruf!"
	end
	if cardata.AvailableMap and !table.HasValue(cardata.AvailableMap, game.GetMap()) then
		return false, "Das Auto kann nicht auf dieser Map gefahren werden!", "Falsche Map!"
	end
	return true
end