hook.Add("PhysgunPickup", "MG_CarDealer_PickUp", function(ply, ent)
	if IsValid(ent) and ent:IsVehicle() then
		if MG_CarDealerConfig.PlayerPickupVehicles and ent:GetNWString("OwnerSID") == ply:SteamID() then
			return true
		end
		local adminpickup = MG_CarDealerConfig.AdminPickupVehicles
		if adminpickup == 1 and MG_CarDealerConfig:IsAdmin(ply) or adminpickup == 2 and MG_CarDealerConfig:IsSuperAdmin(ply) then
			return true
		end
		return false
	end
end, HOOK_MONITOR_HIGH or -2)

hook.Add("CanTool", "MG_CarDealer_ToolGun", function(ply, tr, tool)
	local ent = tr.Entity
	if IsValid(ent) and ent:IsVehicle() then
		local admintool = MG_CarDealerConfig.AdminAllowToolgun
		local admindelete = MG_CarDealerConfig.AdminAllowVehicleDelete
		if ((admintool == 1 and MG_CarDealerConfig:IsAdmin(ply) or admintool == 2 and MG_CarDealerConfig:IsSuperAdmin(ply))) or (tool == "remover" and (admindelete == 1 and MG_CarDealerConfig:IsAdmin(ply) or admindelete == 2 and MG_CarDealerConfig:IsSuperAdmin(ply))) or (MG_CarDealerConfig.PlayerAllowToolgun and ply == ent.Owner) then
			return true
		else
			return false
		end
	end
end, HOOK_MONITOR_HIGH or -2)

if SERVER then
	hook.Add("CanProperty", "MG_CarDealer_Property", function(ply, prop, ent)
		if ent:IsVehicle() then
			local adminprop = MG_CarDealerConfig.AdminAllowPropertyChange
			if (adminprop == 1 and MG_CarDealerConfig:IsAdmin(ply) or adminprop == 2 and MG_CarDealerConfig:IsSuperAdmin(ply)) or (MG_CarDealerConfig.PlayerAllowPropertyChange and ply == ent.Owner) then
				return true
			else
				if ply == ent.Owner then
					DarkRP.notify(ply, 1, 4, "Konfiguriere dein Auto beim Autohändler!")
				else
					DarkRP.notify(ply, 1, 4, "Dieses Auto gehört dir nicht!")
				end
				return false
			end
		end
	end, HOOK_MONITOR_HIGH or -2)

	hook.Add("GravGunOnPickedUp", "MG_CarDealer_JeepAmmo", function(ply, ent)
		ply.HoldingEntity = ent
	end)

	hook.Add("GravGunOnDropped", "MG_CarDealer_JeepAmmo", function(ply)
		ply.HoldingEntity = nil
	end)

	hook.Add("PlayerUse", "MG_CarDealer_JeepAmmo", function(ply, ent)
		if !IsValid(ent) or !ent:IsVehicle() then return end
		if ent:GetVehicleClass() == "Jeep" then
			local hitbox = ply:GetEyeTraceNoCursor().HitBox
			if ((hitbox == 2 or hitbox == 3) or IsValid(ply.HoldingEntity)) then
				return false
			end
		end
	end)
end

function MG_CarDealer.Util_GetVehicleData(carclass)
	return list.Get("Vehicles")[carclass]
end

local Cars = {}
local Categories = {}
timer.Simple(1, function()
	for _,v in ipairs(MG_CarDealerConfig.Cars) do
		if SERVER and MG_CarDealerConfig.Precache then
			local vehs = list.Get("Vehicles")[v.CarClass]
			if vehs and vehs.Model then
				util.PrecacheModel(vehs.Model)
			end
		end
		Cars[v.CarClass] = v

		v.Category = v.Category or "Spezial"

		Categories[v.Category] = Categories[v.Category] or {}
		table.insert(Categories[v.Category], v)
	end
end)

function MG_CarDealer.Util_GetCarData(carclass)
	return Cars[carclass]
end

function MG_CarDealer.Util_GetVehicleData(carclass)
	return list.Get("Vehicles")[carclass]
end

function MG_CarDealer.Util_GetCategory(category)
	return Categories[category]
end

function MG_CarDealer.Util_GetCategories()
	return Categories
end

function MG_CarDealer.Util_GenerateNextNumber(data, num)
	if data[num] then
		return MG_CarDealer.Util_GenerateNextNumber(data, num + 1)
	else
		return num
	end
end