MG_CarDealer_Tuners = {}

function MG_CarDealer.InitValue(Type)
	if Type == nil then return end
	if Type == "number" then
		return 0
	end
	if Type == "color" then
		return Color(255, 255, 255, 255)
	end
	if Type == "bool" then
		return true
	end
end

function MG_CarDealer.TunerElement_CreateStruct(luaname)
	local STR = {}
	STR.LuaName = luaname
	STR.Max = 3

	function STR:CanPlace(ply, carclass)
		return true
	end

	STR.Vars = {}
	function STR:AddOnTunerPanel(tunedata, panel, id, vars, firstinit, dupemothervars)
		vars = vars or {}
		tunedata.Elements = tunedata.Elements or {}
		id = id or MG_CarDealer.Util_GenerateNextNumber(tunedata.Elements, 1)
		local Format = {}
		Format.Type = self.LuaName
		Format.ID = id
		Format.Vars = {}
		for a, b in pairs(self.Vars) do
			Format.Vars[b.LuaName] = vars[b.LuaName] or MG_CarDealer.InitValue(b.Type)
			if firstinit then
				if self.Vars[b.LuaName].StartValue then
					Format.Vars[b.LuaName] = self.Vars[b.LuaName].StartValue
				end
			end
		end
		if dupemothervars then
			Format.Vars = table.Copy(dupemothervars)
		end
		tunedata.Elements[id] = Format
		local BG = vgui.Create("CarDealer_DSWButton")
		BG:SetTall(20)
		BG:SetTexts(self.PrintName)
		BG.BoarderCol = Color(0, 0, 0, 0)
		BG.PaintBackGround = function(slf)
			if panel.SelectedButton == slf then
				surface.SetDrawColor(Color(0, 50, 150, 100))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			end
		end
		panel.ElementList:AddItem(BG)

		function BG:OnMousePressed(mc)
			if mc == MOUSE_RIGHT then
				local menu = DermaMenu(self)
				menu:SetSkin("CarDealer_ButtonMenu")
				menu:AddOption("Duplizieren", function(slf)
					surface.PlaySound("ui/buttonclick.wav")
					panel:DuplicateElement(id)
				end):SetIcon("icon16/brick_add.png")
				menu:AddSpacer()
				menu:AddOption("Entfernen", function(slf)
					surface.PlaySound("ui/buttonclick.wav")
					panel.ToolList:Clear()
					tunedata.Elements[id] = nil
					self:Remove()
				end):SetIcon("icon16/cancel.png")
				menu:Open()
			end
			if mc == MOUSE_LEFT then
				self:LeftClicked()
			end
		end
		BG.LeftClicked = function(slf)
			surface.PlaySound("ui/buttonclick.wav")
			panel.SelectedButton = BG
			local List = panel.ToolList
			List:Clear()
			if self.Editor_Spacer[0] then
				List:AddSubTitle(self.Editor_Spacer[0])
			end
			local vars_ordered = {}
			for _, b in pairs(self.Vars) do
				table.insert(vars_ordered, b)
			end
			table.SortByMember(vars_ordered, "Order", function(a, b) return a > b end)
			for a, b in pairs(vars_ordered) do
				local luaname = b.LuaName
				if self.Vars[luaname].Type == "number" then
					local Slider = List:CreateSlider(b.LuaName, self.Vars[luaname].Min, self.Vars[luaname].Max, self.Vars[luaname].Decimal)
					Slider:SetValue(tunedata.Elements[id].Vars[luaname])
					Slider.OnValueChanged = function(slf, val)
						tunedata.Elements[id].Vars[luaname] = tonumber(val)
						panel:ApplyTuneData2Preview(tunedata)
					end
				elseif self.Vars[luaname].Type == "color" then
					local color = vgui.Create("DColorMixer")
					color:SetSize(List:GetWide(), 200)
					color.ValueChanged = function(slf, color)
						tunedata.Elements[id].Vars[luaname] = color
						panel:ApplyTuneData2Preview(tunedata)
					end
					color:SetColor(tunedata.Elements[id].Vars[luaname])
					List:AddItem(color)
				elseif self.Vars[luaname].Type == "optionselect" then
					List:AddSubTitle(self.Vars[luaname].LuaName.."-Liste")
					local ListSelect = vgui.Create("DPanelList")
					ListSelect:SetTall(100)
					ListSelect:EnableHorizontal(false)
					ListSelect:EnableVerticalScrollbar(true)
					ListSelect:MG_CarDealer_PaintListBarC()
					local firstselect
					local soundobject
					for _,v in pairs(self.Vars[luaname].Options or {}) do
						local MenuButton = vgui.Create("DButton")
						MenuButton:SetTall(20)
						MenuButton:SetText("")
						MenuButton.Paint = function(slf)
							if tunedata.Elements[id].Vars[luaname] == v.Data then
								surface.SetDrawColor(Color(0, 50, 150, 100))
								surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
							end
							draw.SimpleText(v.DataTable.PrintName or v.Data, "MG_CarDealer_TrebOut_S20", 10, 1, Color(255, 255, 255, 255))
						end
						MenuButton.DoClick = function(slf, weirdfix)
							tunedata.Elements[id].Vars[luaname] = v.Data
							if !weirdfix then
								if v.DataTable.PlayTime then
									if soundobject then
										soundobject:Stop()
									end
									soundobject = CreateSound(game.GetWorld(), v.Data)
									soundobject:SetSoundLevel(0)
									soundobject:Play()
									timer.Create("CarDealer_RemovePreviewSounds", v.DataTable.PlayTime, 1, function()
										if soundobject then
											soundobject:Stop()
											soundobject = nil
										end
									end)
								else
									surface.PlaySound("ui/buttonclick.wav")
								end
							end
						end
						MenuButton.OnRemove = function(slf)
							if soundobject then
								soundobject:Stop()
								soundobject = nil
							end
						end
						if tunedata.Elements[id].Vars[luaname] then
							if tunedata.Elements[id].Vars[luaname] == v.Data then
								MenuButton:DoClick(true)
							end
						else
							if !firstselect then
								firstselect = true
								MenuButton:DoClick(true)
							end
						end
						ListSelect:AddItem(MenuButton)
					end
					List:AddItem(ListSelect)
				end
				if self.Editor_Spacer[a] then
					List:AddSubTitle(self.Editor_Spacer[a])
				end
			end
		end
		return Format
	end

	function STR:AddVars(luaname, typ)
		local VS = {}
		VS.LuaName = luaname
		VS.Type = typ
		VS.Min = 1
		VS.Max = 100
		VS.Decimal = 0
		VS.Order = table.Count(self.Vars)
		function VS:AddOption(data, datatable)
			DataTable = datatable or {}
			self.Options = self.Options or {}
			self.Options[data] = {Data = data, DataTable = datatable}
		end
		self.Vars[luaname] = VS
		return VS
	end

	STR.Editor_Spacer = {}
	function STR:Editor_AddSpacer(text)
		self.Editor_Spacer[table.Count(self.Vars)] = text
	end

	function STR:CL_Think()
	end

	function STR:SV_Think()
	end

	function STR:SV_KeyPressed()
	end

	function STR:Render()
	end

	function STR:RenderOnEditor()
	end

	function STR:SV_OnCreated()
	end

	return table.Copy(STR)
end

TunerElement = TunerElement or {}
function TunerElement.Register(data)
	MG_CarDealer_Tuners[data.LuaName] = data
end

function TunerElement.GetTable(luaname)
	local tbl = MG_CarDealer_Tuners[luaname]
	if tbl then return tbl end
	return false
end

function TunerElement.Include()
	local path = "tuner_extensions/"
	for _, file in pairs(file.Find(path.."*.lua", "LUA")) do
		if SERVER then
			AddCSLuaFile(path..file)
		end
		include(path..file)
	end
end

TunerElement.Include()