local SKIN = {}

local function surface_DrawBolder(x, y, w, h, w2)
	surface.DrawRect(x, y, w, w2)
	surface.DrawRect(x, h - w2, w, w2)
	surface.DrawRect(x, y, w2, h)
	surface.DrawRect(w - w2, y, w2, h)
end

local function surface_DrawOutlinedBox(x, y, w, h, col, bordercol, thickness)
	surface.SetDrawColor(col)
	surface.DrawRect(x + 1, y + 1, w - 2, h - 2)
	surface.SetDrawColor(bordercol)
	surface_DrawBolder(x, y, w, h, thickness or 1)
end

function SKIN:PaintMenu()
end

function SKIN:PaintMenuOption(self, w, h)
	if !self.FontSet then
		self:SetFont("MG_CarDealer_Treb_S20")
		self:SetTextInset(5, 0)
		self.FontSet = true
	end
	self:SetTextColor(color_white)
	surface_DrawOutlinedBox(0, 0, w, h, Color(0, 0, 0, 254), Color(0, 150, 255))
	if self.m_bBackground and (self:IsHovered() or self.Highlight) then
		surface_DrawOutlinedBox(0, 0, w, h, Color(0, 150, 255, 25), Color(0, 150, 255))
	end
end

derma.DefineSkin("CarDealer_ButtonMenu", "Car dealer reskin of the derma menu", SKIN)

local PANEL = {}
function PANEL:Init()
	self:SetText("")
	self.Status = "idle"
	self.Text = ""
	self.Font = "MG_CarDealer_TrebOut_S22"
	self.BoarderWidth = 1
	self.BoarderCol = Color(0, 150, 255, 255)
	self.TextCol = color_white
	self.Anim_Hover = 1
	self.Anim_Exit = 1
	self.Anim_Click = 1
	self.EventTime = nil
	self.HoverAnimTime = 0.3
	self.ClickSound = "ui/buttonclick.wav"
	self.AlignX = TEXT_ALIGN_CENTER
	self.AlignY = TEXT_ALIGN_CENTER
end

function PANEL:CursorEnter()
end

function PANEL:CursorExit()
end

function PANEL:OnCursorEntered()
	self.EventTime = {Time = CurTime(), Mode = "HoverPer"}
	self:CursorEnter()
end

function PANEL:OnCursorExited()
	if self.NoExit then self.NoExit = nil return end
	self:CursorExit()
	local time = CurTime() + self.HoverAnimTime
	if self.EventTime and self.EventTime.Time then
		if CurTime() - self.EventTime.Time < self.HoverAnimTime then
			time = CurTime() + (CurTime() - self.EventTime.Time)
		end
	end
	self.EventTime = {Time = time, Mode = "HoverPer_Exit"}
end

function PANEL:DoClick()
	surface.PlaySound(self.ClickSound)
	self.ClickTime = CurTime()
	self.EventTime = {Time = CurTime(), Mode = "Click"}
	self:Click()
	self.NoExit = true
end

function PANEL:SetTextAlign(X, Y)
	if X then
		self.AlignX = X
	end
	if Y then
		self.AlignY = Y
	end
end

function PANEL:SetTexts(name)
	self.Text = name
end

function PANEL:SetBoarderWidth(int)
	self.BoarderWidth = int
end

function PANEL:SetBoarderColor(color)
	self.BoarderCol = color
end

function PANEL:SetHoverAnim(int)
	self.Anim_Hover = int
end

function PANEL:SetExitAnim(int)
	self.Anim_Exit = int
end

function PANEL:SetClickAnim(int)
	self.Anim_Click = int
end

function PANEL:PaintBackGround()
end

function PANEL:PaintOverlay()
end

local function DrawBoarder(self)
	local wide = self:GetWide()
	local height = self:GetTall()
	local width = self.BoarderWidth
	surface.DrawRect(0, 0, wide, width)
	surface.DrawRect(0, height - width, wide, width)
	surface.DrawRect(0, 0, width, height)
	surface.DrawRect(wide - width, 0, width, height)
end

function PANEL:Paint()
	surface.SetDrawColor(self.BGCol or Color(0, 0, 0, 200))
	local wide = self:GetWide()
	surface.DrawLine(0, 0, wide, 0)
	local height = self:GetTall()
	surface.DrawRect(0, 0, wide, height)
	self:PaintBackGround()
	surface.SetDrawColor(self.BoarderCol)
	if self.BoarderCol.a > 0 then
		DrawBoarder(self)
	end
	if self.EventTime and self.EventTime.Time and self.EventTime.Mode then
		local mode = self.EventTime.Mode
		if mode == "HoverPer" then
			local per = CurTime() - self.EventTime.Time
			local d = math.min(per, self.HoverAnimTime) * 4
			surface.SetDrawColor(Color(0, 150, 255, d * 30))
			surface.DrawRect(1, 1, (wide - 2), height - 2)
		end
		if mode == "HoverPer_Exit" then
			local per = self.EventTime.Time - CurTime()
			local d = math.max(per, 0) * 4
			surface.SetDrawColor(Color(0, 150, 255, d * 30))
			surface.DrawRect(1, 1, (wide - 2), height - 2)
		end
		if mode == "Click" then
			local per = CurTime() - self.EventTime.Time
			local d = 1 - math.min(per * 4, 1)
			surface.SetDrawColor(Color(0, 50, 255, d * 50))
			surface.DrawRect(1, 1, (wide - 2), height - 2)
		end
	end
	local pos_x = wide / 2
	local pos_y = height / 2
	local align_x = self.AlignX
	if align_x == TEXT_ALIGN_LEFT then
		pos_x = 10
	end
	if align_x == TEXT_ALIGN_RIGHT then
		pos_x = wide - 10
	end
	if align_x == TEXT_ALIGN_TOP then
		pos_y = 1
	end
	if align_x == TEXT_ALIGN_BOTTOM then
		pos_y = height - 1
	end
	draw.SimpleText(self.Text, self.Font, pos_x, pos_y, self.TextCol, align_x, self.AlignY)
	self:PaintOverlay()
end

function PANEL:Click()
end

vgui.Register("CarDealer_DSWButton", PANEL, "DButton")

local MG_CarDealerNoticePanel
function MG_CarDealer.ShowAsker(txt, callback, denycallback)
	if IsValid(MG_CarDealerNoticePanel) then MG_CarDealerNoticePanel:Remove() end	
	MG_CarDealerNoticePanel = vgui.Create("DFrame")
	MG_CarDealerNoticePanel:SetSize(ScrW(), ScrH())
	MG_CarDealerNoticePanel:SetText("")
	MG_CarDealerNoticePanel:ShowCloseButton(false)
	MG_CarDealerNoticePanel:SetDraggable(false)
	MG_CarDealerNoticePanel:MakePopup()
	MG_CarDealerNoticePanel:ParentToHUD()
	local ply = LocalPlayer()
	MG_CarDealerNoticePanel.Paint = function(self)
		if !ply:Alive() then
			MG_CarDealerNoticePanel:Remove()
			return
		end
		surface.SetDrawColor(Color(0, 0, 0, 200))
		surface.DrawRect(0, 0, self:GetWide(), self:GetTall())
		draw.SimpleText(txt, "MG_CarDealer_Treb_S30", ScrW() / 2, ScrH() / 2, Color(0, 255, 255, 255), TEXT_ALIGN_CENTER)
	end
	local Button_Accept = vgui.Create("CarDealer_DSWButton", MG_CarDealerNoticePanel)
	Button_Accept:SetPos(MG_CarDealerNoticePanel:GetWide() / 2 - 220, MG_CarDealerNoticePanel:GetTall() / 3 * 2)
	Button_Accept:SetSize(200, 30)
	Button_Accept:SetTexts("Akzeptieren")
	Button_Accept.Click = function()
		MG_CarDealerNoticePanel:Remove()
		if callback then
			callback()
		end
	end
	local Button_Decline = vgui.Create("CarDealer_DSWButton", MG_CarDealerNoticePanel)
	Button_Decline:SetPos(MG_CarDealerNoticePanel:GetWide() / 2 + 20, MG_CarDealerNoticePanel:GetTall() / 3 * 2)
	Button_Decline:SetSize(200, 30)
	Button_Decline:SetTexts("Ablehnen")
	Button_Decline.Click = function()
		MG_CarDealerNoticePanel:Remove()
		if denycallback then
			denycallback()
		end
	end
end

local MG_CarDealerAskPanel
function MG_CarDealer.ShowSearch(txt, callback, denycallback)
	if IsValid(MG_CarDealerAskPanel) then MG_CarDealerAskPanel:Remove() end	
	MG_CarDealerAskPanel = vgui.Create("DFrame")
	MG_CarDealerAskPanel:SetSize(ScrW(), ScrH())
	MG_CarDealerAskPanel:SetTitle("")
	MG_CarDealerAskPanel:ShowCloseButton(false)
	MG_CarDealerAskPanel:SetDraggable(false)
	MG_CarDealerAskPanel:MakePopup()
	MG_CarDealerAskPanel:ParentToHUD()
	local ply = LocalPlayer()
	MG_CarDealerAskPanel.Paint = function(self)
		if !ply:Alive() then
			MG_CarDealerNoticePanel:Remove()
			return
		end
		surface.SetDrawColor(Color(0, 0, 0, 200))
		surface.DrawRect(0, 0, self:GetWide(), self:GetTall())
		draw.SimpleText(txt, "MG_CarDealer_Treb_S35", ScrW() / 2, ScrH() / 2  - 50, Color(0, 255, 255, 255), TEXT_ALIGN_CENTER)
	end
	local TextEntry = vgui.Create("DTextEntry", MG_CarDealerAskPanel)
	TextEntry:SetPos(MG_CarDealerAskPanel:GetWide() / 2 - 220, MG_CarDealerAskPanel:GetTall() / 3 * 2 - 80)
	TextEntry:SetSize(440, 30)
	TextEntry:SetFont("MG_CarDealer_Treb_S25")
	TextEntry:SetValue("")
	TextEntry:RequestFocus()
	local Button_Accept = vgui.Create("CarDealer_DSWButton", MG_CarDealerAskPanel)
	Button_Accept:SetPos(MG_CarDealerAskPanel:GetWide() / 2 - 220, MG_CarDealerAskPanel:GetTall() / 3 * 2)
	Button_Accept:SetSize(200, 30)
	Button_Accept.Font = "MG_CarDealer_Treb_S25"
	Button_Accept:SetTexts("Bestätigen")
	Button_Accept.Click = function()
		MG_CarDealerAskPanel:Remove()
		if callback then
			callback(TextEntry:GetValue())
		end
	end
	local Button_Decline = vgui.Create("CarDealer_DSWButton", MG_CarDealerAskPanel)
	Button_Decline:SetPos(MG_CarDealerAskPanel:GetWide() / 2 + 20, MG_CarDealerAskPanel:GetTall() / 3 * 2)
	Button_Decline:SetSize(200, 30)
	Button_Decline.Font = "MG_CarDealer_Treb_S25"
	Button_Decline:SetTexts("Abbrechen")
	Button_Decline.Click = function()
		MG_CarDealerAskPanel:Remove()
		if denycallback then
			denycallback(TextEntry:GetValue())
		end
	end
end