local car_dealer_startininventory = CreateClientConVar("car_dealer_startininventory", 0, FCVAR_ARCHIVE)
local car_dealer_categoryautoselect = CreateClientConVar("car_dealer_categoryautoselect", 1, FCVAR_ARCHIVE)

local MG_CarDealerShopPanel
local MG_CarDealer_OldData = {}

hook.Add("MG_CarDealer_InvAdjusted", "MG_CarDealer_Inventory_Update", function()
	for _, v in ipairs(MG_CarDealer_Inventory) do
		v.tunedata = v.tunedata and v.tunedata != "NULL" and util.JSONToTable(v.tunedata) or {}
	end
	if IsValid(MG_CarDealerShopPanel) then
		MG_CarDealerShopPanel.ReloadCars = true
		MG_CarDealer_OldData = table.Copy(MG_CarDealer_Inventory)
		if IsValid(MG_CarDealerShopPanel.Canvas) and IsValid(MG_CarDealerShopPanel.Canvas.CarList) and MG_CarDealerShopPanel.Canvas.CarList.CarInventoryList then
			MG_CarDealerShopPanel.Canvas.CarList:UpdateList()
		end
	end
end)

function MG_CarDealer.Get3DWorldCamAngle()
	if IsValid(MG_CarDealerShopPanel) and IsValid(MG_CarDealerShopPanel.BGBackGroundPanel) then
		return MG_CarDealerShopPanel.BGBackGroundPanel.CamAngle
	end
end

function MG_CarDealer.OpenShop(npc)
	if IsValid(MG_CarDealerShopPanel) then return end
	local ply = LocalPlayer()
	if (!IsValid(npc) or npc:GetClass() != "car_dealer" or npc:GetPos():DistToSqr(ply:EyePos()) > 90000) then return end
	MG_CarDealer_Inventory = nil
	MG_CarDealerShopPanel = vgui.Create("CarDealer_CarShop")
	MG_CarDealerShopPanel:SetPos(0, 0)
	MG_CarDealerShopPanel:SetSize(ScrW(), ScrH())
	MG_CarDealerShopPanel.SellerNPC = npc
	MG_CarDealerShopPanel:Install()
	MG_CarDealerShopPanel:MakePopup()
	MG_CarDealerShopPanel:ParentToHUD()
	MG_CarDealerShopPanel.Think = function()
		if !ply:Alive() or !IsValid(npc) or npc:GetPos():DistToSqr(ply:EyePos()) > 90000 then
			MG_CarDealerShopPanel:Close()
		end
	end
end

local PANEL = {}
MG_CarDealerPanel_Tuner = PANEL

function PANEL:Init()
	self:ShowCloseButton(true)
	self:SetTitle("")
	self:SetDraggable(false)
	self:ShowCloseButton(false)
end

function PANEL:ReBuildCanvas()
	if IsValid(self.Canvas) then
		self.Canvas:Remove()
		self.Canvas = nil
	end
	self.Canvas = vgui.Create("DPanel", self)
	self.Canvas:SetPos(0, self.TopPanel:GetTall())
	self.Canvas:SetSize(self:GetWide(), self:GetTall() - self.TopPanel:GetTall())
	self.Canvas.Paint = function(slf)
	end
	return self.Canvas
end

local bgcolor = Color(0, 0, 0, 200)
local subtextcolor = Color(210, 210, 210, 255)
local function CreateTitle(self, text, color)
	local Label = vgui.Create("DPanel")
	Label:SetTall(30)
	Label.Paint = function(self)
		surface.SetDrawColor(Color(bgcolor.r, bgcolor.g, bgcolor.b, 255))
		surface.DrawRect(0, 0, self:GetWide(), self:GetTall())
		draw.SimpleText(text, "MG_CarDealer_TrebLW_S30", 10, self:GetTall() / 2, color or color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end
	self.CarInfoLister:AddItem(Label)
end

local function GenerateFullPrice(self, data)
	local armored = data.armored and data.armored != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.ArmorUpgradeCost) or 0
	local extrafuel = data.extrafuel and data.extrafuel != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.FuelUpgradeCost) or 0
	local bulletproof = data.bulletproof and data.bulletproof != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.BulletProofCost) or 0
	local vehiclealarm = data.vehiclealarm and data.vehiclealarm != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.AlarmCost) or 0
	local lock = data.lock and data.lock != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.LockCost) or 0
	local insurance = data.insurance and data.insurance != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.InsuranceCost) or 0
	return math.floor(self.SelectedCarInvData.CarPrice + armored + extrafuel + bulletproof + vehiclealarm + lock + insurance)
end

local function GenerateSellPrice(self, data)
	local armored = data.armored and data.armored != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.ArmorUpgradeCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local extrafuel = data.extrafuel and data.extrafuel != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.FuelUpgradeCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local bulletproof = data.bulletproof and data.bulletproof != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.BulletProofCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local vehiclealarm = data.vehiclealarm and data.vehiclealarm != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.AlarmCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local lock = data.lock and data.lock != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.LockCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local insurance = data.insurance and data.insurance != "NULL" and (self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.InsuranceCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	return math.floor((self.SelectedCarInvData.SellPrice or self.SelectedCarInvData.CarPrice * MG_CarDealerConfig.SellPrice) + armored + extrafuel + bulletproof + vehiclealarm + lock + insurance)
end

local function CreateInfoButton(self, name, id, data)
	local Label = vgui.Create("DPanel")
	Label:SetTall(35)
	Label.Paint = function(slf)
		surface.SetDrawColor(bgcolor)
		surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
		draw.SimpleText(name..":", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		local installed = data[id] and tonumber(data[id]) == 1
		local bought = data[id] and data[id] != "NULL"
		draw.SimpleText(installed and "Aktiviert" or bought and "Deaktiviert" or "Gesperrt", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, installed and Color(0, 255, 0, 255) or bought and Color(255, 255, 0, 255) or Color(255, 0, 0, 255), TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
	end
	self.CarInfoLister:AddItem(Label)
	return Label
end

local function AddMenuOption(self, name, id, data, sid)
	local submenu, parentmenu = self:AddSubMenu(name)
	local installed = data[id] and tonumber(data[id]) == 1
	local bought = data[id] and data[id] != "NULL"
	parentmenu:SetSkin("CarDealer_ButtonMenu")
	parentmenu:SetIcon(installed and "icon16/tick.png" or bought and "icon16/asterisk_yellow.png" or "icon16/cross.png")
	if bought then
		if installed then
			submenu:AddOption("Deaktivieren", function()
				surface.PlaySound("ui/buttonclick.wav")
				MG_CarDealer.Admin_ChangeUpgrade(sid, data["id"], id, false)
				data[id] = 2
			end):SetIcon("icon16/folder_delete.png")
		else
			submenu:AddOption("Aktivieren", function()
				surface.PlaySound("ui/buttonclick.wav")
				MG_CarDealer.Admin_ChangeUpgrade(sid, data["id"], id, true)
				data[id] = 1
			end):SetIcon("icon16/folder_add.png")
		end
		submenu:AddOption("Entfernen", function()
			surface.PlaySound("ui/buttonclick.wav")
			MG_CarDealer.Admin_RemoveUpgrade(sid, data["id"], id)
			data[id] = nil
		end):SetIcon("icon16/delete.png")
	else
		submenu:AddOption("Hinzufügen", function()
			surface.PlaySound("ui/buttonclick.wav")
			MG_CarDealer.Admin_AddUpgrade(sid, data["id"], id)
			data[id] = 1
		end):SetIcon("icon16/add.png")
	end
	self:AddSpacer()
	return submenu
end

local current_player_cars = {}
local current_player_steamid
function PANEL:BuildPlayerGarage(player_cars, player_steamid)
	current_player_cars = player_cars
	current_player_steamid = player_steamid
	local selected_player = player.GetBySteamID(current_player_steamid) or NULL
	local ply = LocalPlayer()
	local MainPanel = self
	local Canvas = self:ReBuildCanvas()
	Canvas.Name = IsValid(selected_player) and selected_player:Name().."'s Garage" or "Garage von "..current_player_steamid
	Canvas.NextPlayerCheck = CurTime() + 1
	Canvas.Think = function(slf)
		if slf.NextPlayerCheck <= CurTime() then
			slf.NextPlayerCheck = CurTime() + 1
			selected_player = player.GetBySteamID(current_player_steamid) or NULL
		end
	end
	Canvas.Paint = function(slf)
		draw.SimpleText("Der Spieler ist derzeitig "..(IsValid(selected_player) and "online" or "offline")..".", "MG_CarDealer_TrebOut_S25", 20, slf:GetTall() - 80, color_white)
		if MG_CarDealerConfig.AutoCam then
			self.BGBackGroundPanel.CamPos = LerpVector(RealFrameTime() * MG_CarDealerConfig.AutoCamSpeed, self.BGBackGroundPanel.CamPos, Vector(-280, 100, 150))
			self.BGBackGroundPanel.CamAngle = LerpAngle(RealFrameTime() * MG_CarDealerConfig.AutoCamSpeed, self.BGBackGroundPanel.CamAngle, (Vector(200, 0, 50) - self.BGBackGroundPanel.CamPos):Angle())
		end
	end

	function Canvas:SelectCar(num)
		local sorted = self.Sorted[num]
		if !sorted then
			sorted = self.Sorted[1]
			num = 1
			if !sorted then return end
		end
		if Canvas.SelectedCar and self.SelectedCarInvNum == num then return end
		local data = sorted.value
		Canvas.SelectedCar = true
		self.SelectedCarInvNum = num
		self.SelectedCarInvID = num
		self.SelectedInvVehicleData = MG_CarDealer.Util_GetVehicleData(data.carclass)
		self.SelectedCarInvData = MG_CarDealer.Util_GetCarData(data.carclass)
		MainPanel.BGBackGroundPanel:SetCar(data.carclass, self.SelectedInvVehicleData, false)
		MainPanel.BGBackGroundPanel:SetTuneData(data.tunedata)
		local BGPanelCarEntity = MainPanel.BGBackGroundPanel:GetCarEntity()
		self.CarInfoLister:Clear()
		CreateTitle(self, self.SelectedCarInvData.CarName, self.Sorted[self.SelectedCarInvID].Color)
		local Label = vgui.Create("DPanel")
		Label:SetTall(40)
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Neukaufpreis:", "MG_CarDealer_TrebLW_S25", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText("$"..string.Comma(GenerateFullPrice(self, data)), "MG_CarDealer_TrebLW_S25", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		local Label = vgui.Create("DPanel")
		Label:SetTall(40)
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Verkaufspreis:", "MG_CarDealer_TrebLW_S25", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText("$"..string.Comma(GenerateSellPrice(self, data)), "MG_CarDealer_TrebLW_S25", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		if self.SelectedCarInvData.Description then
			CreateTitle(self, "Beschreibung")
			local Label
			local Panel = vgui.Create("DPanel")
			Panel.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				slf:SetTall(Label:GetTall())
				surface.DrawRect(0, 0, slf:GetWide(), Label:GetTall())
			end
			Label = vgui.Create("DLabel", Panel)
			Label:SetPos(3, 0)
			Label:SetSize(297, 20)
			Label:SetWrap(true)
			Label:SetAutoStretchVertical(true)
			Label:SetText(self.SelectedCarInvData.Description)
			Label:SetColor(subtextcolor)
			Label:SetFont("MG_CarDealer_TrebLWOut_S20")
			Label.Paint = function(slf)
			end
			self.CarInfoLister:AddItem(Panel)
		end
		self.CarInfoLister:AddItem(Label)
		CreateTitle(self, "Aussehen")
		local Label = vgui.Create("DPanel")
		Label:SetTall(30)
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Skins:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText(self.SelectedCarInvData.NoSkin and 0 or BGPanelCarEntity:SkinCount() - 1, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		local Label = vgui.Create("DPanel")
		Label:SetTall(30)
		local count = 0
		for i=0, BGPanelCarEntity:GetNumBodyGroups() -1 do
			if self.SelectedCarInvData.BodygroupBlacklist and self.SelectedCarInvData.BodygroupBlacklist[BGPanelCarEntity:GetBodygroupName(i)] then continue end
			local cnt = BGPanelCarEntity:GetBodygroupCount(i)
			if cnt <= 1 then continue end
			count = count + 1
		end
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Körpergruppen:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText(self.SelectedCarInvData.NoBodygroup and 0 or count, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		local trunk = MG_Trunk and (MG_Trunk.CustomTrunkSizes[self.SelectedCarInvData.CarClass] or MG_Trunk.TrunkSize)
		if trunk and trunk > 0 or istable(self.SelectedCarInvData.AvailableTeam) and !table.IsEmpty(self.SelectedCarInvData.AvailableTeam) then
			CreateTitle(self, "Datenblatt")
		end
		if istable(self.SelectedCarInvData.AvailableTeam) and !table.IsEmpty(self.SelectedCarInvData.AvailableTeam) then
			local Label = vgui.Create("DPanel")
			Label:SetTall(30)
			local teams = ""
			local cnt = 0
			for k, v in ipairs(self.SelectedCarInvData.AvailableTeam) do
				cnt = cnt + 1
				teams = team.GetName(v)..(cnt != k  and ", " or "")
			end
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Benötigt:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText(teams, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if trunk and trunk > 0 then
			local Label = vgui.Create("DPanel")
			Label:SetTall(30)
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Stauraum:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText(trunk == 1 and "1 Platz" or trunk.." Plätze", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if MG_CarDealerConfig.EnableVCMod or self.EnableMG_VMod then
			CreateTitle(self, "Zustand")
		end
		if MG_CarDealerConfig.EnableVCMod then
			local unlimited = self.SelectedCarInvData.UnlimitedHealth
			local Label = vgui.Create("DPanel")
			Label:SetTall(35)
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Gesundheit:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				local hp = data.health
				local max_hp = data.maxhealth
				if (((!hp or hp == "NULL") and (!max_hp or max_hp == "NULL")) or tonumber(hp) != 0) then
					local perc = unlimited and "∞" or ((!hp or hp == "NULL") or (!max_hp or max_hp == "NULL")) and 100 or math.ceil((tonumber(hp) / tonumber(max_hp)) * 100) or 100
					local color = isstring(perc) and Color(200, 200, 200, 255) or perc < 30 and Color(255, 100, 0, 255) or perc < 60 and Color(255, 255, 0, 255) or perc < 80 and Color(150, 255, 0, 255) or perc <= 100 and Color(0, 255, 0, 255) or Color(200, 200, 200, 255)
					draw.SimpleText(!isstring(perc) and (perc.."%") or perc or "100%", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, color, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
				else
					draw.SimpleText("0% (Zerstört)", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, Color(255, 45, 45, 255), TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
				end
			end
			self.CarInfoLister:AddItem(Label)
		end
		if MG_CarDealerConfig.EnableMG_VMod then
			local unlimited = self.SelectedCarInvData.UnlimitedFuel
			local Label = vgui.Create("DPanel")
			Label:SetTall(35)
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Tankfülle:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				local fuel = data.fuel
				local max_fuel = data.maxfuel
				local perc = unlimited and "∞" or ((!fuel or fuel == "NULL") or (!max_fuel or max_fuel == "NULL")) and 100 or math.Round((tonumber(fuel) / tonumber(max_fuel)) * 100) or 100
				local color = isstring(perc) and Color(200, 200, 200, 255) or perc < 5 and Color(255, 0, 0, 255) or perc < 25 and Color(255, 100, 0, 255) or perc < 50 and Color(255, 255, 0, 255) or perc < 75 and Color(150, 255, 0, 255) or perc <= 100 and Color(0, 255, 0, 255) or Color(200, 200, 200, 255)
				draw.SimpleText(!isstring(perc) and (perc.."%") or perc or "100%", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, color, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if data.towed and data.towed != "NULL" and tonumber(data.towed) != 0 then
			local Label = vgui.Create("DPanel")
			Label:SetTall(40)
			Label.Paint = function(slf)
				if !data.towed or data.towed == "NULL" then slf:Remove() return end
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Status: ", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText(tonumber(data.towed) == 1 and "Abgeschleppt" or "Gestohlen", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, Color(255, 45, 45, 255), TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if MG_CarDealerConfig.EnableVCMod and !self.SelectedCarInvData.UnlimitedHealth then
			if (data.health and data.health != "NULL" and data.maxhealth and data.maxhealth != "NULL" and tonumber(data.health) != tonumber(data.maxhealth)) then
				local Button_Repair = vgui.Create("CarDealer_DSWButton")
				Button_Repair:SetTall(40)
				Button_Repair:SetTexts("Reparieren")
				Button_Repair.BoarderCol = Color(0, 0, 0, 0)
				Button_Repair.Click = function(slf)
					MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto für reparieren möchtest?", function()
						MG_CarDealer.Admin_RepairCar(player_steamid, data.id)
						slf:Remove()
						data.health = nil
					end)
				end
				self.CarInfoLister:AddItem(Button_Repair)
			end
		end
		if MG_CarDealerConfig.EnableMG_VMod and !self.SelectedCarInvData.UnlimitedFuel then
			if (data.fuel and data.fuel != "NULL" and data.maxfuel and data.maxfuel != "NULL" and tonumber(data.fuel) != tonumber(data.maxfuel)) then
				local Button_Refill = vgui.Create("CarDealer_DSWButton")
				Button_Refill:SetTall(40)
				Button_Refill:SetTexts("Auftanken")
				Button_Refill.BoarderCol = Color(0, 0, 0, 0)
				Button_Refill.Click = function(slf)
					MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto auftanken möchtest?", function()
						MG_CarDealer.Admin_RefillCar(player_steamid, data.id)
						slf:Remove()
						data.fuel = nil
					end)
				end
				self.CarInfoLister:AddItem(Button_Refill)
			end
		end
		if data.towed and data.towed != "NULL" and tonumber(data.towed) != 0 then
			local Button_Untow = vgui.Create("CarDealer_DSWButton")
			Button_Untow:SetTall(40)
			Button_Untow:SetTexts("Freischalten")
			Button_Untow.BoarderCol = Color(0, 0, 0, 0)
			Button_Untow.Click = function(slf)
				MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto freischalten möchtest?", function()
					MG_CarDealer.Admin_UntowCar(player_steamid, data.id)
					slf:Remove()
					data.towed = nil
				end)
			end
			self.CarInfoLister:AddItem(Button_Untow)
		end
		CreateTitle(self, "Verbesserungen")
		CreateInfoButton(self, "Autoversicherung", "insurance", data)
		CreateInfoButton(self, "Autopanzerung", "armored", data)
		CreateInfoButton(self, "Vergrößerter Tank", "extrafuel", data)
		CreateInfoButton(self, "Schusssichere Reifen", "bulletproof", data)
		CreateInfoButton(self, "Verbessertes Schloss", "lock", data)
		CreateInfoButton(self, "Autoalarmanlage", "vehiclealarm", data)
		CreateTitle(self, "Administration")
		local Button_Upgrade = vgui.Create("CarDealer_DSWButton")
		Button_Upgrade:SetTall(40)
		Button_Upgrade:SetTexts("Verbesserungen anpassen")
		Button_Upgrade.BoarderCol = Color(0, 0, 0, 0)
		Button_Upgrade.ClickSound = "ui/buttonclick.wav"
		Button_Upgrade.Click = function(slf)
			local menu = DermaMenu(slf)
			menu:SetSkin("CarDealer_ButtonMenu")
			if !self.SelectedCarInvData.UnlimitedHealth then
				AddMenuOption(menu, "Autoversicherung", "insurance", data, player_steamid)
				AddMenuOption(menu, "Autopanzerung", "armored", data, player_steamid)
			end
			if !self.SelectedCarInvData.UnlimitedFuel then
				AddMenuOption(menu, "Vergrößerter Tank", "extrafuel", data, player_steamid)
			end
			if !self.SelectedCarInvData.NoWheels then
				AddMenuOption(menu, "Schusssichere Reifen", "bulletproof", data, player_steamid)
			end
			AddMenuOption(menu, "Verbessertes Schloss", "lock", data, player_steamid)
			AddMenuOption(menu, "Autoalarmanlage", "vehiclealarm", data, player_steamid)
			menu:Open()
		end
		self.CarInfoLister:AddItem(Button_Upgrade)
		local Button_Destroy = vgui.Create("CarDealer_DSWButton")
		Button_Destroy:SetTall(40)
		Button_Destroy:SetTexts("Auto entfernen")
		Button_Destroy.BoarderCol = Color(0, 0, 0, 0)
		Button_Destroy.Click = function(slf)
			MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto entfernen möchtest?", function()
				MG_CarDealer.Admin_DestroyVehicle(player_steamid, data.id)
				self.CarInfoLister:Clear()
				self.SelectedCarInvNum = nil
			end)
		end
		self.CarInfoLister:AddItem(Button_Destroy)
	end

	function Canvas:SelectNextCar(int)
		if !self.SelectedCarInvID then return end
		self.SelectedCarInvID = self.SelectedCarInvID + int
		local sorted = #self.Sorted
		if self.SelectedCarInvID <= 0 then
			self.SelectedCarInvID = sorted
		end
		if self.SelectedCarInvID > sorted then
			self.SelectedCarInvID = 1
		end
		local data = self.Sorted[self.SelectedCarInvID]
		if !data then return end
		self:SelectCar(self.SelectedCarInvID)
	end

	local BottomBar = vgui.Create("DPanel", Canvas)
	BottomBar:SetSize(Canvas:GetWide(), 50)
	BottomBar:SetPos(0, Canvas:GetTall() - BottomBar:GetTall())
	BottomBar.Paint = function(slf)
		surface.SetDrawColor(0, 0, 0, 210)
		surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
		surface.SetDrawColor(255, 255, 255, 210)
		surface.DrawRect(0, 0, slf:GetWide(), 2)
		if Canvas.SelectedCarInvData then
			draw.SimpleText(Canvas.SelectedCarInvData.CarName, "MG_CarDealer_TrebLW_S40", slf:GetWide() / 2, slf:GetTall() / 2, Canvas.Sorted[Canvas.SelectedCarInvID] and Canvas.Sorted[Canvas.SelectedCarInvID].Color or color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
	end
	local BackButton = vgui.Create("CarDealer_DSWButton", Canvas)
	BackButton:SetSize(250, 50)
	BackButton:SetPos(BottomBar:GetWide() / 2 - 125, Canvas:GetTall() - BottomBar:GetTall() - 60)
	BackButton:SetTexts("Zurück")
	BackButton.Click = function(slf)
		self:BuildAdminView()
	end
	local AddCarButton = vgui.Create("CarDealer_DSWButton", Canvas)
	AddCarButton:SetSize(250, 50)
	AddCarButton:SetPos(BottomBar:GetWide() / 2 - 125, Canvas:GetTall() - BottomBar:GetTall() - 120)
	AddCarButton:SetTexts("Auto zuordnen")
	AddCarButton.Click = function(slf)
		local AvailableCars = {}
		for k, v in ipairs(MG_CarDealerConfig.Cars or {}) do
			local class = v.CarClass
			if !MG_CarDealer.Util_GetVehicleData(class) then continue end
			local cardata = MG_CarDealer.Util_GetCarData(class)
			if !cardata then continue end
			table.insert(AvailableCars, {Class = class, Name = v.CarName, Price = v.CarPrice})
		end
		table.sort(AvailableCars, function(a, b) return a.Name < b.Name end)
		local menu = DermaMenu(slf)
		menu:SetSkin("CarDealer_ButtonMenu")
		for _, v in ipairs(AvailableCars) do
			menu:AddOption(v.Name.." ($"..string.Comma(v.Price)..")", function()
				surface.PlaySound("ui/buttonclick.wav")
				MG_CarDealer.Admin_AddVehicle(player_steamid, v.Class)
			end)
		end
		menu:Open()
		menu:GetVBar().btnUp.Paint = function(slf, w, h)
			draw.RoundedBox(0, 0, 0, w, h, Color(150, 150, 150, 254))
		end
		menu:GetVBar().btnDown.Paint = function(slf, w, h)
			draw.RoundedBox(0, 0, 0, w, h, Color(150, 150, 150, 254))
		end
		menu:GetVBar().btnGrip.Paint = function(slf)
			draw.RoundedBox(0, 0, 0, slf:GetWide(), slf:GetTall(), Color(100, 100, 100, 254))
		end
		menu:GetVBar().Paint = function(slf)
			draw.RoundedBox(0, 0, 0, slf:GetWide(), slf:GetTall(), Color(25, 25, 25, 200))
		end
	end
	local Button_Left = vgui.Create("CarDealer_DSWButton", BottomBar)
	Button_Left:SetPos(BottomBar:GetWide() / 2 - 300, 5)
	Button_Left:SetSize(40, 40)
	Button_Left:SetTexts("<")
	Button_Left.BoarderCol = Color(0, 0, 0, 0)
	Button_Left.Click = function(slf)
		Canvas:SelectNextCar(-1)
	end
	local Button_Right = vgui.Create("CarDealer_DSWButton", BottomBar)
	Button_Right:SetPos(BottomBar:GetWide() / 2 + 260, 5)
	Button_Right:SetSize(40, 40)
	Button_Right:SetTexts(">")
	Button_Right.BoarderCol = Color(0, 0, 0, 0)
	Button_Right.Click = function(slf)
		Canvas:SelectNextCar(1)
	end
	local CarInfoLister = vgui.Create("DPanelList", Canvas)
	Canvas.CarInfoLister = CarInfoLister
	CarInfoLister:SetSize(300, Canvas:GetTall() - 100)
	CarInfoLister:SetPos(Canvas:GetWide() - CarInfoLister:GetWide() - 20, 20)
	CarInfoLister:EnableVerticalScrollbar(true)
	CarInfoLister:EnableHorizontal(false)
	CarInfoLister:MG_CarDealer_PaintListBarC()
	local CarsListBG = vgui.Create("DPanel", Canvas)
	CarsListBG:SetSize(300, Canvas:GetTall() - 200)
	CarsListBG:SetPos(20, 20)
	CarsListBG.Paint = function(slf)
	surface.SetDrawColor(Color(0, 0, 0, 255))
		surface.DrawRect(0, 0, slf:GetWide(), 40)
		draw.SimpleText("Autos des Spielers ("..#current_player_cars..")", "MG_CarDealer_TrebLW_S30", 10, 20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end
	local CarList = vgui.Create("DPanelList", CarsListBG)
	Canvas.CarList = CarList
	CarList.CarInventoryList = true
	CarList:SetPos(0, 40)
	CarList:SetSize(CarsListBG:GetWide(), CarsListBG:GetTall() - 40)
	CarList:EnableVerticalScrollbar(true)
	CarList:EnableHorizontal(false)
	CarList:MG_CarDealer_PaintListBarC()

	function CarList:UpdateList()
		self:Clear()
		local Sorted = {}
		for k, v in ipairs(current_player_cars or {}) do
			if !MG_CarDealer.Util_GetVehicleData(v.carclass) then continue end
			local cardata = MG_CarDealer.Util_GetCarData(v.carclass)
			if !cardata then continue end
			table.insert(Sorted, {key = k, value = v, Name = cardata.CarName, Color = (cardata.CanSee and Color(200, 0, 255) or cardata.AvailableMap and Color(0, 255, 0) or cardata.AvailableGroup and Color(255, 200, 50) or cardata.AvailableTeam and Color(255, 100, 100))})
		end
		Canvas.Sorted = Sorted
		local selected
		local max_cnt = #Sorted
		local cnt = 0
		for k, data in ipairs(Sorted) do
			cnt = cnt + 1
			local value = data.value
			local cardata = MG_CarDealer.Util_GetCarData(value.carclass)
			local Label = vgui.Create("DButton")
			Label:SetTall(30)
			Label.DoClick = function(slf)
				surface.PlaySound("ui/buttonclick.wav")
				Canvas:SelectCar(k)
			end
			Label:SetText("")
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				if Canvas.SelectedCarInvNum == k then
					surface.SetDrawColor(255, 255, 255, 30)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 255)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				elseif slf:IsHovered() then
					surface.SetDrawColor(255, 255, 255, 5)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 100)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				end
				draw.SimpleText(cardata.CarName, "MG_CarDealer_TrebLW_S25", 10, 15, data.Color or Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			end
			self:AddItem(Label)
			if forceselect and k == forceselect then
				selected = true
				Canvas:SelectCar(k)
			end
			if !selected and k == max_cnt then
				Canvas:SelectCar(Canvas.SelectedCarInvNum)
			end
		end
		if cnt <= 0 then
			local Label = vgui.Create("DButton")
			Label:SetTall(30)
			Label.DoClick = function()
			end
			Label:SetText("")
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Keine Autos verfügbar...", "MG_CarDealer_TrebLW_S25", 10, 15, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			end
			self:AddItem(Label)
		end
	end
	CarList:UpdateList()
end

function PANEL:BuildAdminView()
	if self.ActiveWindow == "admin" then return end
	self.ActiveWindow = "admin"

	net.Receive("MG_CarDealer_SendPlayerData_C2S", function()
		local leng = net.ReadUInt(16)
		local player_cars = util.JSONToTable(util.Decompress(net.ReadData(leng)))
		for _, v in ipairs(player_cars) do
			v.tunedata = v.tunedata and v.tunedata != "NULL" and util.JSONToTable(v.tunedata) or {}
		end
		local player_steamid = net.ReadString()
		if self.ActiveWindow == "player_inv" and IsValid(self.Canvas) and IsValid(self.Canvas.CarList) and player_steamid == current_player_steamid then
			current_player_cars = player_cars
			self.Canvas.CarList:UpdateList()
		else
			self:BuildPlayerGarage(player_cars, player_steamid)
			self.ActiveWindow = "player_inv"
		end
		self.ReloadCars = true
	end)

	local ply = LocalPlayer()
	local Canvas = self:ReBuildCanvas()
	Canvas.Name = "Adminübersicht"
	Canvas.Paint = function(slf)
		draw.SimpleText("Klicke auf einen Spieler oder gebe eine SteamID an.", "MG_CarDealer_TrebOut_S25", 20, slf:GetTall() - 80, color_white)
		if MG_CarDealerConfig.AutoCam then
			self.BGBackGroundPanel.CamPos = LerpVector(RealFrameTime() * MG_CarDealerConfig.AutoCamSpeed, self.BGBackGroundPanel.CamPos, Vector(280, 0, 120))
			self.BGBackGroundPanel.CamAngle = LerpAngle(RealFrameTime() * MG_CarDealerConfig.AutoCamSpeed, self.BGBackGroundPanel.CamAngle, (Vector(-250, 0, 0) - self.BGBackGroundPanel.CamPos):Angle())
		end
	end

	function Canvas:SelectPlayer(ply, num)
		self.SelectedPlayerNum = num
		local sorted = self.Sorted[num]
		if !sorted then return end
		self.SelectedPlayer = ply
	end

	function Canvas:SelectNextPlayer(int)
		if !self.SelectedPlayerNum then return end
		self.SelectedPlayerNum = self.SelectedPlayerNum + int
		local sorted = #self.Sorted
		if self.SelectedPlayerNum <= 0 then
			self.SelectedPlayerNum = sorted
		end
		if self.SelectedPlayerNum > sorted then
			self.SelectedPlayerNum = 1
		end
		self:SelectPlayer(self.Sorted[self.SelectedPlayerNum], self.SelectedPlayerNum)
	end

	local BottomBar = vgui.Create("DPanel", Canvas)
	BottomBar:SetSize(Canvas:GetWide(), 50)
	BottomBar:SetPos(0, Canvas:GetTall() - BottomBar:GetTall())
	BottomBar.Paint = function(slf)
		surface.SetDrawColor(0, 0, 0, 210)
		surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
		surface.SetDrawColor(255, 255, 255, 210)
		surface.DrawRect(0, 0, slf:GetWide(), 2)
		draw.SimpleText(Canvas.SelectedPlayer and Canvas.SelectedPlayer:Name() or "Niemand ausgewählt", "MG_CarDealer_TrebLW_S40", slf:GetWide() / 2, slf:GetTall() / 2, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	local Button_Left = vgui.Create("CarDealer_DSWButton", BottomBar)
	Button_Left:SetPos(BottomBar:GetWide() / 2 - 300, 5)
	Button_Left:SetSize(40, 40)
	Button_Left:SetTexts("<")
	Button_Left.BoarderCol = Color(0, 0, 0, 0)
	Button_Left.Click = function(slf)
		Canvas:SelectNextPlayer(-1)
	end
	local Button_Right = vgui.Create("CarDealer_DSWButton", BottomBar)
	Button_Right:SetPos(BottomBar:GetWide() / 2 + 260, 5)
	Button_Right:SetSize(40, 40)
	Button_Right:SetTexts(">")
	Button_Right.BoarderCol = Color(0, 0, 0, 0)
	Button_Right.Click = function(slf)
		Canvas:SelectNextPlayer(1)
	end
	local LookupButton = vgui.Create("CarDealer_DSWButton", Canvas)
	LookupButton:SetSize(250, 50)
	LookupButton:SetPos(BottomBar:GetWide() / 2 - 125, Canvas:GetTall() - BottomBar:GetTall() - 60)
	LookupButton:SetTexts("Garage dieses Spielers öffnen")
	LookupButton.Click = function(slf)
		if LookupButton.Text != "Garage wird geladen..." then
			LookupButton:SetTexts("Garage wird geladen...")
			if IsValid(Canvas.SelectedPlayer) then
				MG_CarDealer.GetPlayerData(Canvas.SelectedPlayer:SteamID())
			else
				MG_CarDealer.ShowNotice("Dieser Spieler existiert nicht!")
				Canvas:SelectNextPlayer(-1)
			end
		end
	end
	local PlayerInfoLister = vgui.Create("DPanelList", Canvas)
	Canvas.PlayerInfoLister = PlayerInfoLister
	PlayerInfoLister:SetSize(300, Canvas:GetTall() - 100)
	PlayerInfoLister:SetPos(Canvas:GetWide() - PlayerInfoLister:GetWide() - 20, 20)
	PlayerInfoLister:EnableVerticalScrollbar(true)
	PlayerInfoLister:EnableHorizontal(false)
	PlayerInfoLister:MG_CarDealer_PaintListBarC()
	local PlayerListBG = vgui.Create("DPanel", Canvas)
	PlayerListBG:SetSize(300, Canvas:GetTall() - 150)
	PlayerListBG:SetPos(20, 20)
	local count = player.GetCount()
	PlayerListBG.Paint = function(slf)
		surface.SetDrawColor(Color(0, 0, 0, 255))
		surface.DrawRect(0, 0, slf:GetWide(), 40)
		draw.SimpleText("Verfügbare Spieler ("..count..")", "MG_CarDealer_TrebLW_S30", 10, 20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end
	local PlayerList = vgui.Create("DPanelList", PlayerListBG)
	Canvas.PlayerList = PlayerList
	PlayerList:SetPos(0, 80)
	PlayerList:SetSize(PlayerListBG:GetWide(), PlayerListBG:GetTall() - 80)
	PlayerList:EnableVerticalScrollbar(true)
	PlayerList:EnableHorizontal(false)
	PlayerList:MG_CarDealer_PaintListBarC()
	local SteamIDSearch = vgui.Create("CarDealer_DSWButton", Canvas)
	Canvas.SteamIDSearch = SteamIDSearch
	SteamIDSearch:SetPos(330, 20)
	SteamIDSearch:SetSize(PlayerListBG:GetWide(), 50)
	SteamIDSearch:SetTexts("Garage über SteamID öffnen")
	SteamIDSearch.Click = function()
		MG_CarDealer.ShowSearch("Bitte gebe hier die SteamID des Spielers an:", function(id)
			id = string.upper(string.Trim(id))
			if id:match("^(STEAM_[0-9]+:[0-9]+:[0-9]+)$") then
				MG_CarDealer.GetPlayerData(id)
			else
				MG_CarDealer.ShowNotice("Du musst eine gültige SteamID angeben!")
			end
		end)
	end

	function PlayerList:UpdateList(Mode, Asc)
		self:Clear()
		local players = player.GetAll()
		if Mode == 1 then
			if Asc then
				table.sort(players, function(a, b) return a:Name() < b:Name() end)
			else
				table.sort(players, function(a, b) return a:Name() > b:Name() end)
			end
		else
			if Asc then
				table.sort(players, function(a, b) return a:UserID() < b:UserID() end)
			else
				table.sort(players, function(a, b) return a:UserID() > b:UserID() end)
			end
		end
		Canvas.Sorted = players
		for k, v in ipairs(players) do
			local Label = vgui.Create("DButton")
			Label:SetTall(30)
			Label.DoClick = function(slf)
				surface.PlaySound("ui/buttonclick.wav")
				Canvas:SelectPlayer(v, k)
			end
			Label:SetText("")
			local name = v:Name()
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				if Canvas.SelectedPlayerNum == k then
					surface.SetDrawColor(255, 255, 255, 30)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 255)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				elseif slf:IsHovered() then
					surface.SetDrawColor(255, 255, 255, 5)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 100)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				end
				draw.SimpleText(name, "MG_CarDealer_TrebLW_S25", 10, 15, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			end
			PlayerList:AddItem(Label)
			if !Canvas.FirstInit then
				Canvas.FirstInit = true
				Canvas:SelectPlayer(v, k)
			end
		end
	end
	local Sorter = vgui.Create("DPanel", PlayerListBG)
	Sorter:SetSize(PlayerListBG:GetWide(), 40)
	Sorter:SetPos(0, 40)
	Sorter.Paint = function(slf)
		surface.SetDrawColor(Color(0, 0, 0, 255))
		surface.DrawRect(0, 0, slf:GetWide(), 40)
		surface.SetDrawColor(Color(255, 200, 0, 150))
		surface.DrawRect(0, 38, slf:GetWide(), 2)
	end
	local BTN1 = vgui.Create("CarDealer_DSWButton", Sorter)
	BTN1:SetPos(0, 0)
	BTN1:SetSize(PlayerListBG:GetWide() / 2, 40)
	BTN1:SetTexts("Name")
	BTN1.BoarderCol = Color(0, 0, 0, 0)
	BTN1.BGCol = Color(0, 0, 0, 0)
	BTN1.Toggle = true
	local BTN2 = vgui.Create("CarDealer_DSWButton", Sorter)
	BTN2:SetPos(PlayerListBG:GetWide() / 2, 0)
	BTN2:SetSize(PlayerListBG:GetWide() / 2, 40)
	BTN2:SetTexts("Onlinezeit")
	BTN2.BoarderCol = Color(0, 0, 0, 0)
	BTN2.BGCol = Color(0, 0, 0, 0)
	BTN2.Toggle = false
	BTN1.Click = function(slf)
		slf.Toggle = !slf.Toggle
		BTN2.Toggle = false
		BTN2:SetTexts("Onlinezeit")
		if slf.Toggle then
			BTN1:SetTexts("Name ▽")
		else
			BTN1:SetTexts("Name △")
		end
		PlayerList:UpdateList(1, slf.Toggle)
	end
	BTN2.Click = function(slf)
		slf.Toggle = !slf.Toggle
		BTN1.Toggle = false
		BTN1:SetTexts("Name")
		if slf.Toggle then
			BTN2:SetTexts("Onlinezeit ▽")
		else
			BTN2:SetTexts("Onlinezeit △")
		end
		PlayerList:UpdateList(2, slf.Toggle)
	end
	PlayerList:UpdateList(1, true)
	BTN1:SetTexts("Name ▽")
end

concommand.Add("car_dealer_admin", function()
	local ply = LocalPlayer()
	if MG_CarDealerConfig:IsSuperAdmin(ply) then
		print("Gehe aus dem Hauptmenü raus, um in die Adminübersicht zu gelangen.")
		if IsValid(MG_CarDealerShopPanel) then MG_CarDealerShopPanel:Remove() end
		MG_CarDealer_Inventory = nil
		MG_CarDealerShopPanel = vgui.Create("CarDealer_CarShop")
		MG_CarDealerShopPanel:SetPos(0, 0)
		MG_CarDealerShopPanel:SetSize(ScrW(), ScrH())
		MG_CarDealerShopPanel.SellerNPC = npc
		MG_CarDealerShopPanel:Install(true)
		MG_CarDealerShopPanel:MakePopup()
		MG_CarDealerShopPanel:ParentToHUD()
		MG_CarDealerShopPanel.Think = function()
			if !ply:Alive() then
				MG_CarDealerShopPanel:Close()
			end
		end
		MG_CarDealerShopPanel.StoreButton:Remove()
		MG_CarDealerShopPanel.ShopButton:Remove()
		MG_CarDealerShopPanel.InvButton:Remove()
	end
end)

function PANEL:FreeCamMode()
	local Canvas = self:ReBuildCanvas()
	Canvas.Name = "Freie Sicht"
	Canvas.CantSpin = true
	Canvas.Paint = function(slf)
		self.BGBackGroundPanel.CamAngle.r = 0
		local speed = 1
		if input.IsKeyDown(KEY_LSHIFT) then
			speed = speed * 2
		end
		if input.IsKeyDown(KEY_W) then
			self.BGBackGroundPanel.CamPos = self.BGBackGroundPanel.CamPos + self.BGBackGroundPanel.CamAngle:Forward() * speed
		end
		if input.IsKeyDown(KEY_S) then
			self.BGBackGroundPanel.CamPos = self.BGBackGroundPanel.CamPos - self.BGBackGroundPanel.CamAngle:Forward() * speed
		end
		if input.IsKeyDown(KEY_A) then
			self.BGBackGroundPanel.CamPos = self.BGBackGroundPanel.CamPos - self.BGBackGroundPanel.CamAngle:Right() * speed
		end
		if input.IsKeyDown(KEY_D) then
			self.BGBackGroundPanel.CamPos = self.BGBackGroundPanel.CamPos + self.BGBackGroundPanel.CamAngle:Right() * speed
		end
		if input.IsKeyDown(KEY_SPACE) then
			self.BGBackGroundPanel.CamPos = self.BGBackGroundPanel.CamPos + self.BGBackGroundPanel.CamAngle:Up() * speed
		end
		if input.IsMouseDown(MOUSE_LEFT) or input.IsMouseDown(MOUSE_RIGHT) then
			if !self.LM then
				self.LM = true
				local MX, MY = gui.MousePos()
				self.LastMousePos_X = MX
				self.LastMousePos_Y = MY
			else
				local CX, CY = gui.MousePos()
				local DX, DY = self.LastMousePos_X-CX, self.LastMousePos_Y-CY
				self.BGBackGroundPanel.CamAngle.p = self.BGBackGroundPanel.CamAngle.p - DY/3
				if self.BGBackGroundPanel.CamAngle.p > 90 then
					self.BGBackGroundPanel.CamAngle.p = 90
				end
				if self.BGBackGroundPanel.CamAngle.p < -90 then
					self.BGBackGroundPanel.CamAngle.p = -90
				end
				self.BGBackGroundPanel.CamAngle.y = self.BGBackGroundPanel.CamAngle.y + DX/6
				self.LastMousePos_X = CX
				self.LastMousePos_Y = CY
			end
		else
			self.LM = false
		end
		self.BGBackGroundPanel.CamPos.x = math.min(self.BGBackGroundPanel.CamPos.x, 350 + (self.BGBackGroundPanel.CargoSize) * 500)
		self.BGBackGroundPanel.CamPos.x = math.max(self.BGBackGroundPanel.CamPos.x, -300)
		self.BGBackGroundPanel.CamPos.y = math.min(self.BGBackGroundPanel.CamPos.y, 350)
		self.BGBackGroundPanel.CamPos.y = math.max(self.BGBackGroundPanel.CamPos.y, -350)
		self.BGBackGroundPanel.CamPos.z = math.min(self.BGBackGroundPanel.CamPos.z, 240)
		self.BGBackGroundPanel.CamPos.z = math.max(self.BGBackGroundPanel.CamPos.z, 10)
		draw.SimpleText("W A S D: Bewegen", "MG_CarDealer_TrebOut_S22", 20, slf:GetTall() - 80, color_white)
		draw.SimpleText("Linksklick gedrückt halten: Drehen", "MG_CarDealer_TrebOut_S22", 20, slf:GetTall() - 40, color_white)
		draw.SimpleText("Shift: Beschleunigen", "MG_CarDealer_TrebOut_S22", 20, slf:GetTall() - 60, color_white)
	end
end

function PANEL:BuildShop()
	local ply = LocalPlayer()
	local MainPanel = self
	local Canvas = self:ReBuildCanvas()
	Canvas.Name = "Autohändler"
	Canvas.Paint = function(slf)
		draw.SimpleText("Du hast $"..string.Comma((ply:getDarkRPVar("money") or 0))..".", "MG_CarDealer_TrebOut_S25", 20, slf:GetTall() - 80, color_white)
		if MG_CarDealerConfig.AutoCam then
			self.BGBackGroundPanel.CamPos = LerpVector(RealFrameTime() * MG_CarDealerConfig.AutoCamSpeed, self.BGBackGroundPanel.CamPos, Vector(280, 0, 120))
			self.BGBackGroundPanel.CamAngle = LerpAngle(RealFrameTime() * MG_CarDealerConfig.AutoCamSpeed, self.BGBackGroundPanel.CamAngle, (Vector(-250, 0, 0) - self.BGBackGroundPanel.CamPos):Angle())
		end
	end

	local Sorted = {}
	function Canvas:AddCategories()
		MG_CarDealerShopPanel.SelectedShopCarNum = nil
		MG_CarDealerShopPanel.SelectedShopCarData = nil
		MainPanel.BGBackGroundPanel:SetCar()
		self.CarInfoLister:Clear()

		PANEL.ShopFunc = nil
		Canvas.Mode = "Category"
		Sorted = {}
		for cat, cardata in pairs(MG_CarDealer.Util_GetCategories()) do
			table.insert(Sorted, {key = cat, Name = cat, cardata = cardata})
		end
		Canvas.CategoryCount = #Sorted
		Canvas.CarList:AddSorter()
		Canvas.CarList:UpdateList(nil, "Name", true)
	end

	function Canvas:AddCars(category)
		MG_CarDealerShopPanel.SelectedShopCarNum = nil
		MG_CarDealerShopPanel.SelectedShopCarData = nil
		PANEL.ShopFunc = true
		Canvas.Mode = "Cars"
		Canvas.Category = category or "Alle Autos"
		Sorted = {}
		for k, v in ipairs(MG_CarDealer.Util_GetCategory(category) or MG_CarDealerConfig.Cars or {}) do
			if category and category != v.Category then continue end
			local class = v.CarClass
			if !MG_CarDealer.Util_GetVehicleData(class) then continue end
			local cardata = MG_CarDealer.Util_GetCarData(class)
			if !cardata then continue end
			local tab = cardata.AvailableMap
			if tab and !table.HasValue(tab, game.GetMap()) then continue end
			local func = cardata.CanSee
			if func and func(ply) == false then continue end
			table.insert(Sorted, {key = k, value = v, Name = v.CarName, Price = v.CarPrice, Color = (cardata.CanSee and Color(200, 0, 255) or cardata.AvailableMap and Color(0, 255, 0) or cardata.AvailableGroup and Color(255, 200, 50) or cardata.AvailableTeam and Color(255, 100, 100))})
		end
		Canvas.CarCount = #Sorted
		Canvas.CarList:AddSorter(category or "Alle Autos")
		Canvas.CarList:UpdateList(category or "Alle Autos", "Name", true)
	end

	function Canvas:SelectCar(num)
		local sorted = Sorted[num]
		if !sorted then
			sorted = Sorted[1]
			num = 1
			if !sorted then return end
		end
		if Canvas.SelectedCar and MG_CarDealerShopPanel.SelectedShopCarData == sorted.value then return end
		Canvas.SelectedCar = true
		MG_CarDealerShopPanel.SelectedShopCarNum = num
		MG_CarDealerShopPanel.SelectedShopCarData = sorted.value
		MG_CarDealerShopPanel.SelectedShopVehicleData = MG_CarDealer.Util_GetVehicleData(MG_CarDealerShopPanel.SelectedShopCarData.CarClass)
		MainPanel.BGBackGroundPanel:SetCar(MG_CarDealerShopPanel.SelectedShopCarData.CarClass, MG_CarDealerShopPanel.SelectedShopVehicleData, true)
		MainPanel.BGBackGroundPanel:SetTuneData(nil)
		local BGPanelCarEntity = MainPanel.BGBackGroundPanel:GetCarEntity()
		self.CarInfoLister:Clear()
		CreateTitle(self, MG_CarDealerShopPanel.SelectedShopCarData.CarName, sorted.Color)
		local Label = vgui.Create("DPanel")
		Label:SetTall(40)
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Preis:", "MG_CarDealer_TrebLW_S25", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText("$"..string.Comma(MG_CarDealerShopPanel.SelectedShopCarData.CarPrice), "MG_CarDealer_TrebLW_S25", slf:GetWide() - 10, slf:GetTall() / 2, ply:canAfford(MG_CarDealerShopPanel.SelectedShopCarData.CarPrice) and Color(0, 255, 0, 255) or Color(255, 50, 0, 255), TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		if MG_CarDealerShopPanel.SelectedShopCarData.Description then
			CreateTitle(self, "Beschreibung")
			local Label
			local Panel = vgui.Create("DPanel")
			Panel.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				slf:SetTall(Label:GetTall())
				surface.DrawRect(0, 0, slf:GetWide(), Label:GetTall())
			end
			Label = vgui.Create("DLabel", Panel)
			Label:SetPos(3, 0)
			Label:SetSize(297, 20)
			Label:SetWrap(true)
			Label:SetAutoStretchVertical(true)
			Label:SetText(MG_CarDealerShopPanel.SelectedShopCarData.Description)
			Label:SetColor(subtextcolor)
			Label:SetFont("MG_CarDealer_TrebLWOut_S20")
			Label.Paint = function(slf)
			end
			self.CarInfoLister:AddItem(Panel)
		end
		CreateTitle(self, "Aussehen")
		local Label = vgui.Create("DPanel")
		Label:SetTall(30)
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Skins:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText(MG_CarDealerShopPanel.SelectedShopCarData.NoSkin and 0 or BGPanelCarEntity:SkinCount() - 1, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		local Label = vgui.Create("DPanel")
		Label:SetTall(30)
		local count = 0
		for i=0, BGPanelCarEntity:GetNumBodyGroups() -1 do
			if MG_CarDealerShopPanel.SelectedShopCarData.BodygroupBlacklist and MG_CarDealerShopPanel.SelectedShopCarData.BodygroupBlacklist[BGPanelCarEntity:GetBodygroupName(i)] then continue end
			local cnt = BGPanelCarEntity:GetBodygroupCount(i)
			if cnt <= 1 then continue end
			count = count + 1
		end
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Körpergruppen:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText(MG_CarDealerShopPanel.SelectedShopCarData.NoBodygroup and 0 or count, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		local trunk = MG_Trunk and (MG_Trunk.CustomTrunkSizes[MG_CarDealerShopPanel.SelectedShopCarData.CarClass] or MG_Trunk.TrunkSize)
		if trunk and trunk > 0 or istable(MG_CarDealerShopPanel.SelectedShopCarData.AvailableTeam) and !table.IsEmpty(MG_CarDealerShopPanel.SelectedShopCarData.AvailableTeam) then
			CreateTitle(self, "Datenblatt")
		end
		if istable(MG_CarDealerShopPanel.SelectedShopCarData.AvailableTeam) and !table.IsEmpty(MG_CarDealerShopPanel.SelectedShopCarData.AvailableTeam) then
			local Label = vgui.Create("DPanel")
			Label:SetTall(30)
			local teams = ""
			local cnt = 0
			for k, v in ipairs(MG_CarDealerShopPanel.SelectedShopCarData.AvailableTeam) do
				cnt = cnt + 1
				teams = team.GetName(v)..(cnt != k  and ", " or "")
			end
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Benötigt:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText(teams, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if trunk and trunk > 0 then
			local Label = vgui.Create("DPanel")
			Label:SetTall(30)
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Stauraum:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText(trunk == 1 and "1 Platz" or trunk.." Plätze", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		CreateTitle(self, "Kauf")
		local allowed, _, reason = ply:MG_CarDealer_CanBuyCar(MG_CarDealerShopPanel.SelectedShopCarData.CarClass)
		if allowed then
			local Button_BuyToINV = vgui.Create("CarDealer_DSWButton")
			Button_BuyToINV:SetTall(40)
			Button_BuyToINV:SetTexts("Kaufen & in Garage abstellen")
			Button_BuyToINV.BoarderCol = Color(0, 0, 0, 0)
			Button_BuyToINV.Click = function(slf)
				MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto für $" ..string.Comma(MG_CarDealerShopPanel.SelectedShopCarData.CarPrice).. " kaufen möchtest?", function()
					MG_CarDealer.BuyVehicle(MG_CarDealerShopPanel.SelectedShopCarData.CarClass)
				end)
			end
			self.CarInfoLister:AddItem(Button_BuyToINV)
		else
			local Label = vgui.Create("DPanel")
			Label:SetTall(40)
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(bgcolor.r, bgcolor.g, bgcolor.b, 255))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText(reason, "MG_CarDealer_TrebLW_S30", 10, slf:GetTall() / 2, Color(255, 50, 0, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
	end

	function Canvas:SelectNextCar(int)
		if !MG_CarDealerShopPanel.SelectedShopCarNum then return end
		MG_CarDealerShopPanel.SelectedShopCarNum = MG_CarDealerShopPanel.SelectedShopCarNum + int
		local sorted = #self.Sorted
		if MG_CarDealerShopPanel.SelectedShopCarNum <= 0 then
			MG_CarDealerShopPanel.SelectedShopCarNum = sorted
		end
		if MG_CarDealerShopPanel.SelectedShopCarNum > sorted then
			MG_CarDealerShopPanel.SelectedShopCarNum = 1
		end
		self:SelectCar(MG_CarDealerShopPanel.SelectedShopCarNum)
	end

	local BottomBar = vgui.Create("DPanel", Canvas)
	BottomBar:SetSize(Canvas:GetWide(), 50)
	BottomBar:SetPos(0, Canvas:GetTall() - BottomBar:GetTall())
	BottomBar.Paint = function(slf)
		surface.SetDrawColor(0, 0, 0, 210)
		surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
		surface.SetDrawColor(255, 255, 255, 210)
		surface.DrawRect(0, 0, slf:GetWide(), 2)
		if MG_CarDealerShopPanel.SelectedShopCarData then
			draw.SimpleText(MG_CarDealerShopPanel.SelectedShopCarData.CarName, "MG_CarDealer_TrebLW_S40", slf:GetWide() / 2, slf:GetTall() / 2, Sorted[MG_CarDealerShopPanel.SelectedShopCarNum].Color or color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
	end
	local CarInfoLister = vgui.Create("DPanelList", Canvas)
	Canvas.CarInfoLister = CarInfoLister
	CarInfoLister:SetSize(300, Canvas:GetTall() - 100)
	CarInfoLister:SetPos(Canvas:GetWide() - CarInfoLister:GetWide() - 20, 20)
	CarInfoLister:EnableVerticalScrollbar(true)
	CarInfoLister:EnableHorizontal(false)
	CarInfoLister:MG_CarDealer_PaintListBarC()
	local CarsListBG = vgui.Create("DPanel", Canvas)
	CarsListBG:SetSize(300, Canvas:GetTall() - 200)
	CarsListBG:SetPos(20, 20)
	CarsListBG.Paint = function(slf)
		surface.SetDrawColor(color_black)
		surface.DrawRect(0, 0, slf:GetWide(), 40)
		if Canvas.Mode == "Cars" then
			draw.SimpleText(Canvas.Category.." ("..(Canvas.CarCount or 0)..")", "MG_CarDealer_TrebLW_S30", 10, 20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		else
			draw.SimpleText("Kategorie auswählen ("..(Canvas.CategoryCount or 0)..")", "MG_CarDealer_TrebLW_S30", 10, 20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		end
	end
	local CarList = vgui.Create("DPanelList", CarsListBG)
	Canvas.CarList = CarList
	CarList:SetPos(0, 80)
	CarList:SetSize(CarsListBG:GetWide(), CarsListBG:GetTall() - 80)
	CarList:EnableVerticalScrollbar(true)
	CarList:EnableHorizontal(false)
	CarList:MG_CarDealer_PaintListBarC()

	function CarList:UpdateList(Category, Mode, Asc)
		self:Clear()

		Mode = Mode or "Name"
		table.SortByMember(Sorted, Mode, Asc)
		Canvas.Sorted = Sorted
		local last = !Category and #Sorted

		local all_count = !Category and #MG_CarDealerConfig.Cars
		if Category then
			local Label = vgui.Create("DButton")
			Label:SetTall(30)
			Label.DoClick = function(slf)
				surface.PlaySound("ui/buttonclick.wav")
				Canvas:AddCategories()
			end
			Label:SetText("")
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				if slf:IsHovered() then
					surface.SetDrawColor(255, 255, 255, 5)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 100)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				end
				draw.SimpleText("◀ Kategorie auswählen", "MG_CarDealer_TrebLW_S25", 10, 15, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				surface.SetDrawColor(50, 50, 50, 255)
				surface.DrawLine(0, slf:GetTall() - 1, slf:GetWide(), slf:GetTall() - 1)
			end
			CarList:AddItem(Label)
		else
			local Label = vgui.Create("DButton")
			Label:SetTall(50)
			Label.DoClick = function(slf)
				surface.PlaySound("ui/buttonclick.wav")
				Canvas:AddCars()
			end
			Label:SetText("")
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				if slf:IsHovered() then
					surface.SetDrawColor(255, 255, 255, 5)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 100)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				end
				draw.SimpleText("Alle Autos", "MG_CarDealer_TrebLW_S25", 10, 15, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText("Verfügbare Autos: "..all_count, "MG_CarDealer_TrebLW_S19", 10, 38, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				surface.SetDrawColor(50, 50, 50, 255)
				surface.DrawLine(0, slf:GetTall() - 1, slf:GetWide(), slf:GetTall() - 1)
			end
			CarList:AddItem(Label)
		end

		for order, data in pairs(Sorted) do
			local value = data.value
			local Label = vgui.Create("DButton")
			Label:SetTall(Category and 30 or 50)
			Label.DoClick = function(slf)
				surface.PlaySound("ui/buttonclick.wav")
				if Category then
					Canvas:SelectCar(order)
				else
					Canvas:AddCars(data.Name)
				end
			end
			Label:SetText("")
			local car_count = #(data.cardata or {})
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				if Category and MG_CarDealerShopPanel.SelectedShopCarNum == order then
					surface.SetDrawColor(255, 255, 255, 30)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 255)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				elseif slf:IsHovered() then
					surface.SetDrawColor(255, 255, 255, 5)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 100)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				end
				if Category then
					draw.SimpleText(value.CarName, "MG_CarDealer_TrebLW_S25", 10, 15, data.Color or Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				else
					draw.SimpleText(data.Name, "MG_CarDealer_TrebLW_S25", 10, 15, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
					draw.SimpleText("Verfügbare Autos: "..car_count, "MG_CarDealer_TrebLW_S19", 10, 38, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
					if order < last then
						surface.SetDrawColor(50, 50, 50, 255)
						surface.DrawLine(0, slf:GetTall() - 1, slf:GetWide(), slf:GetTall() - 1)
					end
				end
			end
			CarList:AddItem(Label)
		end
		if Category then
			Canvas:SelectCar(MG_CarDealerShopPanel.SelectedShopCarNum)
		end
	end

	function CarList:ClearSorter()
		if IsValid(Canvas.Button_Left) then
			Canvas.Button_Left:Remove()
		end
		if IsValid(Canvas.Button_Right) then
			Canvas.Button_Right:Remove()
		end
		if IsValid(Canvas.Sorter) then
			Canvas.Sorter:Remove()
		end
	end

	function CarList:AddSorter(Category)
		Canvas.CarList:ClearSorter()
		local Sorter = vgui.Create("DPanel", CarsListBG)
		Canvas.Sorter = Sorter
		Sorter:SetSize(CarsListBG:GetWide(), 40)
		Sorter:SetPos(0, 40)
		Sorter.Paint = function(slf)
			surface.SetDrawColor(color_black)
			surface.DrawRect(0, 0, slf:GetWide(), 40)
			surface.SetDrawColor(Color(255, 200, 0, 150))
			surface.DrawRect(0, 38, slf:GetWide(), 2)
		end
		local BTN2
		local BTN1 = vgui.Create("CarDealer_DSWButton", Sorter)
		BTN1:SetPos(0, 0)
		BTN1:SetSize(Category and CarsListBG:GetWide() / 2 or CarsListBG:GetWide(), 40)
		BTN1:SetTexts("Name")
		BTN1.BoarderCol = Color(30, 30, 30)
		BTN1.BGCol = color_black
		BTN1.Toggle = true
		BTN1.Click = function(slf)
			slf.Toggle = !slf.Toggle
			if IsValid(BTN2) then
				BTN2.Toggle = false
				BTN2:SetTexts("Preis")
			end
			if slf.Toggle then
				BTN1:SetTexts("Name ▽")
			else
				BTN1:SetTexts("Name △")
			end
			CarList:UpdateList(Category, "Name", slf.Toggle)
		end
		if Category then
			BTN2 = vgui.Create("CarDealer_DSWButton", Sorter)
			BTN2:SetPos(CarsListBG:GetWide() / 2, 0)
			BTN2:SetSize(CarsListBG:GetWide() / 2, 40)
			BTN2:SetTexts("Preis")
			BTN2.BoarderCol = Color(30, 30, 30)
			BTN2.BGCol = color_black
			BTN2.Toggle = false
			BTN2.Click = function(slf)
				slf.Toggle = !slf.Toggle
				BTN1.Toggle = false
				BTN1:SetTexts("Name")
				if slf.Toggle then
					BTN2:SetTexts("Preis ▽")
				else
					BTN2:SetTexts("Preis △")
				end
				CarList:UpdateList(Category, "Price", slf.Toggle)
			end
			local Button_Left = vgui.Create("CarDealer_DSWButton", BottomBar)
			Canvas.Button_Left = Button_Left
			Button_Left:SetPos(BottomBar:GetWide() / 2 - 300, 5)
			Button_Left:SetSize(40, 40)
			Button_Left:SetTexts("<")
			Button_Left.BoarderCol = Color(0, 0, 0, 0)
			Button_Left.Click = function(slf)
				Canvas:SelectNextCar(-1)
			end
			local Button_Right = vgui.Create("CarDealer_DSWButton", BottomBar)
			Canvas.Button_Right = Button_Right
			Button_Right:SetPos(BottomBar:GetWide() / 2 + 260, 5)
			Button_Right:SetSize(40, 40)
			Button_Right:SetTexts(">")
			Button_Right.BoarderCol = Color(0, 0, 0, 0)
			Button_Right.Click = function(slf)
				Canvas:SelectNextCar(1)
			end
		end
		BTN1:SetTexts("Name ▽")
	end

	if car_dealer_categoryautoselect:GetBool() then
		Canvas:AddCars()
	else
		Canvas:AddCategories()
	end
end

local function GenerateSellPrice(self, data)
	local armored = data.armored and data.armored != "NULL" and (MG_CarDealerShopPanel.SelectedCarInvData.CarPrice * MG_CarDealerConfig.ArmorUpgradeCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local extrafuel = data.extrafuel and data.extrafuel != "NULL" and (MG_CarDealerShopPanel.SelectedCarInvData.CarPrice * MG_CarDealerConfig.FuelUpgradeCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local bulletproof = data.bulletproof and data.bulletproof != "NULL" and (MG_CarDealerShopPanel.SelectedCarInvData.CarPrice * MG_CarDealerConfig.BulletProofCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local vehiclealarm = data.vehiclealarm and data.vehiclealarm != "NULL" and (MG_CarDealerShopPanel.SelectedCarInvData.CarPrice * MG_CarDealerConfig.AlarmCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local lock = data.lock and data.lock != "NULL" and (MG_CarDealerShopPanel.SelectedCarInvData.CarPrice * MG_CarDealerConfig.LockCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	local insurance = data.insurance and data.insurance != "NULL" and (MG_CarDealerShopPanel.SelectedCarInvData.CarPrice * MG_CarDealerConfig.InsuranceCost * MG_CarDealerConfig.UpgradeSellWorth) or 0
	return math.floor((MG_CarDealerShopPanel.SelectedCarInvData.SellPrice or MG_CarDealerShopPanel.SelectedCarInvData.CarPrice * MG_CarDealerConfig.SellPrice) + armored + extrafuel + bulletproof + vehiclealarm + lock + insurance)
end

function PANEL:BuildInventory(forceselect, returndata)
	local ply = LocalPlayer()
	local MainPanel = self
	local Canvas = self:ReBuildCanvas()
	Canvas.Name = "Meine Garage"
	Canvas.Paint = function(slf)
		draw.SimpleText("Du hast $"..string.Comma(ply:getDarkRPVar("money") or 0)..".", "MG_CarDealer_TrebOut_S25", 20, slf:GetTall() - 80, color_white)
		if MG_CarDealerConfig.AutoCam then
			self.BGBackGroundPanel.CamPos = LerpVector(RealFrameTime() * MG_CarDealerConfig.AutoCamSpeed, self.BGBackGroundPanel.CamPos, Vector(-325, 50, 150))
			self.BGBackGroundPanel.CamAngle = LerpAngle(RealFrameTime() * MG_CarDealerConfig.AutoCamSpeed, self.BGBackGroundPanel.CamAngle, (Vector(200, 0, 50) - self.BGBackGroundPanel.CamPos):Angle())
		end
	end

	function Canvas:SelectCar(num)
		local sorted = self.Sorted[num]
		if !sorted then
			sorted = self.Sorted[1]
			num = 1
			if !sorted then return end
		end
		if Canvas.SelectedCar and MG_CarDealerShopPanel.SelectedCarInvNum == num then return end
		local data = sorted.value
		Canvas.SelectedCar = true
		MG_CarDealerShopPanel.SelectedCarInvNum = num
		MG_CarDealerShopPanel.SelectedCarInvID = num
		MG_CarDealerShopPanel.SelectedInvVehicleData = MG_CarDealer.Util_GetVehicleData(data.carclass)
		MG_CarDealerShopPanel.SelectedCarInvData = MG_CarDealer.Util_GetCarData(data.carclass)
		MainPanel.BGBackGroundPanel:SetCar(data.carclass, MG_CarDealerShopPanel.SelectedInvVehicleData, false)
		MainPanel.BGBackGroundPanel:SetTuneData(data.tunedata)
		local BGPanelCarEntity = MainPanel.BGBackGroundPanel:GetCarEntity()
		self.CarInfoLister:Clear()
		CreateTitle(self, MG_CarDealerShopPanel.SelectedCarInvData.CarName, self.Sorted[num].Color)
		local Label = vgui.Create("DPanel")
		Label:SetTall(40)
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Verkaufspreis:", "MG_CarDealer_TrebLW_S25", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText("$"..string.Comma(GenerateSellPrice(self, data)), "MG_CarDealer_TrebLW_S25", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		if MG_CarDealerShopPanel.SelectedCarInvData.Description then
			CreateTitle(self, "Beschreibung")
			local Label
			local Panel = vgui.Create("DPanel")
			Panel.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				slf:SetTall(Label:GetTall())
				surface.DrawRect(0, 0, slf:GetWide(), Label:GetTall())
			end
			Label = vgui.Create("DLabel", Panel)
			Label:SetPos(3, 0)
			Label:SetSize(297, 20)
			Label:SetWrap(true)
			Label:SetAutoStretchVertical(true)
			Label:SetText(MG_CarDealerShopPanel.SelectedCarInvData.Description)
			Label:SetColor(subtextcolor)
			Label:SetFont("MG_CarDealer_TrebLWOut_S20")
			Label.Paint = function(slf)
			end
			self.CarInfoLister:AddItem(Panel)
		end
		CreateTitle(self, "Aussehen")
		local Label = vgui.Create("DPanel")
		Label:SetTall(30)
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Skins:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText(MG_CarDealerShopPanel.SelectedCarInvData.NoSkin and 0 or BGPanelCarEntity:SkinCount() - 1, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		local Label = vgui.Create("DPanel")
		Label:SetTall(30)
		local count = 0
		for i=0, BGPanelCarEntity:GetNumBodyGroups() -1 do
			if MG_CarDealerShopPanel.SelectedCarInvData.BodygroupBlacklist and MG_CarDealerShopPanel.SelectedCarInvData.BodygroupBlacklist[BGPanelCarEntity:GetBodygroupName(i)] then continue end
			local cnt = BGPanelCarEntity:GetBodygroupCount(i)
			if cnt <= 1 then continue end
			count = count + 1
		end
		Label.Paint = function(slf)
			surface.SetDrawColor(bgcolor)
			surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
			draw.SimpleText("Körpergruppen:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			draw.SimpleText(MG_CarDealerShopPanel.SelectedCarInvData.NoBodygroup and 0 or count, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
		end
		self.CarInfoLister:AddItem(Label)
		local trunk = MG_Trunk and (MG_Trunk.CustomTrunkSizes[MG_CarDealerShopPanel.SelectedCarInvData.CarClass] or MG_Trunk.TrunkSize)
		if trunk and trunk > 0 or istable(MG_CarDealerShopPanel.SelectedCarInvData.AvailableTeam) and !table.IsEmpty(MG_CarDealerShopPanel.SelectedCarInvData.AvailableTeam) then
			CreateTitle(self, "Datenblatt")
		end
		if istable(MG_CarDealerShopPanel.SelectedCarInvData.AvailableTeam) and !table.IsEmpty(MG_CarDealerShopPanel.SelectedCarInvData.AvailableTeam) then
			local Label = vgui.Create("DPanel")
			Label:SetTall(30)
			local teams = ""
			local cnt = 0
			for k, v in ipairs(MG_CarDealerShopPanel.SelectedCarInvData.AvailableTeam) do
				cnt = cnt + 1
				teams = team.GetName(v)..(cnt != k  and ", " or "")
			end
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Benötigt:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText(teams, "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if trunk and trunk > 0 then
			local Label = vgui.Create("DPanel")
			Label:SetTall(30)
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Stauraum:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText(trunk == 1 and "1 Platz" or trunk.." Plätze", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if MG_CarDealerConfig.EnableVCMod or MG_CarDealerConfig.EnableMG_VMod then
			CreateTitle(self, "Zustand")
		end
		if MG_CarDealerConfig.EnableVCMod then
			local unlimited = MG_CarDealerShopPanel.SelectedCarInvData.UnlimitedHealth
			local Label = vgui.Create("DPanel")
			Label:SetTall(35)
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Gesundheit:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				local hp = data.health
				local max_hp = data.maxhealth
				if (((!hp or hp == "NULL") and (!max_hp or max_hp == "NULL")) or tonumber(hp) != 0) then
					local perc = unlimited and "∞" or ((!hp or hp == "NULL") or (!max_hp or max_hp == "NULL")) and 100 or math.ceil(tonumber(hp) / tonumber(max_hp) * 100) or 100
					local color = isstring(perc) and Color(200, 200, 200, 255) or perc < 30 and Color(255, 100, 0, 255) or perc < 60 and Color(255, 255, 0, 255) or perc < 80 and Color(150, 255, 0, 255) or perc <= 100 and Color(0, 255, 0, 255) or Color(200, 200, 200, 255)
					draw.SimpleText(!isstring(perc) and (perc.."%") or perc or "100%", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, color, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
				else
					draw.SimpleText("0% (Zerstört)", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, Color(255, 45, 45, 255), TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
				end
			end
			self.CarInfoLister:AddItem(Label)
		end
		if MG_CarDealerConfig.EnableMG_VMod then
			local unlimited = MG_CarDealerShopPanel.SelectedCarInvData.UnlimitedFuel
			local Label = vgui.Create("DPanel")
			Label:SetTall(35)
			Label.Paint = function(slf)
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Tankfülle:", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				local fuel = data.fuel
				local max_fuel = data.maxfuel
				local perc = unlimited and "∞" or ((!fuel or fuel == "NULL") or (!max_fuel or max_fuel == "NULL")) and 100 or math.Round(tonumber(fuel) / tonumber(max_fuel) * 100) or 100
				local color = isstring(perc) and Color(200, 200, 200, 255) or perc < 5 and Color(255, 0, 0, 255) or perc < 25 and Color(255, 100, 0, 255) or perc < 50 and Color(255, 255, 0, 255) or perc < 75 and Color(150, 255, 0, 255) or perc <= 100 and Color(0, 255, 0, 255) or Color(200, 200, 200, 255)
				draw.SimpleText(!isstring(perc) and (perc.."%") or perc or "100%", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, color, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if data.towed and data.towed != "NULL" and tonumber(data.towed) != 0 then
			local Label = vgui.Create("DPanel")
			Label:SetTall(40)
			Label.Paint = function(slf)
				if !data.towed or data.towed == "NULL" then slf:Remove() return end
				surface.SetDrawColor(bgcolor)
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Status: ", "MG_CarDealer_TrebLW_S23", 10, slf:GetTall() / 2, subtextcolor, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw.SimpleText(tonumber(data.towed) == 1 and "Abgeschleppt" or "Gestohlen", "MG_CarDealer_TrebLW_S23", slf:GetWide() - 10, slf:GetTall() / 2, Color(255, 45, 45, 255), TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		end
		if MG_CarDealerConfig.EnableVCMod and !MG_CarDealerShopPanel.SelectedCarInvData.UnlimitedHealth then
			if data.health and data.health != "NULL" and data.maxhealth and data.maxhealth != "NULL" and tonumber(data.health) != tonumber(data.maxhealth) then
				local Button_Repair = vgui.Create("CarDealer_DSWButton")
				Button_Repair:SetTall(40)
				Button_Repair:SetTexts("Reparieren ($"..string.Comma(MG_CarDealerShopPanel.SelectedCarInvData.RepairCost and MG_CarDealerShopPanel.SelectedCarInvData.RepairCost or MG_CarDealerConfig.RepairPrice)..")")
				Button_Repair.BoarderCol = color_black
				Button_Repair.Click = function(slf)
					if ply:canAfford(MG_CarDealerShopPanel.SelectedCarInvData.RepairCost and MG_CarDealerShopPanel.SelectedCarInvData.RepairCost or MG_CarDealerConfig.RepairPrice) then
						MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto für $"..string.Comma(MG_CarDealerShopPanel.SelectedCarInvData.RepairCost and MG_CarDealerShopPanel.SelectedCarInvData.RepairCost or MG_CarDealerConfig.RepairPrice).." reparieren möchtest?", function()
							MG_CarDealer.RepairCar(data.id)
							data.health = nil
							slf:Remove()
						end)
					else
						MG_CarDealer.ShowNotice("Du hast nicht genug Geld für eine Reparatur!")
					end
				end
				self.CarInfoLister:AddItem(Button_Repair)
			end
		end
		if MG_CarDealerConfig.EnableMG_VMod and !MG_CarDealerShopPanel.SelectedCarInvData.UnlimitedFuel then
			if (data.fuel and data.fuel != "NULL" and data.maxfuel and data.maxfuel != "NULL" and tonumber(data.fuel) != tonumber(data.maxfuel)) then
				local Button_Refill = vgui.Create("CarDealer_DSWButton")
				Button_Refill:SetTall(40)
				Button_Refill:SetTexts("Auftanken ($"..string.Comma(MG_CarDealerShopPanel.SelectedCarInvData.RefillCost and MG_CarDealerShopPanel.SelectedCarInvData.RefillCost or MG_CarDealerConfig.RefillPrice)..")")
				Button_Refill.BoarderCol = color_black
				Button_Refill.Click = function(slf)
					if ply:canAfford(MG_CarDealerShopPanel.SelectedCarInvData.RefillCost and MG_CarDealerShopPanel.SelectedCarInvData.RefillCost or MG_CarDealerConfig.RefillPrice) then
						MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto für $"..string.Comma(MG_CarDealerShopPanel.SelectedCarInvData.RefillCost and MG_CarDealerShopPanel.SelectedCarInvData.RefillCost or MG_CarDealerConfig.RefillPrice).." auftanken möchtest?", function()
							MG_CarDealer.RefillCar(data.id)
							data.fuel = nil
							slf:Remove()
						end)
					else
						MG_CarDealer.ShowNotice("Du hast nicht genug Geld für eine Betankung!")
					end
				end
				self.CarInfoLister:AddItem(Button_Refill)
			end
		end
		if data.towed and data.towed != "NULL" and tonumber(data.towed) != 0 then
			local Button_Untow = vgui.Create("CarDealer_DSWButton")
			Button_Untow:SetTall(40)
			Button_Untow:SetTexts("Freikaufen ($"..string.Comma(tonumber(data.towed) == 1 and MG_CarDealerConfig.UntowPrice or MG_CarDealerConfig.RebuyPrice)..")")
			Button_Untow.BoarderCol = color_black
			Button_Untow.Click = function(slf)
				if ply:canAfford(tonumber(data.towed) == 1 and MG_CarDealerConfig.UntowPrice or MG_CarDealerConfig.RebuyPrice) then
					MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto für $"..string.Comma(tonumber(data.towed) == 1 and MG_CarDealerConfig.UntowPrice or MG_CarDealerConfig.RebuyPrice).." frei kaufen möchtest?", function()
						MG_CarDealer.UntowCar(data.id)
						data.towed = nil
						slf:Remove()
					end)
				else
					MG_CarDealer.ShowNotice("Du hast nicht genug Geld für das Freikaufen deines Autos!")
				end
			end
			self.CarInfoLister:AddItem(Button_Untow)
		end
		CreateTitle(self, "Tuning")
		local Button_Tune = vgui.Create("CarDealer_DSWButton")
		Button_Tune:SetTall(40)
		Button_Tune:SetTexts("Anpassung & Verbesserung")
		Button_Tune.BoarderCol = color_black
		Button_Tune.Click = function(slf)
			MainPanel.ActiveWindow = "tune"
			MainPanel:BuildTuner(num, data, data.tunedata != "NULL" and data.tunedata or {}, MG_CarDealerShopPanel.SelectedCarInvData, MG_CarDealer_OldData[num])
		end
		self.CarInfoLister:AddItem(Button_Tune)
		CreateTitle(self, "Verkaufen")
		local Button_Sell = vgui.Create("CarDealer_DSWButton")
		Button_Sell:SetTall(40)
		Button_Sell:SetTexts("Verkaufen")
		Button_Sell.BoarderCol = color_black
		Button_Sell.Click = function(slf)
			MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto für $"..string.Comma(GenerateSellPrice(self, data)).." verkaufen möchtest?", function()
				MG_CarDealer.SellVehicle(data.id)
				self.CarInfoLister:Clear()
				MG_CarDealerShopPanel.SelectedCarInvNum = nil
			end)
		end
		self.CarInfoLister:AddItem(Button_Sell)
		CreateTitle(self, "Fahrt")
		local allowed, _, reason = ply:MG_CarDealer_CanSpawnCar(data.carclass)
		if !allowed then
			local Label = vgui.Create("DPanel")
			Label:SetTall(40)
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(bgcolor.r, bgcolor.g, bgcolor.b, 255))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText(reason, "MG_CarDealer_TrebLW_S30", 10, slf:GetTall() / 2, Color(255, 50, 0, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			end
			self.CarInfoLister:AddItem(Label)
		else
			local Button_Drive = vgui.Create("CarDealer_DSWButton")
			Button_Drive:SetTall(40)
			Button_Drive:SetTexts("Ausfahren"..(MG_CarDealerConfig.DrivePrice > 0 and " ($"..string.Comma(MG_CarDealerConfig.DrivePrice)..")" or ""))
			Button_Drive.BoarderCol = color_black
			Button_Drive.Click = function(slf)
				if (!data.towed or data.towed == "NULL" or tonumber(data.towed) == 0) then
					if (!data.health or data.health == "NULL" or tonumber(data.health) != 0) then
						if (!data.fuel or data.fuel == "NULL" or tonumber(data.fuel) != 0) then
							local allowed, reason = ply:MG_CarDealer_CheckCarLimit()
							if allowed then
								if MG_CarDealerConfig.DrivePrice > 0 then
									MG_CarDealer.ShowAsker("Bist du dir sicher, dass du dieses Auto für $"..string.Comma(MG_CarDealerConfig.DrivePrice).." ausfahren möchtest?", function()
										if !IsValid(MainPanel.SellerNPC) then return end
										MG_CarDealer.Switch2CarSpawner(data.id, BGPanelCarEntity:GetModel(), BGPanelCarEntity:GetSkin(), MainPanel.SellerNPC)
										MainPanel:Remove()
									end)
								else
										if !IsValid(MainPanel.SellerNPC) then return end
										MG_CarDealer.Switch2CarSpawner(data.id, BGPanelCarEntity:GetModel(), BGPanelCarEntity:GetSkin(), MainPanel.SellerNPC)
										MainPanel:Remove()
								end
							else
								MG_CarDealer.ShowNotice(reason)
							end
						else
							MG_CarDealer.ShowNotice("Dieses Auto hat kein Benzin mehr!")
						end
					else
						MG_CarDealer.ShowNotice("Dieses Auto ist zerstört!")
					end
				else
					MG_CarDealer.ShowNotice("Dein Auto befindet sich nicht in der Garage, kaufe es vorerst wieder frei!")
				end
			end
			self.CarInfoLister:AddItem(Button_Drive)
		end
	end

	function Canvas:SelectNextCar(int)
		if !MG_CarDealerShopPanel.SelectedCarInvID then return end
		MG_CarDealerShopPanel.SelectedCarInvID = MG_CarDealerShopPanel.SelectedCarInvID + int
		local sorted = #self.Sorted
		if MG_CarDealerShopPanel.SelectedCarInvID <= 0 then
			MG_CarDealerShopPanel.SelectedCarInvID = sorted
		end
		if MG_CarDealerShopPanel.SelectedCarInvID > sorted then
			MG_CarDealerShopPanel.SelectedCarInvID = 1
		end
		local data = self.Sorted[MG_CarDealerShopPanel.SelectedCarInvID]
		if !data then return end
		self:SelectCar(MG_CarDealerShopPanel.SelectedCarInvID)
	end

	local BottomBar = vgui.Create("DPanel", Canvas)
	BottomBar:SetSize(Canvas:GetWide(), 50)
	BottomBar:SetPos(0, Canvas:GetTall() - BottomBar:GetTall())
	BottomBar.Paint = function(slf)
		surface.SetDrawColor(0, 0, 0, 210)
		surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
		surface.SetDrawColor(255, 255, 255, 210)
		surface.DrawRect(0, 0, slf:GetWide(), 2)
		if MG_CarDealerShopPanel.SelectedCarInvData then
			draw.SimpleText(MG_CarDealerShopPanel.SelectedCarInvData.CarName, "MG_CarDealer_TrebLW_S40", slf:GetWide() / 2, slf:GetTall() / 2, Canvas.Sorted[MG_CarDealerShopPanel.SelectedCarInvID] and Canvas.Sorted[MG_CarDealerShopPanel.SelectedCarInvID].Color or Color(255, 255, 255, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
	end
	local Button_Left = vgui.Create("CarDealer_DSWButton", BottomBar)
	Button_Left:SetPos(BottomBar:GetWide()/2 - 300, 5)
	Button_Left:SetSize(40, 40)
	Button_Left:SetTexts("<")
	Button_Left.BoarderCol = color_black
	Button_Left.Click = function(slf)
		Canvas:SelectNextCar(-1)
	end
	local Button_Right = vgui.Create("CarDealer_DSWButton", BottomBar)
	Button_Right:SetPos(BottomBar:GetWide()/2 + 260, 5)
	Button_Right:SetSize(40, 40)
	Button_Right:SetTexts(">")
	Button_Right.BoarderCol = color_black
	Button_Right.Click = function(slf)
		Canvas:SelectNextCar(1)
	end
	local CarInfoLister = vgui.Create("DPanelList", Canvas)
	Canvas.CarInfoLister = CarInfoLister
	CarInfoLister:SetSize(300, Canvas:GetTall() - 100)
	CarInfoLister:SetPos(Canvas:GetWide() - CarInfoLister:GetWide() - 20, 20)
	CarInfoLister:EnableVerticalScrollbar(true)
	CarInfoLister:EnableHorizontal(false)
	CarInfoLister:MG_CarDealer_PaintListBarC()
	local CarsListBG = vgui.Create("DPanel", Canvas)
	CarsListBG:SetSize(300, Canvas:GetTall() - 200)
	CarsListBG:SetPos(20, 20)
	CarsListBG.Paint = function(slf)
		surface.SetDrawColor(color_black)
		surface.DrawRect(0, 0, slf:GetWide(), 40)
		draw.SimpleText("Autos in Besitz", "MG_CarDealer_TrebLW_S30", 10, 20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end
	local CarList = vgui.Create("DPanelList", CarsListBG)
	Canvas.CarList = CarList
	CarList.CarInventoryList = true
	CarList:SetPos(0, 40)
	CarList:SetSize(CarsListBG:GetWide(), CarsListBG:GetTall() - 40)
	CarList:EnableVerticalScrollbar(true)
	CarList:EnableHorizontal(false)
	CarList:MG_CarDealer_PaintListBarC()

	function CarList:UpdateList()
		self:Clear()
		local Sorted = {}
		for k, v in ipairs(MG_CarDealer_Inventory or {}) do
			if !MG_CarDealer.Util_GetVehicleData(v.carclass) then continue end
			local cardata = MG_CarDealer.Util_GetCarData(v.carclass)
			if !cardata then continue end
			table.insert(Sorted, {key = k, value = v, Name = cardata.CarName, Color = (cardata.CanSee and Color(200, 0, 255) or cardata.AvailableMap and Color(0, 255, 0) or cardata.AvailableGroup and Color(255, 200, 50) or cardata.AvailableTeam and Color(255, 100, 100))})
		end
		Canvas.Sorted = Sorted
		local selected
		local max_cnt = #Sorted
		local cnt = 0
		for k, data in ipairs(Sorted) do
			cnt = cnt + 1
			local value = data.value
			local cardata = MG_CarDealer.Util_GetCarData(value.carclass)
			local Label = vgui.Create("DButton")
			Label:SetTall(30)
			Label.DoClick = function(slf)
				surface.PlaySound("ui/buttonclick.wav")
				Canvas:SelectCar(k)
			end
			Label:SetText("")
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				if MG_CarDealerShopPanel.SelectedCarInvNum == k then
					surface.SetDrawColor(255, 255, 255, 30)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 255)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				elseif slf:IsHovered() then
					surface.SetDrawColor(255, 255, 255, 5)
					surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
					surface.SetDrawColor(255, 255, 255, 100)
					surface.DrawRect(0, 0, 5, slf:GetTall())
				end
				draw.SimpleText(cardata.CarName, "MG_CarDealer_TrebLW_S25", 10, 15, data.Color or Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			end
			self:AddItem(Label)
			if forceselect and k == forceselect then
				Sorted[k].value = returndata
				Canvas.Sorted[k].value = returndata
				selected = true
				Canvas:SelectCar(k)
			end
			if !selected and k == max_cnt then
				Canvas:SelectCar(MG_CarDealerShopPanel.SelectedCarInvNum)
			end
		end
		if !MG_CarDealer_Inventory then
			local Label = vgui.Create("DButton")
			Label:SetTall(30)
			Label.DoClick = function()
			end
			Label:SetText("")
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Autos werden geladen...", "MG_CarDealer_TrebLW_S25", 10, 15, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			end
			self:AddItem(Label)
		elseif cnt <= 0 then
			local Label = vgui.Create("DButton")
			Label:SetTall(30)
			Label.DoClick = function()
			end
			Label:SetText("")
			Label.Paint = function(slf)
				surface.SetDrawColor(Color(0, 0, 0, 250))
				surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
				draw.SimpleText("Keine Autos verfügbar...", "MG_CarDealer_TrebLW_S25", 10, 15, Color(210, 210, 210, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
			end
			self:AddItem(Label)
		end
	end
	CarList:UpdateList()
end

function PANEL:UpdateCargoCars()
	self.BGBackGroundPanel:UpdateCargoCars()
end

function PANEL:Install(admin)
	self.BGBackGroundPanel = vgui.Create("CarDealer_CarShop_BGBackGround", self)
	self.BGBackGroundPanel:SetSize(self:GetWide() - 4, self:GetTall() - 4)
	self.BGBackGroundPanel.Mother = self
	self.BGBackGroundPanel:Center()
	self.BGBackGroundPanel:Install()
	local TopPanel = vgui.Create("DPanel", self)
	self.TopPanel = TopPanel
	TopPanel:SetPos(0, 0)
	TopPanel:SetSize(self:GetWide(), 50)
	TopPanel.Paint = function(slf)
		surface.SetDrawColor(0, 0, 0, 240)
		surface.DrawRect(0, 0, slf:GetWide(), slf:GetTall())
		surface.SetDrawColor(255, 255, 255, 210)
		surface.DrawRect(0, slf:GetTall() - 2, slf:GetWide(), 2)
		local Name = "Autohändler"
		if self.Canvas and self.Canvas.Name then
			Name = self.Canvas.Name
		end
		draw.SimpleText(Name, "MG_CarDealer_Treb_S40", 10, 5, color_white)
	end
	local CloseButton = vgui.Create("CarDealer_DSWButton", TopPanel)
	self.CloseButton = CloseButton
	CloseButton:SetPos(TopPanel:GetWide() - 140, 10)
	CloseButton:SetSize(120, TopPanel:GetTall() - 12)
	CloseButton:SetTexts("Schließen")
	CloseButton.BoarderCol = Color(0, 0, 0, 0)
	CloseButton.BGCol = Color(0, 0, 0, 0)
	CloseButton.Click = function(slf)
		self:Remove()
	end
	local StoreButton = vgui.Create("CarDealer_DSWButton", TopPanel)
	self.StoreButton = StoreButton
	StoreButton:SetPos(TopPanel:GetWide() - 280, 10)
	StoreButton:SetSize(120, TopPanel:GetTall() - 12)
	StoreButton:SetTexts("Auto verstauen")
	StoreButton.BoarderCol = Color(0, 0, 0, 0)
	StoreButton.BGCol = Color(0, 0, 0, 0)
	StoreButton.Click = function(slf)
		if !IsValid(self.SellerNPC) then return end
		MG_CarDealer.Switch2CarStorer(self.SellerNPC)
		self:Remove()
	end
	local ShopButton = vgui.Create("CarDealer_DSWButton", TopPanel)
	self.ShopButton = ShopButton
	ShopButton:SetPos(TopPanel:GetWide() - 420, 10)
	ShopButton:SetSize(120, TopPanel:GetTall() - 12)
	ShopButton:SetTexts("Shop")
	ShopButton.BoarderCol = Color(0, 0, 0, 0)
	ShopButton.BGCol = Color(0, 0, 0, 0)
	ShopButton.Click = function(slf)
		if self.ActiveWindow == "shop" and !PANEL.ShopFunc then return end
		self.ActiveWindow = "shop"
		self:BuildShop()
	end
	local InvButton = vgui.Create("CarDealer_DSWButton", TopPanel)
	self.InvButton = InvButton
	InvButton:SetPos(TopPanel:GetWide() - 560, 10)
	InvButton:SetSize(120, TopPanel:GetTall() - 12)
	InvButton:SetTexts("Garage")
	InvButton.BoarderCol = Color(0, 0, 0, 0)
	InvButton.BGCol = Color(0, 0, 0, 0)
	InvButton.Click = function(slf)
		if self.ActiveWindow == "inv" then return end
		self.ActiveWindow = "inv"
		self:BuildInventory()
	end
	local FreeCamButton = vgui.Create("CarDealer_DSWButton", TopPanel)
	self.FreeCamButton = FreeCamButton
	FreeCamButton:SetPos(TopPanel:GetWide() - 700, 10)
	FreeCamButton:SetSize(120, TopPanel:GetTall() - 12)
	FreeCamButton:SetTexts("Freie Sicht")
	FreeCamButton.BoarderCol = Color(0, 0, 0, 0)
	FreeCamButton.BGCol = Color(0, 0, 0, 0)
	FreeCamButton.Click = function(slf)
		if self.ActiveWindow == "cam" then return end
		self.ActiveWindow = "cam"
		self:FreeCamMode()
	end
	if MG_CarDealerConfig:IsSuperAdmin(LocalPlayer()) then
		local AdminViewButton = vgui.Create("CarDealer_DSWButton", TopPanel)
		self.AdminViewButton = AdminViewButton
		AdminViewButton:SetPos(TopPanel:GetWide() - 840, 10)
		AdminViewButton:SetSize(120, TopPanel:GetTall() - 12)
		AdminViewButton:SetTexts("Adminübersicht")
		AdminViewButton.BoarderCol = Color(0, 0, 0, 0)
		AdminViewButton.BGCol = Color(0, 0, 0, 0)
		AdminViewButton.Click = function(slf)
			self:BuildAdminView()
		end
	end
	if admin then
		self:BuildAdminView()
	else
		if car_dealer_startininventory:GetBool() then
			self.ActiveWindow = "inv"
			self:BuildInventory()
		else
			self.ActiveWindow = "shop"
			self:BuildShop()
		end
	end
end
vgui.Register("CarDealer_CarShop", PANEL, "DFrame")

local function GetCreatedMaterialM(dir)
	local params = {
		["$basetexture"] = dir,
		["$model"] = 1
	}
	local name = "mg_cdealer_"..dir
	return name
end

local WorldProps = {}
table.insert(WorldProps,{
	Model = "models/mechanics/wheels/wheel_speed_72.mdl",
	Material = GetCreatedMaterialM("phoenix_storms/gear"),
	Pos = Vector(0, 0, 0),
	Angle = Angle(0, 0, 0),
	Size = Vector(4, 4, 0.1),
	Color = Color(200, 200, 200, 255)
})

table.insert(WorldProps,{
	Model = "models/mechanics/wheels/wheel_speed_72.mdl",
	Material = GetCreatedMaterialM("phoenix_storms/dome"),
	Pos = Vector(0, 0, 1),
	Angle = Angle(0, 0, 0),
	Size = Vector(3.8, 3.8, 0.1),
	Color = Color(100, 100, 100, 255)
})

table.insert(WorldProps,{
	Model = "models/props_wasteland/controlroom_desk001a.mdl",
	Pos = Vector(-350, 0, 17),
	Angle = Angle(0, 180, 0),
	Size = Vector(1, 1, 1),
	Color = color_white
})

table.insert(WorldProps,{
	Model = "models/props_lab/clipboard.mdl",
	Pos = Vector(-350, 0, 34),
	Angle = Angle(0, 78, 0),
	Size = Vector(2, 2, 1),
	Color = color_white
})

table.insert(WorldProps,{
	Model = "models/props_wasteland/gaspump001a.mdl",
	Pos = Vector(-200, 200, 0),
	Angle = Angle(0, 0, 0),
	Size = Vector(1, 1, 1),
	Color = color_white
})

local PANEL = {}
function PANEL:Init()
	self.CamPos = (car_dealer_startininventory:GetBool() and Vector(-325, 50, 150) or Vector(280, 0, 120)) + Vector(20, 0, 5)
	self.CamAngle = ((car_dealer_startininventory:GetBool() and Vector(200, 0, 50) or Vector(0, 0, 30)) - self.CamPos):Angle()
	self.CarCModel = ClientsideModel("models/props_junk/popcan01a.mdl")
	self.CarCModel:SetNoDraw(true)
	self.CarXModel = ClientsideModel("models/props_junk/popcan01a.mdl")
	self.CarXModel:SetNoDraw(true)
	self.RollSpeed = 10
	self.CarAngle = Angle(0, 0, 0)
	self.TuneData = {}
	self.CargoSize = 0
	self.InventoryCars = {}
end

function PANEL:UpdateCargoCars(admin)
	self.InventoryCars = {}
	local count = 0
	for _, v in ipairs((admin and current_player_cars) or MG_CarDealer_Inventory or {}) do
		local vehdata = MG_CarDealer.Util_GetVehicleData(v.carclass)
		if !vehdata then continue end
		if !MG_CarDealer.Util_GetCarData(v.carclass) then continue end
		count = count + 1
		table.insert(self.InventoryCars, {vdata = vehdata, tunedata = v.tunedata})
	end
	self:SetCargoSize(math.ceil(count / 2))
end

function PANEL:SetCargoSize(int)
	int = math.min(int, MG_CarDealerConfig.GTA5GarageMaxSize / 2)
	self.CargoSize = int
end

function PANEL:GetCarEntity()
	return self.CarCModel
end

local clientside_models = {}
local clientside_car
local clientside_platform
local clientside_platform2
function PANEL:OnRemove()
	SafeRemoveEntity(self.CarCModel)
	SafeRemoveEntity(self.CarXModel)
	for _, v in pairs(clientside_models) do
		SafeRemoveEntity(v)
	end
	clientside_models = {}
	SafeRemoveEntity(clientside_platform)
	SafeRemoveEntity(clientside_platform2)
end

local vector_up = Vector(0, 0, 1)
local mat = GetCreatedMaterialM("phoenix_storms/dome")
local mat2 = GetCreatedMaterialM("phoenix_storms/gear")
function PANEL:RenderAdditionalCars()
	if self.ActiveWindow != MG_CarDealerShopPanel.ActiveWindow or MG_CarDealerShopPanel.ReloadCars then
		MG_CarDealerShopPanel.ReloadCars = nil
		self:UpdateCargoCars(MG_CarDealerShopPanel.ActiveWindow == "player_inv")
		self.ActiveWindow = MG_CarDealerShopPanel.ActiveWindow
	end
	local platform = clientside_platform
	if !IsValid(platform) then
		clientside_platform = ClientsideModel("models/mechanics/wheels/wheel_speed_72.mdl")
		platform = clientside_platform
		if !IsValid(platform) then return end
		platform:SetRenderAngles(angle_zero)
		platform:SetMaterial(mat)
		local matrix = Matrix()
		if matrix then
			matrix:Scale(Vector(3.8, 3.8, 0.1))
			platform:EnableMatrix("RenderMultiply", matrix)
		end
	end
	local platform2 = clientside_platform2
	if !IsValid(platform2) then
		clientside_platform2 = ClientsideModel("models/mechanics/wheels/wheel_speed_72.mdl")
		platform2 = clientside_platform2
		if !IsValid(platform2) then return end
		platform2:SetRenderAngles(angle_zero)
		platform2:SetMaterial(mat2)
		local matrix = Matrix()
		if matrix then
			matrix:Scale(Vector(4, 4, 0.1))
			platform2:EnableMatrix("RenderMultiply", matrix)
		end
	end
	local cnt = 0
	for k = 1, self.CargoSize do
		for c = 0, 1 do
			cnt = cnt + 1
			local pos = Vector(100 + 500 * k, 230 - c * 460, 0)
			platform2:SetRenderOrigin(pos)
			platform2:SetupBones()
			render.SetColorModulation(0.8, 0.8, 0.8)
			platform2:DrawModel()
			platform:SetRenderOrigin(pos + vector_up)
			platform:SetupBones()
			render.SetColorModulation(0.4, 0.4, 0.4)
			platform:DrawModel()
			render.SetColorModulation(1, 1, 1)
			local invcar = self.InventoryCars[cnt]
			if invcar then
				self:RenderCar(pos, Angle(0, 140 - 100 * c, 0), invcar.vdata.Model, invcar.tunedata, true)
			end
		end
	end
end

local function GetCreatedMaterialK(dir)
	local params = {
		["$basetexture"] = dir,
		["$ignorez"] = 0
	}
	return CreateMaterial("mg_cdealer_"..dir, "UnlitGeneric", params)
end

local MAT_WALL = GetCreatedMaterialK("metal/metalwall018f")
local MAT_CEIL = GetCreatedMaterialK("tile/prodceilingtilea")
local MAT_FLOOR = GetCreatedMaterialK("tile/tilefloor016a")
function PANEL:DrawWorldTexture()
	render.SetMaterial(MAT_CEIL)
	for x=0, 2 + (self.CargoSize * 2) do
		for y=0, 2 do
			render.DrawQuadEasy(Vector(-250 + 250 * x, -250 + 250 * y, 250), Angle(179.9, 90, 0):Up(), 250, 250, color_white, 0)
		end
	end
	render.SetMaterial(MAT_FLOOR)
	for x=0, 2 + (self.CargoSize * 2) do
		for y=0, 2 do
			render.DrawQuadEasy(Vector(-250 + 250 * x, -250 + 250 * y, 0), Angle(0, 90, 0):Up(), 250, 250, color_white, 0)
		end
	end
	render.SetMaterial(MAT_WALL)
	for i=0, 2 do
		render.DrawQuadEasy(Vector(-375, -250 + 250 * i, 125), Angle(90, 0, 0):Up(), 250, 250, color_white, 180)
		render.DrawQuadEasy(Vector(375 + self.CargoSize * 500, -250 + 250 * i, 125), Angle(90, 180, 0):Up(), 250, 250, color_white, 180)
	end
	for i=0, 2 + (self.CargoSize * 2) do
		render.DrawQuadEasy(Vector(-250 + 250 * i, -375, 125), Angle(0, 0, 270):Up(), 250, 250, color_white, 180)
		render.DrawQuadEasy(Vector(-250 + 250 * i, 375, 125), Angle(0, 0, 90):Up(), 250, 250, color_white, 180)
	end
end

local glow1 = Material("sprites/gmdm_pickups/light")
function PANEL:Draw3DWorld()
	local sys_time = SysTime()
	self:DrawWorldTexture()
	self:RenderAdditionalCars()
	cam.Start3D2D(Vector(-370, -53, 165), Angle(0, 90, 90), 0.3)
		draw.SimpleText("Modern Roleplay", "MG_CarDealer_TrebOut_S50", 10, 0, color_white)
	cam.End3D2D()
	cam.Start3D2D(Vector(-370, -100, 150), Angle(0, 90, 90), 0.35)
		draw.SimpleText("Autohändler", "MG_CarDealer_TrebOut_S120", 10, 0, color_white)
	cam.End3D2D()
	for k, v in ipairs(WorldProps) do
		local model = clientside_models[k]
		if !IsValid(model) then
			clientside_models[k] = ClientsideModel(v.Model)
			model = clientside_models[k]
			if !IsValid(model) then continue end
			local sang = Angle(0, 0, 0)
			model:SetModel(v.Model)
			model:SetRenderOrigin(v.Pos)
			sang:RotateAroundAxis(sang:Forward(), v.Angle.r)
			sang:RotateAroundAxis(sang:Right(), v.Angle.p)
			sang:RotateAroundAxis(sang:Up(), v.Angle.y)
			model:SetRenderAngles(sang)
			model:SetMaterial(v.Material)
			if v.Size then
				local mat = Matrix()
				mat:Scale(v.Size)
				model:EnableMatrix("RenderMultiply", mat)
			end
			if v.ModelScale then
				model:SetModelScale(v.ModelScale, 0)
			end
		end
		render.SetColorModulation(v.Color.r / 255, v.Color.g / 255, v.Color.b / 255)
		render.SetBlend(v.Color.a / 255)
		model:SetupBones()
		model:DrawModel()
	end
	render.SetColorModulation(1, 1, 1)
	render.SetBlend(1)
	render.SetMaterial(glow1)
	local ang = (sys_time * 120) % 360
	local ck = math.sin(sys_time * 5)
	for a = 0, 1 do
		for k = 1, 40 do
			render.DrawQuadEasy(vector_up + Angle(0, ang + k + a * 180, 0):Forward() * 141, vector_up, 20, 20, Color(0, 150 + ck * 100, 255), 0)
		end
	end
	local vector_3 = Vector(0, 0, 3)
	local ang = (sys_time * -70) % 360
	for a = 0, 1 do
		for k = 1, 40 do
			render.DrawQuadEasy(vector_3 + Angle(0, ang + k + a * 180, 0):Forward() * 130, vector_up, 20, 20, Color(0, 150 + ck * 100, 255), 0)
		end
	end
end

function PANEL:CantSpin()
	if self.Mother and self.Mother.Canvas and self.Mother.Canvas.CantSpin then return true end
	return false
end

function PANEL:RenderCar(pos_override, ang_override, model_override, tune_override, override)
	if !self:CantSpin() then
		self.CarAngle.y = self.CarAngle.y + self.RollSpeed * RealFrameTime() * 0.5
	end
	if !self.CarData or !self.CarClass then return end
	local tunedata = tune_override or self.TuneData
	tunedata.Color = tunedata.Color or color_white
	local selectedmodel = override and self.CarXModel or self.CarCModel
	local usemodel = model_override or self.MainCarModel

	selectedmodel:SetModel(usemodel)
	if override then
		for k in pairs(selectedmodel:GetBodyGroups()) do
			if tunedata.BodyGroups and tunedata.BodyGroups[k] then
				selectedmodel:SetBodygroup(k, tunedata.BodyGroups[k])
			else
				selectedmodel:SetBodygroup(k, 0)
			end
		end
		selectedmodel:SetSkin(tunedata.SkinNumber or 0)
	end

	local pos_to_use = pos_override or Vector(0, 0, 0)
	if MG_CarDealerConfig.PositionModifier[usemodel] then
		pos_to_use = pos_to_use + Vector(0, 0, MG_CarDealerConfig.PositionModifier[usemodel])
	end

	selectedmodel:SetRenderOrigin(pos_to_use)
	selectedmodel:SetRenderAngles(ang_override or self.CarAngle)

	render.SetColorModulation(tunedata.Color.r / 255, tunedata.Color.g / 255, tunedata.Color.b / 255)

	selectedmodel:SetupBones()
	selectedmodel:DrawModel()
	render.SetColorModulation(1, 1, 1)
	for _, v in pairs(tunedata.Elements or {}) do
		local element = MG_CarDealer_Tuners[v.Type]
		if element then
			local vars = v.Vars
			element:Render(selectedmodel, vars)
			element:RenderOnEditor(selectedmodel, vars)
		end
	end
end

function PANEL:Paint()
	local x, y = self:LocalToScreen(0, 0)
	local w, h = self:GetSize()
	cam.Start3D(self.CamPos, self.CamAngle, 70, x, y, w, h)
		render.SuppressEngineLighting(true)
		self:Draw3DWorld()
		self:RenderCar()
		render.SuppressEngineLighting(false)
	cam.End3D()
end

function PANEL:SetCar(carclass, vehicle, isshoppreview)
	self.CarCModel:SetModel(!carclass and "" or (vehicle.Model or vehicle.CarModel))
	self.MainCarModel = carclass and (vehicle.Model or vehicle.CarModel)
	self.IsShopPreview = carclass and isshoppreview
	self.CarClass = carclass
	self.CarData = carclass and MG_CarDealer.Util_GetCarData(carclass)
end

function PANEL:SetTuneData(data)
	data = data or {}
	MG_CarDealer.InitTuneData(data)
	self.TuneData = data
	self.BodyGroups = data.BodyGroups or {}
	self.SkinNumber = data.SkinNumber or 0
	for k in pairs(self.CarCModel:GetBodyGroups()) do
		self.CarCModel:SetBodygroup(k, self.BodyGroups[k] or 0)
	end
	self.CarCModel:SetSkin(self.SkinNumber)
end

function PANEL:Install()
	self.TuneData = {}
	self.TuneData.Color = Color(255, 255, 255, 255)
end

vgui.Register("CarDealer_CarShop_BGBackGround", PANEL, "DPanel")