local STR = MG_CarDealer.TunerElement_CreateStruct("head_light")
STR.PrintName = "Modifizierte Scheinwerfer"
STR.Icon = "transmit"
STR.Max = 2

local KEY = STR:AddVars("Tasten", "optionselect")
KEY:AddOption(IN_ATTACK, {PrintName = "Linksklick"})
KEY:AddOption(IN_ATTACK2, {PrintName = "Rechtsklick"})
KEY:AddOption(IN_WALK, {PrintName = "Bewegen"})
KEY:AddOption(IN_SPEED, {PrintName = "Sprinten"})
KEY:AddOption(IN_RELOAD, {PrintName = "Nachladen"})
KEY:AddOption(IN_JUMP, {PrintName = "Springen"})
KEY:AddOption(IN_DUCK, {PrintName = "Ducken"})
KEY:AddOption(IN_WALK, {PrintName = "Schleichen"})

local VAR = STR:AddVars("Position_X", "number")
VAR.Min = -100
VAR.Max = 100
local VAR = STR:AddVars("Position_Y", "number")
VAR.Min = -150
VAR.Max = 150
local VAR = STR:AddVars("Position_Z", "number")
VAR.Min = -100
VAR.Max = 100
VAR.StartValue = 50
local VAR = STR:AddVars("Winkel_P", "number")
VAR.Min = 0
VAR.Max = 360 
local VAR = STR:AddVars("Winkel_Y", "number")
VAR.Min = 0
VAR.Max = 360 

local MAT_LIGHT = Material("sprites/gmdm_pickups/light")
local MAT_BEAM = Material("sprites/physgbeamb")
function STR:SV_KeyPressed(tunesys, vars, key)
	local ply = vars["Tasten"]
	if ply and key == ply then
		tunesys.ToggleLight = tunesys.ToggleLight or false
		if (tunesys.RearLightSwitchDelay or 0) < SysTime() then
			tunesys.RearLightSwitchDelay = SysTime() + 0.1
			if tunesys.ToggleLight then
				tunesys.ToggleLight = false
			else
				tunesys.ToggleLight = true
			end
		end
		tunesys:SetNW2Bool("ToggleLight", tunesys.ToggleLight)
		tunesys.Lights = tunesys.Lights or {}
		if !tunesys.ToggleLight then
			for _,v in ipairs(tunesys.Lights) do
				v:Remove()
			end
			tunesys.Lights = {}
		else
			local pos = tunesys:GetPos()
			local ang = tunesys:GetAngles()
			pos = pos + ang:Forward() * vars["Position_X"]
			pos = pos + ang:Right() * vars["Position_Y"]
			pos = pos + ang:Up() * vars["Position_Z"]	
			local fl = ents.Create("env_projectedtexture")
			if !IsValid(fl) then return end
			fl:SetParent(tunesys)
			fl:SetPos(pos)
			fl:SetAngles(ang + Angle(vars["Winkel_P"], vars["Winkel_Y"], 0))
			fl:SetKeyValue("enableshadows", 1)
			fl:SetKeyValue("nearz", 5)
			fl:SetKeyValue("farz", 3000)
			fl:SetKeyValue("lightfov", 60)
			local ck = color_white
			fl:SetKeyValue("lightcolor", Format("%i %i %i 255", ck.r, ck.g, ck.b))
			fl:Spawn()
			table.insert(tunesys.Lights, fl)
		end
	end
end
	
function STR:Render(tunesys, vars, force)
	if !force and !tunesys:GetNW2Bool("ToggleLight") then return end
	local pos = tunesys:GetPos() 
	local ang = tunesys:GetAngles()
	pos = pos + ang:Forward() * vars["Position_X"]
	pos = pos + ang:Right() * vars["Position_Y"]
	pos = pos + ang:Up() * vars["Position_Z"]	
	render.SetMaterial(MAT_LIGHT)
	local ang = EyeAngles():Forward() * -1
	local dang = MG_CarDealer.Get3DWorldCamAngle()
	if dang then ang = dang:Forward() end
	render.DrawQuadEasy(pos, ang, 150, 150, color_white, 90) 
end
	
function STR:RenderOnEditor(tunesys, vars)
	self:Render(tunesys, vars, true)
	render.SetMaterial(MAT_BEAM)
	local pos = tunesys:GetPos()
	local ang = tunesys:GetAngles()
	pos = pos + ang:Forward() * vars["Position_X"]
	pos = pos + ang:Right() * vars["Position_Y"]
	pos = pos + ang:Up() * vars["Position_Z"]
	local angk = Angle(vars["Winkel_P"], vars["Winkel_Y"], 0)
	angk = angk + tunesys:GetAngles()
	local pos2 = pos + angk:Forward() * 50
	render.DrawBeam(pos, pos2, 1, 1, 1, color_white) 
	render.DrawBeam(pos2, pos2 + angk:Right() * 5 - angk:Forward() * 5, 1, 1, 1, color_white) 
	render.DrawBeam(pos2, pos2 - angk:Right() * 5 - angk:Forward() * 5, 1, 1, 1, color_white) 
end

TunerElement.Register(STR)