local STR = MG_CarDealer.TunerElement_CreateStruct("horn")
STR.PrintName = "Modifizierte Hupe"
STR.Icon = "music"
STR.Max = 1

local KEY = STR:AddVars("Tasten", "optionselect")
KEY:AddOption(IN_ATTACK, {PrintName = "Linksklick"})
KEY:AddOption(IN_ATTACK2, {PrintName = "Rechtsklick"})
KEY:AddOption(IN_WALK, {PrintName = "Bewegen"})
KEY:AddOption(IN_SPEED, {PrintName = "Sprinten"})
KEY:AddOption(IN_RELOAD, {PrintName = "Nachladen"})
KEY:AddOption(IN_JUMP, {PrintName = "Springen"})
KEY:AddOption(IN_DUCK, {PrintName = "Ducken"})
KEY:AddOption(IN_WALK, {PrintName = "Schleichen"})

local SOUND = STR:AddVars("Töne", "optionselect")
SOUND:AddOption("vcmod/horn/general_lee.wav", {PrintName = "General Lee", PlayTime = 3.2})
SOUND:AddOption("mg_mp3/clown_horn.wav", {PrintName = "Clownshupe", PlayTime = 2})
SOUND:AddOption("vcmod/horn/heavy.wav", {PrintName = "LKW", PlayTime = 0.8})
SOUND:AddOption("vcmod/horn/light.wav", {PrintName = "Laut", PlayTime = 0.7})
SOUND:AddOption("vcmod/horn/simple.wav", {PrintName = "Leise", PlayTime = 0.7})
SOUND:AddOption("vcmod/horn/simple2.wav", {PrintName = "Ruhig", PlayTime = 0.7})

function STR:SV_KeyPressed(tunesys, vars, key)
	local ply = vars["Tasten"]
	if ply and key == ply then
		local sound = vars["Töne"]
		if sound and (tunesys.HornSoundDelay or 0) < CurTime() then
			local time = self.Vars["Töne"] and self.Vars["Töne"].Options[sound] and self.Vars["Töne"].Options[sound].DataTable.PlayTime or 10
			tunesys.HornSoundDelay = CurTime() + time + 0.5
			if tunesys.SoundObject then
				tunesys.SoundObject:Stop()
				tunesys.SoundObject = nil
			end
			local filter = RecipientFilter()
			filter:AddAllPlayers()
			tunesys.SoundObject = CreateSound(tunesys, sound, filter)
			if sound == "vcmod/horn/general_lee.wav" then
				tunesys.SoundObject:SetSoundLevel(65)
			else
				tunesys.SoundObject:SetSoundLevel(75)
			end
			tunesys.SoundObject:Play()
			timer.Create("MG_CarDealer_StopSound_"..tunesys:EntIndex(), time, 1, function()
				if tunesys.SoundObject then
					tunesys.SoundObject:Stop()
					tunesys.SoundObject = nil
				end
			end)
		end
	end
end

TunerElement.Register(STR)